/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import workbench.db.AbstractConstraintReader;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableConstraint;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;

public class OracleConstraintReader
extends AbstractConstraintReader {
    private final String TABLE_SQL = "-- SQL Workbench \nSELECT " + OracleUtils.getCacheHint() + " constraint_name, search_condition, status, validated \nFROM all_constraints cons   \nWHERE constraint_type = 'C' \n and owner = ? \n and table_name = ?  \n";

    public OracleConstraintReader(String string) {
        super(string);
    }

    @Override
    public int getIndexForSchemaParameter() {
        return 1;
    }

    @Override
    public int getIndexForCatalogParameter() {
        return -1;
    }

    @Override
    public int getIndexForTableNameParameter() {
        return 2;
    }

    @Override
    public String getColumnConstraintSql() {
        return null;
    }

    @Override
    public String getTableConstraintSql() {
        return this.TABLE_SQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableConstraint> getTableConstraints(WbConnection wbConnection, TableDefinition tableDefinition) {
        String string = this.getTableConstraintSql();
        if (string == null) {
            return null;
        }
        List<TableConstraint> list = CollectionUtil.arrayList();
        TableIdentifier tableIdentifier = tableDefinition.getTable();
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "table constraints", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
        try {
            long l = System.currentTimeMillis();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                String string5 = resultSet.getString(4);
                if (string3 == null || this.hideTableConstraint(string2, string3, tableDefinition.getColumns())) continue;
                String string6 = "(" + string3 + ")";
                if ("DISABLED".equalsIgnoreCase(string4)) {
                    string6 = string6 + " DISABLE";
                }
                if ("NOT VALIDATED".equalsIgnoreCase(string5)) {
                    string6 = string6 + " NOVALIDATE";
                }
                TableConstraint tableConstraint = new TableConstraint(string2, string6);
                tableConstraint.setIsSystemName(this.isSystemConstraintName(string2));
                list.add(tableConstraint);
            }
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, "Retrieving table constraints for " + tableIdentifier.getFullyQualifiedName(null) + " took " + l2 + "ms");
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "table constraints", string, tableIdentifier.getRawSchema(), tableIdentifier.getRawTableName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return list;
    }

    protected boolean hideTableConstraint(String string, String string2, List<ColumnIdentifier> list) {
        boolean bl = this.isSystemConstraintName(string);
        try {
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(ParserType.Oracle, (CharSequence)string2);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken == null) {
                return false;
            }
            if (!sQLToken.isIdentifier()) {
                return false;
            }
            String string3 = SqlUtil.removeObjectQuotes(sQLToken.getText());
            ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(list, string3);
            if (columnIdentifier == null) {
                return false;
            }
            sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken == null) {
                return false;
            }
            SQLToken sQLToken2 = sQLLexer.getNextToken(false, false);
            if (sQLToken2 != null) {
                return false;
            }
            if ("IS NOT NULL".equalsIgnoreCase(sQLToken.getContents())) {
                if (columnIdentifier.isNullable()) {
                    String string4 = "CHECK (" + string2 + ")";
                    if (bl) {
                        columnIdentifier.setConstraint(string4);
                    } else {
                        columnIdentifier.setConstraint("CONSTRAINT " + string + " " + string4);
                    }
                } else if (!bl) {
                    columnIdentifier.setConstraint("CONSTRAINT " + string + " NOT NULL");
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

