/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.db.ConstraintDefinition;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.UniqueConstraintReader;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OracleUniqueConstraintReader
implements UniqueConstraintReader {
    private final Map<String, DataStore> constraintCache = new TreeMap<String, DataStore>(CaseInsensitiveComparator.INSTANCE);

    @Override
    public void readUniqueConstraints(TableIdentifier tableIdentifier, List<IndexDefinition> list, WbConnection wbConnection) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        if (wbConnection == null) {
            return;
        }
        DataStore dataStore = this.retrieveConstraints(list, wbConnection);
        if (dataStore == null) {
            return;
        }
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string = dataStore.getValueAsString(i, "index_name");
            String string2 = dataStore.getValueAsString(i, "constraint_name");
            String string3 = dataStore.getValueAsString(i, "deferrable");
            String string4 = dataStore.getValueAsString(i, "deferred");
            String string5 = dataStore.getValueAsString(i, "status");
            String string6 = dataStore.getValueAsString(i, "validated");
            IndexDefinition indexDefinition = IndexDefinition.findIndex(list, string, null);
            if (indexDefinition == null) continue;
            if (indexDefinition.isPrimaryKeyIndex()) {
                indexDefinition.setEnabled(StringUtil.equalStringIgnoreCase(string5, "ENABLED"));
                indexDefinition.setValid(StringUtil.equalStringIgnoreCase(string6, "VALIDATED"));
                continue;
            }
            ConstraintDefinition constraintDefinition = ConstraintDefinition.createUniqueConstraint(string2);
            constraintDefinition.setDeferrable(StringUtil.equalStringIgnoreCase("DEFERRABLE", string3));
            constraintDefinition.setInitiallyDeferred(StringUtil.equalStringIgnoreCase("DEFERRED", string4));
            constraintDefinition.setEnabled(StringUtil.equalStringIgnoreCase(string5, "ENABLED"));
            constraintDefinition.setValid(StringUtil.equalStringIgnoreCase(string6, "VALIDATED"));
            indexDefinition.setUniqueConstraint(constraintDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore retrieveConstraints(List<IndexDefinition> list, WbConnection wbConnection) {
        CharSequence charSequence;
        DataStore dataStore;
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        if (wbConnection == null) {
            return null;
        }
        if (Settings.getInstance().getBoolProperty("workbench.db.oracle.uniqueconstraints.useglobalcache", false) && (dataStore = this.getConstraintsFromCache(list, wbConnection)) != null) {
            return dataStore;
        }
        boolean bl = this.hasMultipleOwners(list);
        boolean bl2 = true;
        String string = "all_constraints";
        if (!bl && OracleUtils.optimizeCatalogQueries() && (StringUtil.isEmptyString(charSequence = list.get(0).getSchema()) || ((String)charSequence).equalsIgnoreCase(wbConnection.getCurrentUser()))) {
            string = "user_constraints";
            bl2 = false;
        }
        charSequence = new StringBuilder(500);
        ((StringBuilder)charSequence).append("-- SQL Workbench \nselect " + OracleUtils.getCacheHint() + " index_name, constraint_name, deferrable, deferred, status, validated \nfrom " + string + " \nwhere constraint_type = 'U' \n  and ");
        if (this.hasMultipleOwners(list)) {
            this.appendMultiOwnerQuery((StringBuilder)charSequence, list);
        } else {
            this.appendSingleOwnerQuery((StringBuilder)charSequence, list, bl2);
        }
        CallerInfo callerInfo = new CallerInfo(){};
        LogMgr.logMetadataSql(callerInfo, "unique constraints", charSequence, new Object[0]);
        long l = System.currentTimeMillis();
        Statement statement = null;
        ResultSet resultSet = null;
        DataStore dataStore2 = null;
        try {
            statement = wbConnection.createStatement();
            resultSet = statement.executeQuery(((StringBuilder)charSequence).toString());
            dataStore2 = new DataStore(resultSet, true);
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(callerInfo, sQLException, "unique constraints", charSequence, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(callerInfo, "Retrieving unique constraints took: " + l2 + "ms");
        return dataStore2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore getConstraintsFromCache(List<IndexDefinition> list, WbConnection wbConnection) {
        Map<String, DataStore> map = this.constraintCache;
        synchronized (map) {
            DataStore dataStore = null;
            Set<String> set = this.getOwners(list);
            for (String string : set) {
                DataStore dataStore2 = this.constraintCache.get(string);
                if (dataStore2 == null) {
                    dataStore2 = this.getConstraintsForOwner(string, wbConnection);
                }
                if (dataStore == null) {
                    dataStore = dataStore2.createCopy(true);
                    continue;
                }
                dataStore.copyFrom(dataStore2);
            }
            return dataStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataStore getConstraintsForOwner(String string, WbConnection wbConnection) {
        DataStore dataStore;
        String string2 = "-- SQL Workbench \nselect index_name, constraint_name, deferrable, deferred, status, validated \nfrom all_constraints \nwhere constraint_type = 'U'and index_owner = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "constraints", string2, string);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            DataStore dataStore2 = new DataStore(resultSet, true);
            this.constraintCache.put(string, dataStore2);
            LogMgr.logDebug(new CallerInfo(){}, "Caching unique constraint information for owner: " + string);
            dataStore = dataStore2;
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "constraints", string2, string);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return null;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    private Set<String> getOwners(List<IndexDefinition> list) {
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        for (IndexDefinition indexDefinition : list) {
            set.add(indexDefinition.getSchema());
        }
        return set;
    }

    private boolean hasMultipleOwners(List<IndexDefinition> list) {
        return this.getOwners(list).size() > 1;
    }

    private void appendMultiOwnerQuery(StringBuilder stringBuilder, List<IndexDefinition> list) {
        int n = 0;
        stringBuilder.append(" (");
        for (IndexDefinition indexDefinition : list) {
            if (n > 0) {
                stringBuilder.append(" OR ");
            }
            String string = SqlUtil.removeObjectQuotes(indexDefinition.getSchema());
            String string2 = SqlUtil.removeObjectQuotes(indexDefinition.getObjectName());
            stringBuilder.append(" (nvl(index_owner, '");
            stringBuilder.append(string);
            stringBuilder.append("'), index_name) = (('");
            stringBuilder.append(string);
            stringBuilder.append("', '");
            stringBuilder.append(string2);
            stringBuilder.append("')) ");
            ++n;
        }
        stringBuilder.append(')');
    }

    private void appendSingleOwnerQuery(StringBuilder stringBuilder, List<IndexDefinition> list, boolean bl) {
        String string = SqlUtil.removeObjectQuotes(list.get(0).getSchema());
        if (bl) {
            stringBuilder.append("nvl(index_owner,'");
            stringBuilder.append(string);
            stringBuilder.append("') = '");
            stringBuilder.append(string);
            stringBuilder.append("'\n  AND");
        }
        stringBuilder.append(" index_name IN (");
        int n = 0;
        for (IndexDefinition indexDefinition : list) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            String string2 = SqlUtil.removeObjectQuotes(indexDefinition.getObjectName());
            stringBuilder.append('\'');
            stringBuilder.append(string2);
            stringBuilder.append('\'');
            ++n;
        }
        stringBuilder.append(')');
    }
}

