/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.io.FileWriter;
import java.io.PrintWriter;
import workbench.db.QuoteHandler;
import workbench.db.WbConnection;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.FormatFileWriter;
import workbench.db.exporter.RowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ResultInfo;
import workbench.util.CharacterEscapeType;
import workbench.util.CharacterRange;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class PostgresCopyStatementWriter
implements FormatFileWriter {
    private boolean useFullFilepath;

    @Override
    public void setUseFullFilepath(boolean bl) {
        this.useFullFilepath = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFormatFile(DataExporter dataExporter, RowDataConverter rowDataConverter) {
        ResultInfo resultInfo = rowDataConverter.getResultInfo();
        WbFile wbFile = new WbFile(dataExporter.getFullOutputFilename());
        String string = wbFile.getParent();
        String string2 = wbFile.getFileName();
        WbFile wbFile2 = new WbFile(string, "import_" + string2 + ".sql");
        PrintWriter printWriter = null;
        try {
            String string3;
            printWriter = new PrintWriter(new FileWriter(wbFile2));
            printWriter.print("copy ");
            String string4 = dataExporter.getTableNameToUse();
            printWriter.print(this.getQuoteHandler(dataExporter.getConnection()).quoteObjectname(string4));
            printWriter.print(" (");
            for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
                if (i > 0) {
                    printWriter.print(", ");
                }
                printWriter.print(resultInfo.getColumnName(i));
            }
            printWriter.print(")");
            CharacterRange characterRange = dataExporter.getEscapeRange();
            boolean bl = characterRange == null || characterRange == CharacterRange.RANGE_CONTROL || characterRange == CharacterRange.RANGE_NONE;
            boolean bl2 = dataExporter.getBlobMode() == BlobMode.None || dataExporter.getBlobMode() == BlobMode.pgHex;
            boolean bl3 = dataExporter.getTextQuoteChar() == null && !dataExporter.getExportHeaders() && bl && bl2;
            printWriter.print("\n     from ");
            printWriter.print("'" + (this.useFullFilepath ? wbFile.getFullPath() : wbFile.getName()) + "'");
            String string5 = dataExporter.getTextDelimiter();
            printWriter.print("\n     with (format ");
            if (bl3) {
                printWriter.print("text");
            } else {
                printWriter.print("csv");
                if (dataExporter.getExportHeaders()) {
                    printWriter.print(", header true");
                }
                if ((string3 = dataExporter.getTextQuoteChar()) != null) {
                    printWriter.print(", quote '" + string3 + "'");
                }
            }
            string3 = string5;
            if (string5.length() == 1) {
                string3 = StringUtil.escapeText(string5, CharacterRange.RANGE_CONTROL, null, CharacterEscapeType.hex);
            }
            printWriter.print(", delimiter E'" + string3 + "'");
            String string6 = dataExporter.getEncoding();
            if (string6 != null) {
                printWriter.print(", encoding '" + string6 + "'");
            }
            if (dataExporter.getNullString() == null) {
                printWriter.print(", null ''");
            } else {
                printWriter.print(", null '" + dataExporter.getNullString() + "'");
            }
            printWriter.println(");");
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not write format file", exception);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(printWriter);
                throw throwable;
            }
            FileUtil.closeQuietely(printWriter);
        }
        FileUtil.closeQuietely(printWriter);
    }

    private QuoteHandler getQuoteHandler(WbConnection wbConnection) {
        if (wbConnection == null) {
            return QuoteHandler.STANDARD_HANDLER;
        }
        return wbConnection.getMetadata();
    }
}

