/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.EnumIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresEnumReader
implements ObjectListExtender {
    final String baseSql = "select current_database() as enum_catalog, \n       n.nspname as enum_schema,  \n       t.typname as enum_name,  \n       e.enumlabel as enum_value,  \n       obj_description(t.oid) as remarks \nfrom pg_catalog.pg_type t \n   join pg_catalog.pg_enum e on t.oid = e.enumtypid  \n   join pg_catalog.pg_namespace n ON n.oid = t.typnamespace";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumIdentifier getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        String string = dbObject.getObjectName();
        String string2 = "SELECT * \nFROM (\nselect current_database() as enum_catalog, \n       n.nspname as enum_schema,  \n       t.typname as enum_name,  \n       e.enumlabel as enum_value,  \n       obj_description(t.oid) as remarks \nfrom pg_catalog.pg_type t \n   join pg_catalog.pg_enum e on t.oid = e.enumtypid  \n   join pg_catalog.pg_namespace n ON n.oid = t.typnamespace\n) ei\nWHERE enum_name = '" + string + "' ";
        String string3 = dbObject.getSchema();
        if (StringUtil.isNonBlank(string3)) {
            string2 = string2 + "\n  AND enum_schema = '" + string3 + "'";
        }
        EnumIdentifier enumIdentifier = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "enum values", string2, new Object[0]);
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string2);
            boolean bl = true;
            while (resultSet.next()) {
                String string4 = resultSet.getString("enum_catalog");
                String string5 = resultSet.getString("enum_schema");
                String string6 = resultSet.getString("enum_name");
                String string7 = resultSet.getString("enum_value");
                String string8 = resultSet.getString("remarks");
                if (bl) {
                    enumIdentifier = new EnumIdentifier(string4, string5, string6);
                    enumIdentifier.setComment(string8);
                    bl = false;
                }
                enumIdentifier.addEnumValue(string7);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "enum values", string2, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return enumIdentifier;
    }

    private String getSql(WbConnection wbConnection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("select current_database() as enum_catalog, \n       n.nspname as enum_schema,  \n       t.typname as enum_name,  \n       e.enumlabel as enum_value,  \n       obj_description(t.oid) as remarks \nfrom pg_catalog.pg_type t \n   join pg_catalog.pg_enum e on t.oid = e.enumtypid  \n   join pg_catalog.pg_namespace n ON n.oid = t.typnamespace".length() + 50);
        stringBuilder.append("SELECT * FROM (");
        stringBuilder.append("select current_database() as enum_catalog, \n       n.nspname as enum_schema,  \n       t.typname as enum_name,  \n       e.enumlabel as enum_value,  \n       obj_description(t.oid) as remarks \nfrom pg_catalog.pg_type t \n   join pg_catalog.pg_enum e on t.oid = e.enumtypid  \n   join pg_catalog.pg_namespace n ON n.oid = t.typnamespace");
        stringBuilder.append(") ei ");
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append("\nWHERE ");
            SqlUtil.appendExpression(stringBuilder, "enum_name", string2, wbConnection);
            bl = true;
        }
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(bl ? "\n  AND " : "\nWHERE ");
            SqlUtil.appendExpression(stringBuilder, "enum_schema", string, wbConnection);
        }
        stringBuilder.append("\n ORDER BY 2");
        LogMgr.logMetadataSql(new CallerInfo(){}, "enums", stringBuilder, new Object[0]);
        return stringBuilder.toString();
    }

    public Collection<EnumIdentifier> getDefinedEnums(WbConnection wbConnection, String string, String string2) {
        Map<String, EnumIdentifier> map = this.getEnumInfo(wbConnection, string, string2);
        return map.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, EnumIdentifier> getEnumInfo(WbConnection wbConnection, String string, String string2) {
        if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "8.3")) {
            return Collections.emptyMap();
        }
        String string3 = this.getSql(wbConnection, string, string2);
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        HashMap<String, EnumIdentifier> hashMap = new HashMap<String, EnumIdentifier>();
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("enum_catalog");
                String string5 = resultSet.getString("enum_schema");
                String string6 = resultSet.getString("enum_name");
                String string7 = resultSet.getString("enum_value");
                String string8 = resultSet.getString("remarks");
                EnumIdentifier enumIdentifier = (EnumIdentifier)hashMap.get(string6);
                if (enumIdentifier == null) {
                    enumIdentifier = new EnumIdentifier(string4, string5, string6);
                    enumIdentifier.setComment(string8);
                    hashMap.put(string6, enumIdentifier);
                }
                enumIdentifier.addEnumValue(string7);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "enum values", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return hashMap;
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!this.handlesType(stringArray)) {
            return false;
        }
        if (!DbMetadata.typeIncluded("ENUM", stringArray)) {
            return false;
        }
        Collection<EnumIdentifier> collection = this.getDefinedEnums(wbConnection, string2, string3);
        if (CollectionUtil.isEmpty(collection)) {
            return false;
        }
        for (EnumIdentifier enumIdentifier : collection) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)enumIdentifier.getSchema());
            dataStore.setValue(n, 0, (Object)enumIdentifier.getObjectName());
            dataStore.setValue(n, 4, (Object)enumIdentifier.getComment());
            dataStore.setValue(n, 1, (Object)enumIdentifier.getObjectType());
            dataStore.getRow(n).setUserObject(enumIdentifier);
        }
        return true;
    }

    @Override
    public List<String> supportedTypes() {
        return Collections.singletonList("ENUM");
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("ENUM", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        EnumIdentifier enumIdentifier = this.getObjectDefinition(wbConnection, dbObject);
        if (enumIdentifier == null) {
            return null;
        }
        String[] stringArray = new String[]{"ENUM", "VALUES", "REMARKS"};
        int[] nArray = new int[]{12, 12, 12};
        int[] nArray2 = new int[]{20, 30, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)enumIdentifier.getObjectName());
        dataStore.setValue(0, 1, (Object)StringUtil.listToString(enumIdentifier.getValues(), ','));
        dataStore.setValue(0, 2, (Object)enumIdentifier.getComment());
        return dataStore;
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        EnumIdentifier enumIdentifier = this.getObjectDefinition(wbConnection, dbObject);
        if (enumIdentifier == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("CREATE TYPE ");
        stringBuilder.append(enumIdentifier.getObjectName());
        stringBuilder.append(" AS ENUM (");
        String string = StringUtil.listToString(enumIdentifier.getValues(), ",", true, '\'');
        stringBuilder.append(string);
        stringBuilder.append(");\n");
        if (StringUtil.isNonBlank(enumIdentifier.getComment())) {
            stringBuilder.append("\nCOMMENT ON TYPE ");
            stringBuilder.append(enumIdentifier.getObjectName());
            stringBuilder.append(" IS '");
            stringBuilder.append(SqlUtil.escapeQuotes(enumIdentifier.getComment()));
            stringBuilder.append("';\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

