/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.SQLException;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.ObjectListExtender;
import workbench.db.TriggerDefinition;
import workbench.db.WbConnection;
import workbench.db.postgres.PostgresTriggerReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class PostgresEventTriggerReader
implements ObjectListExtender {
    public static final String TYPE = "EVENT TRIGGER";

    @Override
    public TriggerDefinition getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded(TYPE, stringArray)) {
            return false;
        }
        PostgresTriggerReader postgresTriggerReader = new PostgresTriggerReader(wbConnection);
        int n = postgresTriggerReader.retrieveEventTriggers(dataStore, string3);
        return n > 0;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase(TYPE, string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList(TYPE);
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        PostgresTriggerReader postgresTriggerReader = new PostgresTriggerReader(wbConnection);
        try {
            String string = postgresTriggerReader.getEventTriggerSource(dbObject.getObjectName());
            return string;
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve event trigger source", sQLException);
            return null;
        }
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

