/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.StatementHook;
import workbench.sql.StatementRunner;
import workbench.sql.StatementRunnerResult;
import workbench.util.StringUtil;

public class PostgresStatementHook
implements StatementHook {
    private Method getNotifications;
    private Method getName;
    private Method getPID;
    private Method getParameter;
    private static volatile boolean available = true;

    public PostgresStatementHook(WbConnection wbConnection) {
        this.initialize(wbConnection);
    }

    @Override
    public String preExec(StatementRunner statementRunner, String string) {
        return string;
    }

    @Override
    public void postExec(StatementRunner statementRunner, String string, StatementRunnerResult statementRunnerResult) {
        if (available) {
            List<String> list = this.getMessages(statementRunner.getConnection());
            for (String string2 : list) {
                statementRunnerResult.addMessage(string2);
            }
        }
    }

    @Override
    public boolean isPending() {
        return false;
    }

    @Override
    public boolean displayResults() {
        return true;
    }

    @Override
    public boolean fetchResults() {
        return true;
    }

    @Override
    public void close(WbConnection wbConnection) {
    }

    private List<String> getMessages(WbConnection wbConnection) {
        if (!available || wbConnection == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            Object object = this.getNotifications.invoke((Object)wbConnection.getSqlConnection(), (Object[])null);
            if (object != null && object.getClass().isArray()) {
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    Object object2 = Array.get(object, i);
                    String string = this.getMessage(object2);
                    if (string == null) continue;
                    arrayList.add(string);
                }
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve messages", throwable);
            PostgresStatementHook.setUnavailable();
        }
        return arrayList;
    }

    private String getMessage(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        if (!available) {
            return null;
        }
        if (this.getName == null) {
            this.initGetters(object);
        }
        if (!available) {
            return null;
        }
        String string = (String)this.getName.invoke(object, (Object[])null);
        Object object2 = this.getPID.invoke(object, (Object[])null);
        String string2 = (String)this.getParameter.invoke(object, (Object[])null);
        String string3 = "";
        if (StringUtil.isNonEmpty(string2)) {
            string3 = " " + ResourceMgr.getFormattedString("MsgPgNotificationPayload", string2);
        }
        return ResourceMgr.getFormattedString("MsgPgNotificationBase", string, string3, object2.toString());
    }

    private synchronized void initialize(WbConnection wbConnection) {
        if (!available) {
            return;
        }
        if (wbConnection.getUrl().startsWith("jdbc:pgsql")) {
            PostgresStatementHook.setUnavailable();
            return;
        }
        try {
            this.getNotifications = wbConnection.getSqlConnection().getClass().getMethod("getNotifications", null);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not obtain getNotifications() method", throwable);
            this.getNotifications = null;
            PostgresStatementHook.setUnavailable();
        }
    }

    private synchronized void initGetters(Object object) {
        try {
            this.getName = object.getClass().getMethod("getName", null);
            this.getParameter = object.getClass().getMethod("getParameter", null);
            this.getPID = object.getClass().getMethod("getPID", null);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not obtain methods from PGNotification interface", throwable);
            PostgresStatementHook.setUnavailable();
        }
    }

    private static synchronized void setUnavailable() {
        available = false;
    }
}

