/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.BaseObjectType;
import workbench.db.ColumnIdentifier;
import workbench.db.CommentSqlManager;
import workbench.db.DataTypeResolver;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListEnhancer;
import workbench.db.ObjectListExtender;
import workbench.db.TableColumnsDatastore;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.postgres.PgRangeType;
import workbench.db.postgres.PgTypeInfo;
import workbench.db.postgres.PostgresRangeTypeReader;
import workbench.db.sqltemplates.ColumnChanger;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PostgresTypeReader
implements ObjectListExtender,
ObjectListEnhancer {
    private final PostgresRangeTypeReader rangeReader = new PostgresRangeTypeReader();

    @Override
    public void updateObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        String string4 = null;
        if (JdbcUtils.hasMinimumServerVersion(wbConnection, "9.3")) {
            string4 = "MATERIALIZED VIEW";
        } else if (!JdbcUtils.hasMiniumDriverVersion(wbConnection, "9.0")) {
            string4 = "TYPE";
        }
        if (DbMetadata.typeIncluded(string4, stringArray)) {
            int n = dataStore.getRowCount();
            for (int i = 0; i < n; ++i) {
                String string5 = dataStore.getValueAsString(i, 1);
                if (string5 != null) continue;
                dataStore.setValue(i, 1, (Object)string4);
            }
        }
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        boolean bl;
        boolean bl2 = DbMetadata.typeIncluded("TYPE", stringArray);
        boolean bl3 = bl = JdbcUtils.hasMinimumServerVersion(wbConnection, "9.2") && PostgresRangeTypeReader.retrieveRangeTypes();
        if (JdbcUtils.hasMiniumDriverVersion(wbConnection, "9.0")) {
            bl2 = false;
        }
        if (stringArray == null) {
            bl2 = false;
        }
        ArrayList<BaseObjectType> arrayList = new ArrayList<BaseObjectType>();
        if (bl2) {
            arrayList.addAll(this.getTypes(wbConnection, string2, string3));
        }
        if (bl) {
            List<PgRangeType> list = this.rangeReader.getRangeTypes(wbConnection, string2, string3);
            arrayList.addAll(list);
        }
        for (BaseObjectType baseObjectType : arrayList) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)baseObjectType.getSchema());
            dataStore.setValue(n, 0, (Object)baseObjectType.getObjectName());
            dataStore.setValue(n, 1, (Object)baseObjectType.getObjectType());
            dataStore.setValue(n, 4, (Object)baseObjectType.getComment());
            dataStore.getRow(n).setUserObject(baseObjectType);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseObjectType> getTypes(WbConnection wbConnection, String string, String string2) {
        ArrayList<BaseObjectType> arrayList = new ArrayList<BaseObjectType>();
        StringBuilder stringBuilder = new StringBuilder(100);
        String string3 = "SELECT null as table_cat, \n        n.nspname as table_schem, \n        t.typname as table_name, \n        'TYPE' as table_type, \n        pg_catalog.obj_description(t.oid, 'pg_type') as remarks \nFROM pg_catalog.pg_type t \n  JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace \nWHERE (t.typrelid = 0 OR (SELECT c.relkind = 'c' FROM pg_catalog.pg_class c WHERE c.oid = t.typrelid)) \n AND NOT EXISTS(SELECT 1 FROM pg_catalog.pg_type el WHERE el.oid = t.typelem AND el.typarray = t.oid) \n AND n.nspname <> 'pg_catalog' \n AND n.nspname <> 'information_schema' \n";
        if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "8.3")) {
            string3 = string3.replace("AND el.typarray = t.oid", "");
        }
        stringBuilder.append(string3);
        SqlUtil.appendAndCondition(stringBuilder, "n.nspname", string, wbConnection);
        SqlUtil.appendAndCondition(stringBuilder, "t.typname", string2, wbConnection);
        stringBuilder.append("\n ORDER BY 2,3 ");
        LogMgr.logMetadataSql(new CallerInfo(){}, "types", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                String string4 = resultSet.getString("TABLE_SCHEM");
                String string5 = resultSet.getString("TABLE_NAME");
                String string6 = resultSet.getString("REMARKS");
                BaseObjectType baseObjectType = new BaseObjectType(string4, string5);
                baseObjectType.setComment(string6);
                arrayList.add(baseObjectType);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "types", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("TYPE");
    }

    @Override
    public boolean handlesType(String string) {
        return "TYPE".equalsIgnoreCase(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        try {
            List<ColumnIdentifier> list = this.getColumns(wbConnection, dbObject);
            TableDefinition tableDefinition = new TableDefinition(this.createTableIdentifier(dbObject), list);
            TableColumnsDatastore tableColumnsDatastore = new TableColumnsDatastore(tableDefinition);
            return tableColumnsDatastore;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Cannot retrieve type columns", exception);
            return null;
        }
    }

    @Override
    public BaseObjectType getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        try {
            List<BaseObjectType> list = this.getTypes(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
            if (list.size() == 1) {
                BaseObjectType baseObjectType = list.get(0);
                baseObjectType.setAttributes(this.getColumns(wbConnection, dbObject));
                return baseObjectType;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Cannot retrieve type columns", exception);
        }
        return null;
    }

    @Override
    public boolean hasColumns() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (wbConnection == null) {
            return null;
        }
        String string = "SELECT a.attname as column_name, \n       a.attnum as column_position,  \n       dsc.description as remarks, \n       a.atttypid, \n       a.atttypmod, \n       pg_catalog.format_type(a.atttypid, null) as data_type \nFROM pg_catalog.pg_namespace n  \n   JOIN pg_catalog.pg_class c ON c.relnamespace = n.oid \n   JOIN pg_catalog.pg_attribute a ON a.attrelid = c.oid \n   LEFT JOIN pg_catalog.pg_description dsc ON c.oid=dsc.objoid AND a.attnum = dsc.objsubid \n   LEFT JOIN pg_catalog.pg_class dc ON dc.oid=dsc.classoid AND dc.relname='pg_class' \n   LEFT JOIN pg_catalog.pg_namespace dn ON dc.relnamespace=dn.oid AND dn.nspname='pg_catalog' \nWHERE a.attnum > 0 AND NOT a.attisdropped  \n  AND c.relkind = 'c' \n  AND n.nspname = ? \n   AND c.relname = ? \n ORDER BY column_position";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        PgTypeInfo pgTypeInfo = new PgTypeInfo(wbConnection);
        LogMgr.logMetadataSql(new CallerInfo(){}, "type columns", string, dbObject.getSchema(), dbObject.getObjectName());
        try {
            DataTypeResolver dataTypeResolver = wbConnection.getMetadata().getDataTypeResolver();
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, dbObject.getSchema());
            preparedStatement.setString(2, dbObject.getObjectName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                int n = resultSet.getInt(2);
                String string3 = resultSet.getString(3);
                int n2 = resultSet.getInt(4);
                int n3 = resultSet.getInt(5);
                String string4 = resultSet.getString(6);
                ColumnIdentifier columnIdentifier = new ColumnIdentifier(string2);
                int n4 = pgTypeInfo.getSQLType(n2);
                int n5 = pgTypeInfo.getScale(n2, n3);
                int n6 = pgTypeInfo.getPrecision(n2, n3);
                if (n6 == 0) {
                    n6 = pgTypeInfo.getDisplaySize(n2, n3);
                }
                columnIdentifier.setDataType(n4);
                columnIdentifier.setDecimalDigits(n5);
                columnIdentifier.setColumnSize(n6);
                columnIdentifier.setComment(string3);
                columnIdentifier.setDbmsType(dataTypeResolver.getSqlTypeDisplay(string4, n4, n6, n5));
                columnIdentifier.setPosition(n);
                arrayList.add(columnIdentifier);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "type columns", string, dbObject.getSchema(), dbObject.getObjectName());
                wbConnection.releaseSavepoint(savepoint);
            }
            catch (Throwable throwable) {
                wbConnection.releaseSavepoint(savepoint);
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    private TableIdentifier createTableIdentifier(DbObject dbObject) {
        TableIdentifier tableIdentifier = new TableIdentifier(dbObject.getCatalog(), dbObject.getSchema(), dbObject.getObjectName());
        tableIdentifier.setComment(dbObject.getComment());
        tableIdentifier.setType(dbObject.getObjectType());
        return tableIdentifier;
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        BaseObjectType baseObjectType = this.getObjectDefinition(wbConnection, dbObject);
        if (baseObjectType == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(50 + baseObjectType.getNumberOfAttributes() * 50);
        stringBuilder.append("CREATE TYPE ");
        stringBuilder.append(baseObjectType.getObjectName());
        stringBuilder.append(" AS\n(\n");
        List<ColumnIdentifier> list = baseObjectType.getAttributes();
        int n = ColumnIdentifier.getMaxNameLength(list);
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append("  ");
            stringBuilder.append(StringUtil.padRight(list.get(i).getColumnName(), n + 2));
            stringBuilder.append(list.get(i).getDbmsType());
            if (i >= list.size() - 1) continue;
            stringBuilder.append(",\n");
        }
        stringBuilder.append("\n);\n");
        String string = baseObjectType.getComment();
        CommentSqlManager commentSqlManager = new CommentSqlManager(wbConnection.getDbSettings().getDbId());
        String string2 = commentSqlManager.getCommentSqlTemplate("type", null);
        if (StringUtil.isNonBlank(string) && string2 != null) {
            string2 = string2.replace("%object_name%", baseObjectType.getObjectExpression(wbConnection));
            string2 = string2.replace("%comment%", string);
            stringBuilder.append('\n');
            stringBuilder.append(string2);
            stringBuilder.append(";\n");
        }
        ColumnChanger columnChanger = new ColumnChanger(wbConnection);
        for (ColumnIdentifier columnIdentifier : list) {
            String string3 = columnIdentifier.getComment();
            if (!StringUtil.isNonBlank(string3)) continue;
            String string4 = columnChanger.getColumnCommentSql(dbObject, columnIdentifier);
            stringBuilder.append(string4);
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }
}

