/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import workbench.db.DbMetadata;
import workbench.db.DefaultViewReader;
import workbench.db.DropType;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.postgres.PostgresRuleReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class PostgresViewReader
extends DefaultViewReader {
    public PostgresViewReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public CharSequence getExtendedViewSource(TableDefinition tableDefinition, DropType dropType, boolean bl) throws SQLException {
        CharSequence charSequence = super.getExtendedViewSource(tableDefinition, dropType, false);
        PostgresRuleReader postgresRuleReader = new PostgresRuleReader();
        CharSequence charSequence2 = postgresRuleReader.getTableRuleSource(this.connection, tableDefinition.getTable());
        String string = this.getColumnDefaults(tableDefinition);
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 50);
        stringBuilder.append(charSequence);
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(string);
        }
        if (charSequence2 != null) {
            stringBuilder.append("\n");
            stringBuilder.append(charSequence2);
        }
        if (bl) {
            stringBuilder.append("COMMIT;");
            stringBuilder.append(Settings.getInstance().getInternalEditorLineEnding());
        }
        return stringBuilder;
    }

    private String getColumnDefaults(TableDefinition tableDefinition) {
        boolean bl = JdbcUtils.hasMinimumServerVersion(this.connection, "12");
        String string = bl ? "pg_catalog.pg_get_expr(d.adbin, d.adrelid)" : "d.adsrc";
        String string2 = "select c.attname as column_name, \n       " + string + " as expression\nfrom pg_catalog.pg_attrdef d\n  join pg_catalog.pg_attribute c on c.attrelid = d.adrelid and c.attnum = d.adnum\n  join pg_catalog.pg_class v on v.oid = d.adrelid\n  join pg_catalog.pg_namespace n on n.oid = v.relnamespace\nwhere v.relname = ? \n  and n.nspname = ? ";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TableIdentifier tableIdentifier = tableDefinition.getTable();
        StringBuilder stringBuilder = new StringBuilder();
        DbMetadata dbMetadata = this.connection.getMetadata();
        LogMgr.logMetadataSql(new CallerInfo(){}, "view column defaults", string2, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
        try {
            preparedStatement = this.connection.getSqlConnection().prepareStatement(string2);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            preparedStatement.setString(2, tableIdentifier.getRawSchema());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                stringBuilder.append("ALTER TABLE " + tableIdentifier.getTableExpression(this.connection) + " ALTER " + dbMetadata.quoteObjectname(string3) + " SET DEFAULT " + string4 + ";\n");
            }
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "view column defaults", string2, tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
        }
        return stringBuilder.toString();
    }
}

