/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.progress;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OpenEdgeSequenceReader
implements SequenceReader {
    private WbConnection dbConn;
    private final String SELECT_SEQUENCE_DEF = "SELECT \"SEQ-OWNER\" as owner, \n       \"SEQ-NAME\" as sequence_name, \n       \"SEQ-INIT\" as initial, \n       \"SEQ-INCR\" as increment, \n       \"SEQ-MIN\" as \"MINVALUE\", \n       \"SEQ-MAX\" as \"MAXVALUE\", \n       case when \"CYCLE-OK\" = 1 then 'CYCLE' ELSE 'NOCYCLE' end as \"CYCLE\" \nFROM sysprogress.syssequences \n";

    public OpenEdgeSequenceReader(WbConnection wbConnection) {
        this.dbConn = wbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("SELECT \"SEQ-OWNER\" as owner, \n       \"SEQ-NAME\" as sequence_name, \n       \"SEQ-INIT\" as initial, \n       \"SEQ-INCR\" as increment, \n       \"SEQ-MIN\" as \"MINVALUE\", \n       \"SEQ-MAX\" as \"MAXVALUE\", \n       case when \"CYCLE-OK\" = 1 then 'CYCLE' ELSE 'NOCYCLE' end as \"CYCLE\" \nFROM sysprogress.syssequences \n");
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        string2 = StringUtil.trimToNull(string2);
        string3 = StringUtil.trimToNull(string3);
        if (StringUtil.isNonBlank(string2)) {
            bl = true;
            n = 1;
            stringBuilder.append(" WHERE \"SEQ-OWNER\" = ?");
        }
        if (StringUtil.isNonBlank(string3)) {
            if (bl) {
                stringBuilder.append(" AND ");
                n2 = 2;
            } else {
                stringBuilder.append(" WHERE ");
                n2 = 1;
            }
            if (string3.indexOf(37) > 0) {
                stringBuilder.append(" \"SEQ-NAME\" LIKE ? ");
                SqlUtil.appendEscapeClause(stringBuilder, this.dbConn, string3);
                string3 = SqlUtil.escapeUnderscore(string3, this.dbConn);
            } else {
                stringBuilder.append(" \"SEQ-NAME\" = ? ");
            }
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequences", stringBuilder, string2, string3);
        try {
            preparedStatement = this.dbConn.getSqlConnection().prepareStatement(stringBuilder.toString());
            if (n != -1) {
                preparedStatement.setString(n, SqlUtil.removeObjectQuotes(string2));
            }
            if (n2 != -1) {
                preparedStatement.setString(n2, SqlUtil.removeObjectQuotes(string3));
            }
            resultSet = preparedStatement.executeQuery();
            DataStore dataStore = new DataStore(resultSet);
            dataStore.initData(resultSet);
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                arrayList.add(this.createDefinition(dataStore, i, dataStore.getValueAsString(i, 0), dataStore.getValueAsString(i, 1)));
            }
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, throwable, "sequences", stringBuilder, string2, string3);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable2;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        return this.createDefinition(dataStore, 0, string2, string3);
    }

    private SequenceDefinition createDefinition(DataStore dataStore, int n, String string, String string2) {
        SequenceDefinition sequenceDefinition = new SequenceDefinition(string.trim(), string2.trim());
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(n, "MINVALUE"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(n, "MAXVALUE"));
        sequenceDefinition.setSequenceProperty("start_value", dataStore.getValue(n, "INITIAL"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "INCREMENT"));
        sequenceDefinition.setSequenceProperty("cycle", dataStore.getValue(n, "CYCLE"));
        sequenceDefinition.setSource(this.buildSource(sequenceDefinition));
        return sequenceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        String string4 = "SELECT \"SEQ-OWNER\" as owner, \n       \"SEQ-NAME\" as sequence_name, \n       \"SEQ-INIT\" as initial, \n       \"SEQ-INCR\" as increment, \n       \"SEQ-MIN\" as \"MINVALUE\", \n       \"SEQ-MAX\" as \"MAXVALUE\", \n       case when \"CYCLE-OK\" = 1 then 'CYCLE' ELSE 'NOCYCLE' end as \"CYCLE\" \nFROM sysprogress.syssequences \n WHERE \"SEQ-OWNER\" = ? AND \"SEQ-NAME\" = ?";
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence definition", string4, string2, string3);
        try {
            preparedStatement = this.dbConn.getSqlConnection().prepareStatement(string4);
            preparedStatement.setString(1, string2.trim());
            preparedStatement.setString(2, string3.trim());
            resultSet = preparedStatement.executeQuery();
            dataStore = new DataStore(resultSet);
            dataStore.initData(resultSet);
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, throwable, "sequence definition", string4, string2, string3);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable2;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        String string = this.getSequenceSource(null, sequenceDefinition.getSequenceOwner(), sequenceDefinition.getSequenceName());
        sequenceDefinition.setSource(string);
    }

    private String buildSource(SequenceDefinition sequenceDefinition) {
        StringBuilder stringBuilder = new StringBuilder(100);
        Number number = (Number)sequenceDefinition.getSequenceProperty("min_value");
        Number number2 = (Number)sequenceDefinition.getSequenceProperty("max_value");
        Number number3 = (Number)sequenceDefinition.getSequenceProperty("start_value");
        Number number4 = (Number)sequenceDefinition.getSequenceProperty("increment");
        String string = (String)sequenceDefinition.getSequenceProperty("cycle");
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(sequenceDefinition.getObjectExpression(this.dbConn));
        boolean bl = false;
        if (number4 != null) {
            stringBuilder.append("\n     INCREMENT BY ");
            stringBuilder.append(number4);
            bl = true;
        }
        if (number3 != null) {
            if (bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append("\n     START WITH ");
            stringBuilder.append(number3);
            bl = true;
        }
        if (number != null && number.intValue() != 0) {
            if (bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append("\n     MINVALUE ");
            stringBuilder.append(number);
            bl = true;
        }
        if (number2 != null) {
            if (bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append("\n     MAXVALUE ");
            stringBuilder.append(number2);
            bl = true;
        }
        if (StringUtil.equalString(string, "CYCLE")) {
            if (bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append("\n     CYCLE");
            bl = true;
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public String getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return null;
        }
        return sequenceDefinition.getSource().toString();
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

