/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.progress;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SynonymReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class OpenEdgeSynonymReader
implements SynonymReader {
    @Override
    public List<TableIdentifier> getSynonymList(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        String string4 = "SELECT sowner,\n       sname \nFROM sysprogress.syssynonyms \n";
        string3 = StringUtil.trimToNull(SqlUtil.removeObjectQuotes(string3));
        string2 = StringUtil.trimToNull(SqlUtil.removeObjectQuotes(string2));
        boolean bl = false;
        if (StringUtil.isNonBlank(string3)) {
            string4 = string3.contains("%") ? string4 + " WHERE sname LIKE '" : string4 + " WHERE sname = '";
            string4 = string4 + SqlUtil.escapeQuotes(string3);
            string4 = string4 + "' \n";
            bl = true;
        }
        if (StringUtil.isNonBlank(string2)) {
            string4 = bl ? string4 + " AND sowner = '" + string2 + "'" : string4 + "WHERE sowner = '" + string2 + "'";
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonyms", string4, new Object[0]);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
            preparedStatement.setString(1, string2);
            if (StringUtil.isNonBlank(string3)) {
                preparedStatement.setString(2, string3);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                if (resultSet.wasNull()) continue;
                TableIdentifier tableIdentifier = new TableIdentifier(null, string5, string6, false);
                tableIdentifier.setType("SYNONYM");
                tableIdentifier.setNeverAdjustCase(true);
                arrayList.add(tableIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonyms", string4, new Object[0]);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    @Override
    public TableIdentifier getSynonymTable(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        TableIdentifier tableIdentifier;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            String string4 = "SELECT stbl,\n       stblowner\nFROM sysprogress.syssynonyms \nWHERE sname = ?\n  AND sowner = ?";
            LogMgr.logMetadataSql(new CallerInfo(){}, "synonym table", string4, string3, string2);
            preparedStatement = null;
            resultSet = null;
            tableIdentifier = null;
            try {
                preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                if (string5 != null) {
                    tableIdentifier = new TableIdentifier(null, string6, string5, false);
                    tableIdentifier.setNeverAdjustCase(true);
                    tableIdentifier.setType("SYNONYM");
                }
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonym table", string4, string3, string2);
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return tableIdentifier;
    }

    @Override
    public boolean supportsReplace(WbConnection wbConnection) {
        return false;
    }
}

