/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.WbManager;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.db.search.TableDataSearcher;
import workbench.interfaces.TableSearchConsumer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.ContainsComparator;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ServerSideTableSearcher
implements TableDataSearcher {
    private List<TableIdentifier> tablesToSearch;
    private String columnFunction;
    private TableSearchConsumer display;
    private String criteria;
    private WbConnection connection;
    private boolean cancelSearch = false;
    private boolean isRunning = false;
    private Statement query = null;
    private Thread searchThread;
    private int maxRows = 0;
    private boolean retrieveLobColumns = true;
    private DataStore result = null;

    @Override
    public void startBackgroundSearch() {
        this.cancelSearch = false;
        this.searchThread = new WbThread("TableSearcher Thread"){

            @Override
            public void run() {
                ServerSideTableSearcher.this.search();
            }
        };
        this.searchThread.start();
    }

    @Override
    public void cancelSearch() {
        this.cancelSearch = true;
        try {
            if (this.searchThread != null) {
                this.searchThread.interrupt();
            }
            if (this.query != null) {
                this.query.cancel();
            }
            if (this.result != null) {
                this.result.cancelRetrieve();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when cancelling", throwable);
        }
    }

    private void setRunning(boolean bl) {
        this.isRunning = bl;
        if (this.display != null) {
            if (bl) {
                this.display.searchStarted();
            } else {
                this.display.searchEnded();
            }
        }
        if (!bl) {
            this.cancelSearch = false;
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search() {
        if (this.tablesToSearch == null || this.tablesToSearch.isEmpty()) {
            return;
        }
        this.setRunning(true);
        try {
            this.connection.setBusy(true);
            long l = this.tablesToSearch.size();
            long l2 = 1L;
            for (TableIdentifier tableIdentifier : this.tablesToSearch) {
                this.searchTable(tableIdentifier, l2, l);
                if (this.cancelSearch) break;
                ++l2;
            }
            if (this.display != null) {
                this.display.setStatusText("");
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error searching database", throwable);
        }
        finally {
            this.setRunning(false);
            this.connection.setBusy(false);
        }
    }

    @Override
    public void setRetrieveLobColumns(boolean bl) {
        this.retrieveLobColumns = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void searchTable(TableIdentifier tableIdentifier, long l, long l2) {
        block20: {
            ResultSet resultSet = null;
            Savepoint savepoint = null;
            boolean bl = this.connection.getDbSettings().useSavePointForDML();
            try {
                String string = this.buildSqlForTable(tableIdentifier);
                if (this.display != null) {
                    this.display.setCurrentTable(tableIdentifier.getTableExpression(), string, l, l2);
                }
                if (string == null) {
                    JdbcUtils.closeAll(resultSet, this.query);
                    this.query = null;
                    if (savepoint != null) {
                        this.connection.releaseSavepoint(savepoint);
                    }
                    return;
                }
                if (!this.connection.getAutoCommit() && bl) {
                    try {
                        savepoint = this.connection.setSavepoint();
                    }
                    catch (SQLException sQLException) {
                        LogMgr.logWarning(new CallerInfo(){}, "Could not create savepoint", sQLException);
                        savepoint = null;
                        bl = false;
                    }
                }
                this.query = this.connection.createStatementForQuery();
                this.query.setMaxRows(this.maxRows);
                resultSet = this.query.executeQuery(string);
                this.result = new DataStore(resultSet, this.connection, true);
                this.result.setGeneratingSql(string);
                this.result.setResultName(tableIdentifier.getTableName());
                this.result.setUpdateTableToBeUsed(tableIdentifier);
                if (this.display != null) {
                    this.display.tableSearched(tableIdentifier, this.result);
                }
                this.result = null;
                if (savepoint != null) {
                    this.connection.releaseSavepoint(savepoint);
                    savepoint = null;
                }
                JdbcUtils.closeAll(resultSet, this.query);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                WbManager.getInstance().showOutOfMemoryError();
                break block20;
            }
            catch (Exception exception) {
                block21: {
                    LogMgr.logError(new CallerInfo(){}, "Error retrieving data for " + tableIdentifier.getTableExpression(), exception);
                    if (this.display != null) {
                        this.display.error(ExceptionUtil.getDisplay(exception));
                    }
                    if (savepoint == null) break block21;
                    this.connection.rollback(savepoint);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                JdbcUtils.closeAll(resultSet, this.query);
                this.query = null;
                if (savepoint != null) {
                    this.connection.releaseSavepoint(savepoint);
                }
                break block20;
            }
            finally {
                JdbcUtils.closeAll(resultSet, this.query);
                this.query = null;
                if (savepoint != null) {
                    this.connection.releaseSavepoint(savepoint);
                }
            }
            this.query = null;
            if (savepoint != null) {
                this.connection.releaseSavepoint(savepoint);
            }
        }
    }

    private boolean isSearchable(int n, String string) {
        if (n == 12 || n == 1 || n == -9 || n == -15) {
            return true;
        }
        return this.connection.getDbSettings().isSearchable(string);
    }

    private String buildSqlForTable(TableIdentifier tableIdentifier) throws SQLException {
        DbMetadata dbMetadata = this.connection.getMetadata();
        TableDefinition tableDefinition = dbMetadata.getTableDefinition(tableIdentifier, false);
        return this.buildSqlForTable(tableDefinition, "tablesearch");
    }

    public String buildSqlForTable(TableDefinition tableDefinition, String string) throws SQLException {
        int n = tableDefinition.getColumnCount();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n * 120);
        TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.connection, string);
        tableSelectBuilder.setIncludeBLOBColumns(this.retrieveLobColumns);
        tableSelectBuilder.setIncludeCLOBColumns(this.retrieveLobColumns);
        stringBuilder.append(tableSelectBuilder.getSelectForColumns(tableDefinition.getTable(), tableDefinition.getColumns(), -1));
        stringBuilder.append("\n WHERE ");
        boolean bl = true;
        int n2 = 0;
        Pattern pattern = Pattern.compile("\\s+AS\\s+", 2);
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            String string2 = tableDefinition.getColumns().get(i).getColumnName();
            String string3 = tableDefinition.getColumns().get(i).getDbmsType();
            int n3 = tableDefinition.getColumns().get(i).getDataType();
            String string4 = tableSelectBuilder.getColumnExpression(tableDefinition.getColumns().get(i));
            boolean bl3 = bl2 = !string2.equalsIgnoreCase(string4);
            if (!bl2 && !this.isSearchable(n3, string3)) continue;
            if (!bl2) {
                string4 = this.connection.getMetadata().quoteObjectname(string2);
            } else {
                Matcher matcher = pattern.matcher(string4);
                if (matcher.find()) {
                    int n4 = matcher.start();
                    string4 = string4.substring(0, n4);
                }
            }
            ++n2;
            if (!bl) {
                stringBuilder.append(" OR ");
            }
            if (this.columnFunction != null) {
                stringBuilder.append(StringUtil.replace(this.columnFunction, "$col$", string4));
            } else {
                stringBuilder.append(string4);
            }
            stringBuilder.append(" LIKE '");
            stringBuilder.append(this.criteria);
            stringBuilder.append('\'');
            if (i < n - 1) {
                stringBuilder.append('\n');
            }
            bl = false;
        }
        if (n2 == 0) {
            LogMgr.logWarning(new CallerInfo(){}, "Table " + tableDefinition.getTable().getTableExpression() + " not beeing searched because no character columns were found");
            return null;
        }
        return stringBuilder.toString();
    }

    public boolean isCaseSensitive() {
        if (this.columnFunction == null) {
            return false;
        }
        if (this.criteria == null) {
            return false;
        }
        boolean bl = this.connection.getDbSettings().isStringComparisonCaseSensitive();
        if (!bl) {
            return true;
        }
        String string = this.columnFunction.toLowerCase();
        if (string.contains("upper") || string.contains("ucase")) {
            return this.criteria.toUpperCase().equals(this.criteria);
        }
        if (string.contains("lower") || string.contains("lcase")) {
            return this.criteria.toLowerCase().equals(this.criteria);
        }
        return false;
    }

    public boolean setColumnFunction(String string) {
        this.columnFunction = null;
        boolean bl = false;
        if (StringUtil.isNonBlank(string)) {
            if (string.equalsIgnoreCase("$col$")) {
                this.columnFunction = null;
                bl = true;
            } else if (string.contains("$col$")) {
                this.columnFunction = string;
                bl = true;
            } else if (string.contains("$COL$")) {
                this.columnFunction = StringUtil.replace(string, "$COL$", "$col$");
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void setTableNames(List<TableIdentifier> list) {
        this.tablesToSearch = list == null ? new ArrayList<TableIdentifier>(0) : new ArrayList<TableIdentifier>(list);
    }

    public TableSearchConsumer getDisplay() {
        return this.display;
    }

    @Override
    public void setConsumer(TableSearchConsumer tableSearchConsumer) {
        this.display = tableSearchConsumer;
    }

    @Override
    public String getCriteria() {
        return this.criteria;
    }

    @Override
    public void setCriteria(String string, boolean bl) {
        if (string == null) {
            return;
        }
        this.criteria = StringUtil.trimQuotes(string);
    }

    @Override
    public void setConnection(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    @Override
    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    @Override
    public ColumnExpression getSearchExpression() {
        String string = StringUtil.trimQuotes(this.criteria.replaceAll("[%_]", ""));
        ColumnExpression columnExpression = new ColumnExpression("*", new ContainsComparator(), string);
        columnExpression.setIgnoreCase(this.isCaseSensitive());
        return columnExpression;
    }
}

