/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import workbench.gui.actions.WbAction;
import workbench.interfaces.TextFileContainer;
import workbench.util.WbFile;

public class CopyFileNameAction
extends WbAction {
    private TextFileContainer editor;
    private boolean copyPathName;

    public CopyFileNameAction(TextFileContainer textFileContainer, boolean bl) {
        this.editor = textFileContainer;
        this.copyPathName = bl;
        if (this.copyPathName) {
            this.initMenuDefinition("MnuTxtCpyFilePath");
        } else {
            this.initMenuDefinition("MnuTxtCpyFileName");
        }
        this.setEnabled(this.editor.getCurrentFile() != null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.editor == null) {
            return;
        }
        File file = this.editor.getCurrentFile();
        if (file == null) {
            return;
        }
        WbFile wbFile = new WbFile(file);
        String string = null;
        string = this.copyPathName ? wbFile.getFullPath() : wbFile.getName();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(string), null);
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

