/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.DummyDML;
import workbench.db.DummyInsert;
import workbench.db.DummySelect;
import workbench.db.DummyUpdate;
import workbench.db.ObjectScripter;
import workbench.db.TableIdentifier;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.ObjectScripterUI;
import workbench.interfaces.Scripter;
import workbench.interfaces.WbSelectionListener;
import workbench.interfaces.WbSelectionModel;
import workbench.resource.Settings;

public class CreateDummySqlAction
extends WbAction
implements WbSelectionListener {
    private DbObjectList source;
    private String scriptType;
    private WbSelectionModel selection;

    public static CreateDummySqlAction createDummyUpdateAction(DbObjectList dbObjectList, ListSelectionModel listSelectionModel) {
        return new CreateDummySqlAction("MnuTxtCreateDummyUpdate", dbObjectList, listSelectionModel, "update");
    }

    public static CreateDummySqlAction createDummyInsertAction(DbObjectList dbObjectList, ListSelectionModel listSelectionModel) {
        return new CreateDummySqlAction("MnuTxtCreateDummyInsert", dbObjectList, listSelectionModel, "insert");
    }

    public static CreateDummySqlAction createDummySelectAction(DbObjectList dbObjectList, ListSelectionModel listSelectionModel) {
        return new CreateDummySqlAction("MnuTxtCreateDefaultSelect", dbObjectList, listSelectionModel, "select");
    }

    public static CreateDummySqlAction createDummyUpdateAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel) {
        return new CreateDummySqlAction("MnuTxtCreateDummyUpdate", dbObjectList, wbSelectionModel, "update");
    }

    public static CreateDummySqlAction createDummyInsertAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel) {
        return new CreateDummySqlAction("MnuTxtCreateDummyInsert", dbObjectList, wbSelectionModel, "insert");
    }

    public static CreateDummySqlAction createDummySelectAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel) {
        return new CreateDummySqlAction("MnuTxtCreateDefaultSelect", dbObjectList, wbSelectionModel, "select");
    }

    private CreateDummySqlAction(String string, DbObjectList dbObjectList, ListSelectionModel listSelectionModel, String string2) {
        this(string, dbObjectList, WbSelectionModel.Factory.createFacade(listSelectionModel), string2);
    }

    private CreateDummySqlAction(String string, DbObjectList dbObjectList, WbSelectionModel wbSelectionModel, String string2) {
        this.isConfigurable = false;
        this.initMenuDefinition(string);
        this.source = dbObjectList;
        this.scriptType = string2;
        this.selection = wbSelectionModel;
        this.checkEnabled();
        this.selection.addSelectionListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        Object object;
        List<DbObject> list = this.source.getSelectedObjects();
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        ArrayList<ColumnIdentifier> arrayList2 = new ArrayList<ColumnIdentifier>();
        boolean bl = Settings.getInstance().getBoolProperty("workbench.sql.generate.dummydml.prepared", false);
        if (CreateDummySqlAction.isCtrlPressed(actionEvent)) {
            bl = true;
        }
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (object instanceof TableIdentifier) {
                DummyDML dummyDML;
                TableIdentifier tableIdentifier = (TableIdentifier)object;
                if (this.scriptType.equalsIgnoreCase("select")) {
                    arrayList.add(new DummySelect(tableIdentifier));
                    continue;
                }
                if (this.scriptType.equalsIgnoreCase("update")) {
                    dummyDML = new DummyUpdate(tableIdentifier);
                    dummyDML.setGeneratePreparedStatement(bl);
                    arrayList.add(dummyDML);
                    continue;
                }
                if (!this.scriptType.equalsIgnoreCase("insert")) continue;
                dummyDML = new DummyInsert(tableIdentifier);
                dummyDML.setGeneratePreparedStatement(bl);
                arrayList.add(dummyDML);
                continue;
            }
            if (!(object instanceof ColumnIdentifier)) continue;
            arrayList2.add((ColumnIdentifier)object);
        }
        if (arrayList2.size() > 0 && (object2 = this.source.getObjectTable()) != null) {
            if (this.scriptType.equalsIgnoreCase("select")) {
                arrayList.add(new DummySelect((TableIdentifier)object2, arrayList2));
            } else {
                object = new DummyInsert((TableIdentifier)object2);
                ((DummyDML)object).setGeneratePreparedStatement(bl);
                arrayList.add(object);
            }
        }
        object2 = new ObjectScripter(arrayList, this.source.getConnection());
        object = new ObjectScripterUI((Scripter)object2);
        ((ObjectScripterUI)object).show(SwingUtilities.getWindowAncestor(this.source.getComponent()));
    }

    @Override
    public void selectionChanged(WbSelectionModel wbSelectionModel) {
        this.checkEnabled();
    }

    private void checkEnabled() {
        this.setEnabled(this.source.getSelectionCount() > 0);
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

