/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.DbObjectChanger;
import workbench.db.TableIdentifier;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.RunScriptPanel;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class CreatePKAction
extends WbAction {
    private DbObjectList columns;

    public CreatePKAction(DbObjectList dbObjectList) {
        this.columns = dbObjectList;
        this.initMenuDefinition("MnuTxtCreatePK");
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        List<DbObject> list = this.columns.getSelectedObjects();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List<ColumnIdentifier> list2 = CollectionUtil.arrayList();
        for (DbObject object2 : list) {
            list2.add((ColumnIdentifier)object2);
        }
        TableIdentifier tableIdentifier = this.columns.getObjectTable();
        DbObjectChanger dbObjectChanger = new DbObjectChanger(this.columns.getConnection());
        String string = dbObjectChanger.getAddPKScript(tableIdentifier, list2);
        if (StringUtil.isBlank(string)) {
            return;
        }
        RunScriptPanel runScriptPanel = new RunScriptPanel(this.columns.getConnection(), string);
        runScriptPanel.openWindow(this.columns.getComponent(), ResourceMgr.getString("TxtCreatePK"));
        if (runScriptPanel.wasRun() && this.columns != null) {
            EventQueue.invokeLater(this.columns::reload);
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

