/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import workbench.gui.actions.WbAction;
import workbench.gui.sql.DetachedResultWindow;
import workbench.gui.sql.DwPanel;
import workbench.gui.sql.SqlPanel;

public class DetachResultTabAction
extends WbAction {
    private SqlPanel panel;

    public DetachResultTabAction(SqlPanel sqlPanel) {
        this.panel = sqlPanel;
        this.initMenuDefinition("MnuTxtDetachResult");
        this.setIcon(null);
        this.setEnabled(this.panel.getCurrentResult() != null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        DwPanel dwPanel = this.panel.getCurrentResult();
        if (dwPanel == null) {
            return;
        }
        if (dwPanel.getTable() == null) {
            return;
        }
        if (dwPanel.getDataStore() == null) {
            return;
        }
        int n = this.panel.getRefreshMgr().getRefreshPeriod(dwPanel);
        this.panel.removeCurrentResult();
        EventQueue.invokeLater(() -> {
            DetachedResultWindow detachedResultWindow = new DetachedResultWindow(dwPanel, this.panel);
            if (n > 0) {
                detachedResultWindow.refreshAutomatically(n);
            }
            detachedResultWindow.showWindow();
        });
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

