/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import workbench.db.DbObjectChanger;
import workbench.db.TableIdentifier;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.RunScriptPanel;
import workbench.resource.ResourceMgr;
import workbench.util.StringUtil;

public class DropPKAction
extends WbAction {
    private final DbObjectList columns;

    public DropPKAction(DbObjectList dbObjectList) {
        this.columns = dbObjectList;
        this.initMenuDefinition("MnuTxtDropPK");
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        TableIdentifier tableIdentifier = this.columns.getObjectTable();
        DbObjectChanger dbObjectChanger = new DbObjectChanger(this.columns.getConnection());
        String string = dbObjectChanger.getDropPKScript(tableIdentifier);
        if (StringUtil.isBlank(string)) {
            return;
        }
        RunScriptPanel runScriptPanel = new RunScriptPanel(this.columns.getConnection(), string);
        runScriptPanel.openWindow(this.columns.getComponent(), ResourceMgr.getString("TxtDropPK"));
        if (runScriptPanel.wasRun() && this.columns != null) {
            EventQueue.invokeLater(this.columns::reload);
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

