/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.KeyStroke;
import workbench.gui.actions.WbAction;
import workbench.gui.sql.SqlPanel;
import workbench.interfaces.TextSelectionListener;
import workbench.resource.GuiSettings;
import workbench.resource.PlatformShortcuts;
import workbench.resource.Settings;

public class ExecuteSelAction
extends WbAction
implements TextSelectionListener,
PropertyChangeListener {
    private SqlPanel target;
    private boolean checkSelection;

    public ExecuteSelAction(SqlPanel sqlPanel) {
        this.target = sqlPanel;
        this.initMenuDefinition("MnuTxtExecuteSel", KeyStroke.getKeyStroke(69, PlatformShortcuts.getDefaultModifier()));
        this.setIcon("execute_sel");
        this.setMenuItemName("MnuTxtSQL");
        this.setAlternateAccelerator(KeyStroke.getKeyStroke(120, 0));
        if (GuiSettings.getExecuteOnlySelected()) {
            super.setEnabled(false);
            this.checkSelection = true;
            this.target.getEditor().addSelectionListener(this);
        }
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.editor.execute.onlyselected", new String[0]);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.isEnabled()) {
            this.target.runSelectedStatement();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.checkSelection) {
            this.checkSelection();
        } else {
            super.setEnabled(bl);
        }
    }

    @Override
    public void selectionChanged(int n, int n2) {
        super.setEnabled(n < n2);
    }

    public void checkSelection() {
        int n;
        if (this.target == null) {
            return;
        }
        if (this.target.getEditor() == null) {
            return;
        }
        int n2 = this.target.getEditor().getSelectionStart();
        super.setEnabled(n2 < (n = this.target.getEditor().getSelectionEnd()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.target == null) {
            return;
        }
        if (this.target.getEditor() == null) {
            return;
        }
        if ("workbench.gui.editor.execute.onlyselected".equals(propertyChangeEvent.getPropertyName())) {
            boolean bl = this.checkSelection;
            this.checkSelection = GuiSettings.getExecuteOnlySelected();
            if (bl) {
                super.setEnabled(true);
                this.target.getEditor().removeSelectionListener(this);
            } else {
                this.target.getEditor().addSelectionListener(this);
                this.checkSelection();
            }
        }
    }
}

