/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.KeyStroke;
import workbench.db.ConnectionProfile;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.FileEncodingAccessoryPanel;
import workbench.gui.components.WbFileChooser;
import workbench.gui.menu.RecentFileManager;
import workbench.gui.sql.SqlPanel;
import workbench.interfaces.TextFileContainer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.PlatformShortcuts;
import workbench.resource.Settings;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbProperties;

public class OpenFileAction
extends WbAction {
    private MainWindow mainWindow;
    private TextFileContainer container;
    private static final String TOOLNAME = "directories";
    private static final String LAST_DIR_KEY = "last.script.dir";
    private File fileToLoad;

    public OpenFileAction(MainWindow mainWindow) {
        this(mainWindow, (TextFileContainer)null);
    }

    public OpenFileAction(TextFileContainer textFileContainer) {
        this(null, textFileContainer);
    }

    public OpenFileAction(MainWindow mainWindow, TextFileContainer textFileContainer) {
        this.mainWindow = mainWindow;
        this.container = textFileContainer;
        this.initMenuDefinition("MnuTxtFileOpen", KeyStroke.getKeyStroke(79, PlatformShortcuts.getDefaultModifier()));
        this.setIcon("Open");
        this.setMenuItemName("MnuTxtFile");
        this.setCreateMenuSeparator(true);
    }

    public OpenFileAction(MainWindow mainWindow, WbFile wbFile) {
        this.mainWindow = mainWindow;
        this.container = null;
        this.fileToLoad = wbFile;
        this.setMenuText(wbFile.getName());
        this.setTooltip(wbFile.getFullPath());
        this.setMenuItemName("MnuTxtFile");
        this.setCreateMenuSeparator(true);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.fileToLoad == null) {
            this.selectAndLoad();
            return;
        }
        MainWindow mainWindow = this.getWindow();
        WbFile wbFile = new WbFile(this.fileToLoad);
        String string = wbFile.getFullPath();
        EventQueue.invokeLater(() -> {
            String string2 = FileUtil.detectFileEncoding(wbFile);
            SqlPanel sqlPanel = this.getCurrentPanel();
            if (sqlPanel == null) {
                return;
            }
            if (!sqlPanel.checkAndSaveFile()) {
                return;
            }
            sqlPanel.readFile(string, string2);
            mainWindow.invalidate();
            mainWindow.currentTabChanged();
        });
    }

    private void selectAndLoad() {
        EncodingUtil.fetchEncodings();
        MainWindow mainWindow = this.getWindow();
        SqlPanel sqlPanel = this.getCurrentPanel();
        if (sqlPanel != null && !sqlPanel.checkAndSaveFile()) {
            return;
        }
        try {
            File file = OpenFileAction.getLastSQLDir(mainWindow);
            WbFileChooser wbFileChooser = new WbFileChooser(file);
            wbFileChooser.setSettingsID("workbench.editor.file.opendialog");
            wbFileChooser.setMultiSelectionEnabled(true);
            FileEncodingAccessoryPanel fileEncodingAccessoryPanel = new FileEncodingAccessoryPanel(mainWindow);
            wbFileChooser.addEncodingPanel(fileEncodingAccessoryPanel);
            wbFileChooser.addChoosableFileFilter(ExtensionFileFilter.getSqlFileFilter());
            boolean bl = mainWindow.getCurrentSqlPanel() != null;
            int n = wbFileChooser.showOpenDialog(mainWindow);
            GuiSettings.setAutoDetectFileEncoding(fileEncodingAccessoryPanel.getAutoDetect());
            if (n == 0) {
                String string = fileEncodingAccessoryPanel.getEncoding();
                OpenFileAction.storeLastSQLDir(mainWindow, wbFileChooser.getCurrentDirectory());
                Settings.getInstance().setDefaultFileEncoding(string);
                File[] fileArray = wbFileChooser.getSelectedFiles();
                boolean bl2 = fileArray.length == 1 ? fileEncodingAccessoryPanel.openInNewTab() : true;
                if (bl) {
                    Settings.getInstance().setProperty("workbench.file.newtab", bl2);
                }
                for (File file2 : fileArray) {
                    WbFile wbFile = new WbFile(file2);
                    String string2 = wbFile.getFullPath();
                    EventQueue.invokeLater(() -> {
                        SqlPanel sqlPanel2;
                        String string3 = string;
                        if (StringUtil.isEmptyString(string3)) {
                            string3 = FileUtil.detectFileEncoding(wbFile);
                        }
                        if ((sqlPanel2 = bl2 ? (SqlPanel)mainWindow.addTab() : sqlPanel) != null) {
                            sqlPanel2.readFile(string2, string3);
                        }
                        RecentFileManager.getInstance().editorFileLoaded(wbFile);
                        mainWindow.invalidate();
                        mainWindow.currentTabChanged();
                    });
                }
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error selecting file", throwable);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(throwable));
        }
    }

    private MainWindow getWindow() {
        if (this.mainWindow != null) {
            return this.mainWindow;
        }
        if (this.container != null) {
            return this.container.getMainWindow();
        }
        return null;
    }

    private SqlPanel getCurrentPanel() {
        if (this.getWindow() != null) {
            return this.getWindow().getCurrentSqlPanel();
        }
        return null;
    }

    public static void storeLastSQLDir(MainWindow mainWindow, File file) {
        if (Settings.getInstance().getStoreScriptDirInWksp()) {
            mainWindow.getToolProperties(TOOLNAME).setProperty(LAST_DIR_KEY, file.getAbsolutePath());
        } else {
            Settings.getInstance().setLastSqlDir(file.getAbsolutePath());
        }
    }

    private static String getProfileDir(MainWindow mainWindow) {
        if (mainWindow == null) {
            return null;
        }
        ConnectionProfile connectionProfile = mainWindow.getCurrentProfile();
        if (connectionProfile == null) {
            return null;
        }
        return connectionProfile.getDefaultDirectory();
    }

    public static File getLastSQLDir(MainWindow mainWindow) {
        SqlPanel sqlPanel = mainWindow == null ? null : mainWindow.getCurrentSqlPanel();
        File file = null;
        String string = OpenFileAction.getProfileDir(mainWindow);
        if (GuiSettings.getFollowFileDirectory() && sqlPanel != null && sqlPanel.hasFileLoaded()) {
            WbFile wbFile = new WbFile(sqlPanel.getCurrentFileName());
            if (wbFile.getParent() != null) {
                file = wbFile.getParentFile();
            }
        } else if (StringUtil.isNonBlank(string)) {
            File file2 = new File(string);
            if (file2.exists()) {
                file = file2;
            }
        } else {
            file = new File(Settings.getInstance().getLastSqlDir());
            if (Settings.getInstance().getStoreScriptDirInWksp()) {
                String string2;
                WbProperties wbProperties = mainWindow == null ? null : mainWindow.getToolProperties(TOOLNAME);
                String string3 = string2 = wbProperties == null ? null : wbProperties.getProperty(LAST_DIR_KEY, null);
                if (StringUtil.isNonBlank(string2)) {
                    file = new File(string2);
                }
            }
        }
        if (file == null) {
            file = GuiSettings.getDefaultFileDir();
        }
        return file;
    }
}

