/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ColumnWidthOptimizer;
import workbench.gui.components.WbTable;
import workbench.resource.GuiSettings;
import workbench.resource.PlatformShortcuts;
import workbench.util.WbThread;

public class OptimizeAllColumnsAction
extends WbAction {
    protected ColumnWidthOptimizer optimizer;

    public OptimizeAllColumnsAction(WbTable wbTable) {
        this.setClient(wbTable);
        this.initMenuDefinition("MnuTxtOptimizeAllCol", KeyStroke.getKeyStroke(87, PlatformShortcuts.getDefaultModifier()));
        this.setEnabled(false);
    }

    public void disableShortcut() {
        this.setAccelerator(null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.optimizer == null) {
            return;
        }
        final boolean bl = OptimizeAllColumnsAction.isShiftPressed(actionEvent);
        WbThread wbThread = new WbThread("OptimizeAllCols Thread"){

            @Override
            public void run() {
                OptimizeAllColumnsAction.this.optimizer.optimizeAllColWidth(bl || GuiSettings.getIncludeHeaderInOptimalWidth());
            }
        };
        wbThread.start();
    }

    @Override
    public boolean hasShiftModifier() {
        return true;
    }

    public void setClient(WbTable wbTable) {
        this.optimizer = wbTable != null ? new ColumnWidthOptimizer(wbTable) : null;
        this.setEnabled(wbTable != null);
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

