/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.util.WbThread;

public class OptimizeRowHeightAction
extends WbAction
implements TableModelListener {
    protected WbTable client;

    public OptimizeRowHeightAction() {
        this.initMenuDefinition("LblRowHeightOpt");
        this.setEnabled(false);
    }

    public OptimizeRowHeightAction(WbTable wbTable) {
        this();
        this.setClient(wbTable);
    }

    public void setClient(WbTable wbTable) {
        this.client = wbTable;
        this.checkEnabled();
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.client == null) {
            return;
        }
        WbThread wbThread = new WbThread("OptimizeRows Thread"){

            @Override
            public void run() {
                OptimizeRowHeightAction.this.client.optimizeRowHeight();
            }
        };
        wbThread.start();
    }

    private void checkEnabled() {
        if (this.client != null) {
            this.setEnabled(this.client.getRowCount() > 0);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.checkEnabled();
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

