/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ResultSetInfoPanel;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.sql.DwPanel;
import workbench.gui.sql.EditorPanel;
import workbench.gui.sql.SqlPanel;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.DurationFormatter;
import workbench.util.StringUtil;

public class ShowSourceQueryAction
extends WbAction {
    private SqlPanel panel;

    public ShowSourceQueryAction(SqlPanel sqlPanel) {
        this.panel = sqlPanel;
        this.isConfigurable = false;
        this.initMenuDefinition("MnuTxtShowQuery");
    }

    @Override
    public boolean isEnabled() {
        return this.panel != null && this.panel.getSourceQuery() != null;
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.showQuery();
    }

    public void showQuery() {
        EditorPanel editorPanel = EditorPanel.createSqlEditor();
        WbTabbedPane wbTabbedPane = new WbTabbedPane();
        String string = this.panel.getSourceQuery();
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        editorPanel.setText(string);
        editorPanel.setCaretPosition(0);
        editorPanel.setEditable(false);
        Window window = SwingUtilities.getWindowAncestor(this.panel);
        Frame frame = null;
        frame = window instanceof Frame ? (Frame)window : WbManager.getInstance().getCurrentWindow();
        String string2 = StringUtil.formatIsoTimestamp(this.panel.getLoadedAt());
        DwPanel dwPanel = this.panel.getCurrentResult();
        DurationFormatter durationFormatter = new DurationFormatter();
        long l = dwPanel.getLastExecutionTime();
        String string3 = durationFormatter.formatDuration(l);
        String string4 = ResourceMgr.getFormattedString("TxtLastExec", string2) + " (" + string3 + ")";
        JLabel jLabel = new JLabel(string4);
        EtchedBorder etchedBorder = new EtchedBorder(1);
        jLabel.setBorder(new CompoundBorder(etchedBorder, new EmptyBorder(3, 2, 2, 0)));
        jPanel.add((Component)editorPanel, "Center");
        jPanel.add((Component)jLabel, "North");
        ResultSetInfoPanel resultSetInfoPanel = new ResultSetInfoPanel(dwPanel);
        wbTabbedPane.addTab("SQL", jPanel);
        wbTabbedPane.addTab(ResourceMgr.getString("LblResultMeta"), resultSetInfoPanel);
        ValidatingDialog validatingDialog = new ValidatingDialog(frame, this.panel.getCurrentResultTitle(), (JComponent)wbTabbedPane, false);
        if (!Settings.getInstance().restoreWindowSize(validatingDialog, "workbench.resultquery.display")) {
            validatingDialog.setSize(500, 350);
        }
        WbSwingUtilities.center(validatingDialog, frame);
        WbSwingUtilities.repaintLater(editorPanel);
        validatingDialog.setVisible(true);
        Settings.getInstance().storeWindowSize(validatingDialog, "workbench.resultquery.display");
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

