/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import workbench.gui.actions.WbAction;
import workbench.gui.sql.DwPanel;
import workbench.gui.sql.SqlPanel;
import workbench.storage.DataStore;

public class SqlPanelReloadAction
extends WbAction {
    private SqlPanel client;

    public SqlPanelReloadAction(SqlPanel sqlPanel) {
        this.initMenuDefinition("TxtReloadResult");
        this.setMenuItemName("MnuTxtData");
        this.setIcon("refresh");
        this.setClient(sqlPanel);
    }

    public final void setClient(SqlPanel sqlPanel) {
        this.client = sqlPanel;
        this.checkEnabled();
    }

    public void checkEnabled() {
        DwPanel dwPanel;
        boolean bl = false;
        if (this.getSql() != null && (dwPanel = this.client.getCurrentResult()) != null) {
            DataStore dataStore = dwPanel.getDataStore();
            bl = dataStore != null ? dataStore.getOriginalConnection() != null : false;
        }
        this.setEnabled(bl);
    }

    protected String getSql() {
        if (this.client == null) {
            return null;
        }
        if (this.client.getCurrentResult() == null) {
            return null;
        }
        DataStore dataStore = this.client.getCurrentResult().getDataStore();
        if (dataStore == null) {
            return null;
        }
        String string = dataStore.getGeneratingSql();
        return string;
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.client.reloadCurrent();
    }
}

