/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import workbench.gui.actions.CheckBoxAction;
import workbench.gui.sql.EditorPanel;
import workbench.resource.Settings;

public class ToggleSelectionHighlightAction
extends CheckBoxAction
implements PropertyChangeListener {
    private final EditorPanel editor;

    public ToggleSelectionHighlightAction(EditorPanel editorPanel) {
        super("MnuTxtHiliteSel");
        this.editor = editorPanel;
        this.setMenuItemName("MnuTxtEdit");
        Settings.getInstance().addPropertyChangeListener(this, "workbench.editor.occurance.highlight.enable", new String[0]);
        this.checkSwitchedOn();
    }

    private void checkSwitchedOn() {
        if (this.editor.isGlobalSelectionHighlight()) {
            this.setSwitchedOn(Settings.getInstance().getHighlightCurrentSelection());
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        super.executeAction(actionEvent);
        this.editor.setHighlightSelection(this.isSwitchedOn());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.checkSwitchedOn();
    }

    @Override
    public void dispose() {
        super.dispose();
        Settings.getInstance().removePropertyChangeListener(this);
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

