/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.LogFileViewer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.ToolDefinition;
import workbench.util.WbFile;

public class ViewLogfileAction
extends WbAction
implements WindowListener {
    private static ViewLogfileAction instance = new ViewLogfileAction();
    private LogFileViewer viewer = null;

    public static ViewLogfileAction getInstance() {
        return instance;
    }

    private ViewLogfileAction() {
        this.initMenuDefinition("MnuTxtViewLogfile");
        String string = ResourceMgr.getFormattedString("d_MnuTxtViewLogfile", Integer.toString(LogFileViewer.getMaxLines()));
        this.setTooltip(string);
        this.removeIcon();
        WbFile wbFile = LogMgr.getLogfile();
        this.setEnabled(wbFile != null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        WbFile wbFile = LogMgr.getLogfile();
        if (wbFile == null) {
            return;
        }
        String string = Settings.getInstance().getOpenLogFileTool();
        if (ViewLogfileAction.invokedByMouse(actionEvent) && ViewLogfileAction.isCtrlPressed(actionEvent)) {
            string = "system";
        } else if (ViewLogfileAction.invokedByMouse(actionEvent) && ViewLogfileAction.isShiftPressed(actionEvent)) {
            string = "internal";
        }
        boolean bl = false;
        if (StringUtil.equalStringIgnoreCase("system", string)) {
            bl = this.openWithSystem(wbFile);
        } else if (StringUtil.stringsAreNotEqual("internal", string)) {
            bl = this.openWithProgram(string, wbFile);
        }
        if (!bl) {
            this.openInteralViewer(wbFile);
        }
    }

    private boolean openWithProgram(String string, WbFile wbFile) {
        WbFile wbFile2 = new WbFile(string);
        if (!wbFile2.exists()) {
            return false;
        }
        ToolDefinition toolDefinition = new ToolDefinition(string, null, null);
        try {
            toolDefinition.runApplication('\"' + wbFile.getAbsolutePath() + '\"');
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean openWithSystem(WbFile wbFile) {
        try {
            Desktop.getDesktop().open(wbFile);
            return true;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when opening logfile", exception);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
            return false;
        }
    }

    private void openInteralViewer(WbFile wbFile) {
        EventQueue.invokeLater(() -> {
            if (this.viewer == null) {
                try {
                    this.viewer = new LogFileViewer(WbManager.getInstance().getCurrentWindow());
                    this.viewer.addWindowListener(this);
                    this.viewer.setText(ResourceMgr.getString("LblLoadingProgress"));
                    this.viewer.setVisible(true);
                    this.viewer.showFile(wbFile);
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error displaying the log file", exception);
                    WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
                }
            } else {
                this.viewer.toFront();
            }
        });
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.viewer = null;
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

