/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.WbConnection;
import workbench.gui.completion.BaseAnalyzer;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.wbcommands.WbOraShow;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;

public class OraShowAnalyzer
extends BaseAnalyzer {
    private boolean showSpParameters;

    public OraShowAnalyzer(WbConnection wbConnection, String string, int n) {
        super(wbConnection, string, n);
    }

    @Override
    protected void checkContext() {
        this.context = 5;
        this.showSpParameters = false;
        int n = -1;
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, this.sql);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        while (sQLToken != null) {
            String string = sQLToken.getContents().toLowerCase();
            if (string.startsWith("param") || string.startsWith("spparam")) {
                n = sQLToken.getCharEnd();
                this.showSpParameters = string.startsWith("spparm");
            }
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        if (n > -1 && this.cursorPos >= n) {
            this.context = 16;
        }
    }

    @Override
    protected void buildResult() {
        if (this.context == 16) {
            String string = this.showSpParameters ? "select name from v$spparameter order by lower(name)" : "select name from v$parameter order by lower(name)";
            DataStore dataStore = SqlUtil.getResult(this.dbConnection, string, false);
            this.elements = new ArrayList(dataStore.getRowCount());
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                this.elements.add(dataStore.getValueAsString(i, 0));
            }
        } else if (this.context == 5) {
            this.elements = new ArrayList(10);
            List<String> list = WbOraShow.getOptions();
            Collections.sort(list);
            this.elements.addAll(list);
        }
    }
}

