/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.gui.completion.ExplainAnalyzer;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;

public class PostgresExplainAnalyzer
extends ExplainAnalyzer {
    public PostgresExplainAnalyzer(WbConnection wbConnection, String string, int n) {
        super(wbConnection, string, n);
    }

    @Override
    protected void checkContext() {
        String string = this.getExplainSql();
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        boolean bl = JdbcUtils.hasMinimumServerVersion(this.dbConnection, "10");
        Map<String, List<String>> map = this.get90Options(bl);
        int n = -1;
        int n2 = -1;
        int n3 = string.indexOf(40);
        boolean bl2 = n3 > -1;
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        SQLToken sQLToken2 = null;
        String string2 = null;
        while (sQLToken != null) {
            if (bl2) {
                if (map.containsKey(sQLToken.getContents())) {
                    set.add(sQLToken.getContents());
                }
            } else {
                if ("ANALYZE".equalsIgnoreCase(sQLToken.getContents())) {
                    n = sQLToken.getCharBegin();
                }
                if ("VERBOSE".equalsIgnoreCase(sQLToken.getContents())) {
                    n2 = sQLToken.getCharBegin();
                }
            }
            sQLToken2 = sQLToken;
            sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken2 == null || sQLToken == null || this.cursorPos < sQLToken2.getCharEnd() || this.cursorPos > sQLToken.getCharBegin()) continue;
            string2 = sQLToken2.getContents();
        }
        if (bl2) {
            if (set.isEmpty()) {
                this.elements = new ArrayList<String>(map.keySet());
                this.context = 9;
            } else {
                String string3 = string2;
                if (map.containsKey(string3)) {
                    this.elements = map.get(string3);
                    this.context = 10;
                } else {
                    this.elements = CollectionUtil.arrayList();
                    for (String string4 : map.keySet()) {
                        if (set.contains(string4)) continue;
                        this.elements.add(string4);
                        this.context = 9;
                    }
                }
            }
        } else if (n == -1 && n2 == -1 || n2 > -1 && this.cursorPos <= n2) {
            this.elements = CollectionUtil.arrayList("analyze");
            this.context = 9;
        } else if (n > -1 && this.cursorPos >= n) {
            this.elements = CollectionUtil.arrayList("verbose");
            this.context = 9;
        } else {
            this.context = -1;
        }
    }

    private Map<String, List<String>> get90Options(boolean bl) {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(CaseInsensitiveComparator.INSTANCE);
        List<String> list = CollectionUtil.arrayList("true", "false");
        treeMap.put("analyze", list);
        treeMap.put("verbose", list);
        treeMap.put("costs", list);
        treeMap.put("buffers", list);
        treeMap.put("format", CollectionUtil.arrayList("text", "xml", "json", "yaml"));
        treeMap.put("timing", list);
        if (bl) {
            treeMap.put("summary", list);
        }
        return treeMap;
    }

    @Override
    protected int getStatementStart(String string) {
        Set<String> set = CollectionUtil.caseInsensitiveSet("SELECT", "UPDATE", "INSERT", "DELETE", "VALUES", "EXECUTE", "DECLARE", "CREATE", "WITH");
        try {
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            while (sQLToken != null) {
                if (set.contains(sQLToken.getContents())) {
                    return sQLToken.getCharBegin();
                }
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            return Integer.MAX_VALUE;
        }
        catch (Exception exception) {
            return Integer.MAX_VALUE;
        }
    }
}

