/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.DBID;
import workbench.db.WbConnection;
import workbench.gui.completion.AlterTableAnalyzer;
import workbench.gui.completion.BaseAnalyzer;
import workbench.gui.completion.CreateAnalyzer;
import workbench.gui.completion.CteAnalyzer;
import workbench.gui.completion.CteDefinition;
import workbench.gui.completion.CteParser;
import workbench.gui.completion.DdlAnalyzer;
import workbench.gui.completion.DeleteAnalyzer;
import workbench.gui.completion.ExecAnalyzer;
import workbench.gui.completion.ExplainAnalyzerFactory;
import workbench.gui.completion.InsertAnalyzer;
import workbench.gui.completion.OraShowAnalyzer;
import workbench.gui.completion.PgShowAnalyzer;
import workbench.gui.completion.SelectAnalyzer;
import workbench.gui.completion.UpdateAnalyzer;
import workbench.gui.completion.UseAnalyzer;
import workbench.gui.completion.WbCommandAnalyzer;
import workbench.gui.completion.WbSetSchemaAnalyzer;
import workbench.gui.completion.WbSwitchDbAnalyzer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.wbcommands.CommandTester;
import workbench.util.CollectionUtil;
import workbench.util.SqlParsingUtil;

public class StatementContext {
    private BaseAnalyzer analyzer;

    public StatementContext(WbConnection wbConnection, String string, int n) {
        this(wbConnection, string, n, true);
    }

    public StatementContext(WbConnection wbConnection, String string, int n, boolean bl) {
        BaseAnalyzer baseAnalyzer = this.checkCTE(wbConnection, string, n);
        if (baseAnalyzer == null) {
            baseAnalyzer = this.checkSubselect(wbConnection, string, n);
        }
        BaseAnalyzer baseAnalyzer2 = this.createAnalyzer(wbConnection, string, n);
        if (baseAnalyzer != null) {
            this.analyzer = baseAnalyzer;
            this.analyzer.setParent(baseAnalyzer2);
        } else if (baseAnalyzer2 != null) {
            this.analyzer = baseAnalyzer2;
            this.analyzer.setParent(null);
        }
        if (this.analyzer != null && bl) {
            this.analyzer.retrieveObjects();
        }
    }

    private BaseAnalyzer createAnalyzer(WbConnection wbConnection, String string, int n) {
        String string2 = SqlParsingUtil.getInstance(wbConnection).getSqlVerb(string);
        BaseAnalyzer baseAnalyzer = null;
        CommandTester commandTester = new CommandTester();
        if ("SELECT".equalsIgnoreCase(string2) || "WbSelectBlob".equalsIgnoreCase(string2)) {
            baseAnalyzer = new SelectAnalyzer(wbConnection, string, n);
        } else if ("UPDATE".equalsIgnoreCase(string2)) {
            baseAnalyzer = new UpdateAnalyzer(wbConnection, string, n);
        } else if ("DELETE".equalsIgnoreCase(string2)) {
            baseAnalyzer = new DeleteAnalyzer(wbConnection, string, n);
        } else if ("DROP".equalsIgnoreCase(string2) || "TRUNCATE".equalsIgnoreCase(string2)) {
            baseAnalyzer = new DdlAnalyzer(wbConnection, string, n);
        } else if ("ALTER".equalsIgnoreCase(string2)) {
            baseAnalyzer = new AlterTableAnalyzer(wbConnection, string, n);
        } else if ("INSERT".equalsIgnoreCase(string2)) {
            baseAnalyzer = new InsertAnalyzer(wbConnection, string, n);
        } else if ("CREATE".equalsIgnoreCase(string2) || "CREATE OR REPLACE".equalsIgnoreCase(string2)) {
            baseAnalyzer = new CreateAnalyzer(wbConnection, string, n);
        } else if ("EXECUTE".equalsIgnoreCase(string2) || "EXEC".equalsIgnoreCase(string2) || "WBCALL".equalsIgnoreCase(string2) || "CALL".equalsIgnoreCase(string2)) {
            baseAnalyzer = new ExecAnalyzer(wbConnection, string, n);
        } else if ("WbSwitchDB".equalsIgnoreCase(string2)) {
            baseAnalyzer = new WbSwitchDbAnalyzer(wbConnection, string2, n);
        } else if ("WbSetSchema".equalsIgnoreCase(string2)) {
            baseAnalyzer = new WbSetSchemaAnalyzer(wbConnection, string2, n);
        } else if (commandTester.isWbCommand(string2) || string2.toLowerCase().startsWith("wb")) {
            baseAnalyzer = new WbCommandAnalyzer(wbConnection, string, n);
        } else if ("EXPLAIN".equalsIgnoreCase(string2)) {
            ExplainAnalyzerFactory explainAnalyzerFactory = new ExplainAnalyzerFactory();
            baseAnalyzer = explainAnalyzerFactory.getAnalyzer(wbConnection, string, n);
        } else if ("WITH".equalsIgnoreCase(string2)) {
            baseAnalyzer = new CteAnalyzer(wbConnection, string, n);
        } else if ("USE".equalsIgnoreCase(string2) && wbConnection.getDbSettings().supportsUseDBStatement()) {
            baseAnalyzer = new UseAnalyzer(wbConnection, string, n);
        } else if ("SHOW".equalsIgnoreCase(string2) || "SET".equalsIgnoreCase(string2) || "RESET".equalsIgnoreCase(string2)) {
            if (wbConnection.getMetadata().isPostgres() || DBID.Greenplum.isDB(wbConnection)) {
                baseAnalyzer = new PgShowAnalyzer(wbConnection, string, n);
            } else if (wbConnection.getMetadata().isOracle()) {
                baseAnalyzer = new OraShowAnalyzer(wbConnection, string, n);
            }
        }
        return baseAnalyzer;
    }

    public BaseAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    private BaseAnalyzer checkCTE(WbConnection wbConnection, String string, int n) {
        String string2 = SqlParsingUtil.getInstance(wbConnection).getSqlVerb(string);
        if (!"WITH".equalsIgnoreCase(string2)) {
            return null;
        }
        CteParser cteParser = new CteParser(wbConnection, string);
        List<CteDefinition> list = cteParser.getCteDefinitions();
        if (list.isEmpty()) {
            return null;
        }
        for (CteDefinition cteDefinition : list) {
            if (n < cteDefinition.getStartInStatement() || n > cteDefinition.getEndInStatement()) continue;
            int n2 = n - cteDefinition.getStartInStatement();
            return this.createAnalyzer(wbConnection, cteDefinition.getInnerSql(), n2);
        }
        return null;
    }

    private BaseAnalyzer checkSubselect(WbConnection wbConnection, String string, int n) {
        Set<String> set = CollectionUtil.caseInsensitiveSet("UNION", "UNION ALL", "MINUS", "INTERSECT", "EXCEPT", "EXCEPT ALL");
        try {
            boolean bl;
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(wbConnection, string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken == null) {
                return null;
            }
            SQLToken sQLToken2 = null;
            int n2 = 0;
            int n3 = 0;
            String string2 = sQLToken.getContents();
            ArrayList<SQLToken> arrayList = new ArrayList<SQLToken>();
            int n4 = 0;
            boolean bl2 = false;
            boolean bl3 = bl = string2.equals("INSERT") || string2.equals("CREATE") || string2.equals("CREATE OR REPLACE");
            while (sQLToken != null) {
                String string3 = sQLToken.getContents();
                if ("(".equals(string3)) {
                    if (++n4 == 1) {
                        n2 = sQLToken.getCharBegin();
                    }
                } else if (")".equals(string3)) {
                    if (bl2 && --n4 == 0) {
                        n3 = sQLToken.getCharBegin();
                        if (n2 <= n && n <= n3) {
                            int n5 = n - n2 - 1;
                            String string4 = string.substring(n2 + 1, n3);
                            StatementContext statementContext = new StatementContext(wbConnection, string4, n5, false);
                            return statementContext.getAnalyzer();
                        }
                    }
                    if (n4 == 0) {
                        bl2 = false;
                        n2 = 0;
                        n3 = 0;
                    }
                } else if (n4 == 0 && bl && string3.equals("SELECT")) {
                    if (n >= sQLToken.getCharBegin()) {
                        int n6 = n - sQLToken.getCharBegin();
                        return new SelectAnalyzer(wbConnection, string.substring(sQLToken.getCharBegin()), n6);
                    }
                } else if (n4 == 0 && set.contains(string3)) {
                    arrayList.add(sQLToken);
                }
                if (n4 == 1 && sQLToken2 != null && sQLToken2.getContents().equals("(") && string3.equals("SELECT")) {
                    bl2 = true;
                }
                sQLToken2 = sQLToken;
                sQLToken = sQLLexer.getNextToken(false, false);
            }
            if (arrayList.size() > 0) {
                int n7;
                int n8 = 0;
                for (int i = 0; i < arrayList.size(); ++i) {
                    n7 = ((SQLToken)arrayList.get(i)).getCharBegin();
                    if (n8 <= n && n <= n7) {
                        int n9 = n - n8;
                        String string5 = string.substring(n8, n7);
                        StatementContext statementContext = new StatementContext(wbConnection, string5, n9);
                        return statementContext.getAnalyzer();
                    }
                    n8 = n7;
                }
                n7 = ((SQLToken)arrayList.get(arrayList.size() - 1)).getCharEnd();
                if (n >= n7) {
                    int n10 = n - n7;
                    StatementContext statementContext = new StatementContext(wbConnection, string.substring(n7), n10);
                    return statementContext.getAnalyzer();
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when checking sub-select", exception);
        }
        return null;
    }

    public boolean isStatementSupported() {
        return this.analyzer != null;
    }

    public List getData() {
        if (this.analyzer == null) {
            return Collections.EMPTY_LIST;
        }
        List list = this.analyzer.getData();
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public String getTitle() {
        if (this.analyzer == null) {
            return "";
        }
        return this.analyzer.getTitle();
    }
}

