/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.ConnectionMgr;
import workbench.db.WbConnection;
import workbench.db.importer.SpreadsheetReader;
import workbench.gui.completion.BaseAnalyzer;
import workbench.gui.completion.TooltipElement;
import workbench.gui.completion.TooltipFile;
import workbench.liquibase.ChangeSetIdentifier;
import workbench.liquibase.LiquibaseParser;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.CommandMapper;
import workbench.sql.SqlCommand;
import workbench.sql.VariablePool;
import workbench.sql.parser.ParserType;
import workbench.sql.wbcommands.WbDescribeObject;
import workbench.sql.wbcommands.WbTableSource;
import workbench.sql.wbcommands.WbViewSource;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.ArgumentValue;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.FileUtil;
import workbench.util.MessageBuffer;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbCommandAnalyzer
extends BaseAnalyzer {
    private boolean isParameter;
    private boolean changeCase = true;
    private final String wordDelimiters = " \t";
    private boolean useSheetIndex = true;
    private static final Map<String, Map<String, String>> LRU_DIR_MAP = new TreeMap<String, Map<String, String>>(CaseInsensitiveComparator.INSTANCE);

    public WbCommandAnalyzer(WbConnection wbConnection, String string, int n) {
        super(wbConnection, string, n);
    }

    @Override
    public boolean isWbParam() {
        return this.isParameter;
    }

    @Override
    public String getWordDelimiters() {
        if (this.context == 7) {
            return " \t";
        }
        if (this.context == 8) {
            return " \t=";
        }
        return super.getWordDelimiters();
    }

    @Override
    public char quoteCharForValue(String string) {
        if (this.isParameter) {
            return '\u0000';
        }
        if (this.context == 10) {
            return '\u0000';
        }
        if (string.indexOf(45) > -1 || string.indexOf(32) > -1) {
            if (string.indexOf(39) > -1) {
                return '\"';
            }
            return '\'';
        }
        return '\u0000';
    }

    @Override
    public void checkContext() {
        CommandMapper commandMapper = new CommandMapper();
        String string = StringUtil.getWordLeftOfCursor(this.sql, this.cursorPos, " \t");
        this.changeCase = true;
        if (string != null && string.trim().toLowerCase().equals("wb")) {
            this.context = 7;
            this.elements = new ArrayList();
            this.elements.addAll(commandMapper.getAllWbCommands());
            return;
        }
        SqlCommand sqlCommand = commandMapper.getCommandToUse(this.sql);
        if (sqlCommand == null) {
            this.context = -1;
            this.elements = null;
            return;
        }
        sqlCommand.setConnection(this.dbConnection);
        ArgumentParser argumentParser = sqlCommand.getArgumentParser();
        if (argumentParser == null) {
            this.context = this.showTableList(sqlCommand, argumentParser) ? 1 : (sqlCommand instanceof WbViewSource ? 15 : -1);
            this.elements = null;
            return;
        }
        argumentParser.parse(this.sql);
        String string2 = this.getCurrentParameter();
        this.isParameter = false;
        if (argumentParser.isRegistered(string2)) {
            this.context = 8;
            this.title = ResourceMgr.getString("LblCompletionListParmValues");
            ArgumentType argumentType = argumentParser.getArgumentType(string2);
            if (argumentType == ArgumentType.BoolArgument) {
                this.elements = new ArrayList(2);
                this.elements.add("true");
                this.elements.add("false");
            } else if (argumentType == ArgumentType.TableArgument) {
                this.context = 1;
                this.namespaceForTableList = this.getNamespaceFromCurrentWord();
            } else if (argumentType == ArgumentType.ViewArgument) {
                this.context = 15;
                this.namespaceForTableList = this.getNamespaceFromCurrentWord();
            } else if (argumentType == ArgumentType.ListArgument) {
                this.elements = new ArrayList<ArgumentValue>(argumentParser.getAllowedValues(string2));
            } else if (argumentType == ArgumentType.ObjectTypeArgument) {
                this.elements = new ArrayList<String>(this.dbConnection.getMetadata().getObjectTypes());
                if (this.verb.equalsIgnoreCase("WbGrepSource")) {
                    this.elements.add("FUNCTION");
                    this.elements.add("PROCEDURE");
                    this.elements.add("TRIGGER");
                }
            } else if (argumentType == ArgumentType.SchemaArgument) {
                this.elements = this.dbConnection.getDbSettings().supportsSchemas() ? new ArrayList<String>(this.dbConnection.getMetadata().getSchemas(this.dbConnection.getSchemaFilter())) : new ArrayList<String>(this.dbConnection.getMetadata().getCatalogInformation(this.dbConnection.getSchemaFilter()));
            } else if (argumentType == ArgumentType.CatalogArgument) {
                this.elements = new ArrayList<String>(this.dbConnection.getMetadata().getCatalogInformation(this.dbConnection.getCatalogFilter()));
            } else if (argumentType == ArgumentType.ProfileArgument) {
                this.elements = ConnectionMgr.getInstance().getProfileKeys();
                this.changeCase = false;
            } else if (argumentType == ArgumentType.Filename) {
                this.elements = this.getFiles(argumentParser, string2, false);
                this.setOverwriteCurrentWord(true);
            } else if (argumentType == ArgumentType.DirName) {
                this.elements = this.getFiles(argumentParser, string2, true);
                this.setOverwriteCurrentWord(true);
            } else if (string2.equalsIgnoreCase("sheetNumber") || string2.equalsIgnoreCase("targetSheet")) {
                this.useSheetIndex = true;
                this.elements = this.getSheetnames(sqlCommand, argumentParser, true);
                this.changeCase = false;
            } else if (string2.equalsIgnoreCase("changeSet")) {
                this.elements = this.getChangeSets(sqlCommand, argumentParser);
                this.changeCase = false;
            } else if (string2.equalsIgnoreCase("locale")) {
                this.elements = this.getLocales();
                this.changeCase = false;
            } else if (string2.equalsIgnoreCase("sheetName") || string2.equalsIgnoreCase("targetSheetName")) {
                this.useSheetIndex = false;
                this.elements = this.getSheetnames(sqlCommand, argumentParser, false);
                this.changeCase = false;
            } else {
                this.context = -1;
                this.elements = null;
            }
        } else if (this.showTableList(sqlCommand, argumentParser)) {
            this.context = 1;
            this.elements = null;
        } else {
            List<String> list;
            this.context = 6;
            this.elements = list = argumentParser.getRegisteredArguments();
            String string3 = SqlUtil.stripVerb(this.sql);
            argumentParser.parse(string3);
            List<String> list2 = argumentParser.getArgumentsOnCommandLine();
            this.elements.removeAll(list2);
            Collections.sort(this.elements, CaseInsensitiveComparator.INSTANCE);
            this.isParameter = argumentParser.needsSwitch();
            this.changeCase = false;
        }
    }

    private boolean showTableList(SqlCommand sqlCommand, ArgumentParser argumentParser) {
        int n;
        if (sqlCommand == null) {
            return false;
        }
        int n2 = n = argumentParser == null ? 0 : argumentParser.getArgumentCount();
        if (n > 0) {
            return false;
        }
        if (sqlCommand instanceof WbDescribeObject) {
            return true;
        }
        return sqlCommand instanceof WbTableSource;
    }

    @Override
    protected void buildResult() {
        if (this.context == 1 || this.context == 15) {
            super.buildResult();
        }
    }

    private WbFile getCurrentDir(String string) {
        File file;
        String string2 = this.getLastDirectory(string);
        if (StringUtil.isNonBlank(string2) && (file = new WbFile(string2)).exists()) {
            return file;
        }
        if (string.equalsIgnoreCase("stylesheet") && (file = Settings.getInstance().getDefaultXsltDirectory()).exists()) {
            return new WbFile(file);
        }
        return new WbFile(".");
    }

    private String getLastDirectory(String string) {
        if (string == null) {
            return null;
        }
        Map<String, String> map = LRU_DIR_MAP.get(this.getSqlVerb());
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    private void saveLastDirectory(WbFile wbFile) {
        if (wbFile == null) {
            return;
        }
        Map<String, String> map = LRU_DIR_MAP.get(this.getSqlVerb());
        if (map == null) {
            map = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
            LRU_DIR_MAP.put(this.getSqlVerb(), map);
        }
        String string = this.getCurrentParameter();
        if (wbFile.isDirectory()) {
            map.put(string, wbFile.getFullPath());
        } else {
            WbFile wbFile2 = new WbFile(wbFile.getParentFile());
            map.put(string, wbFile2.getFullPath());
        }
    }

    private List<WbFile> getFiles(ArgumentParser argumentParser, String string, boolean bl) {
        File[] fileArray;
        Serializable serializable;
        String string2 = argumentParser.getValue(string);
        if (StringUtil.isNonBlank(string2)) {
            serializable = new WbFile(string2);
            if (!((File)serializable).isDirectory()) {
                return null;
            }
            fileArray = ((File)serializable).listFiles();
            this.title = ((WbFile)serializable).getFullPath();
        } else {
            serializable = this.getCurrentDir(string);
            fileArray = ((File)serializable).listFiles();
            this.title = ((WbFile)serializable).getFullPath();
        }
        if (fileArray == null) {
            return null;
        }
        serializable = new ArrayList(fileArray.length);
        for (File file : fileArray) {
            if (bl && !file.isDirectory()) continue;
            TooltipFile tooltipFile = new TooltipFile(file);
            serializable.add(tooltipFile);
        }
        FileUtil.sortFiles((List<? extends File>)((Object)serializable));
        return serializable;
    }

    @Override
    public String getPasteValue(Object object) {
        if (object instanceof SheetEntry) {
            SheetEntry sheetEntry = (SheetEntry)object;
            if (this.useSheetIndex) {
                return NumberStringCache.getNumberString(sheetEntry.sheetIndex);
            }
            if (sheetEntry.sheetName.indexOf(32) > -1 || sheetEntry.sheetName.indexOf(45) > -1) {
                return "\"" + sheetEntry.sheetName + "\"";
            }
            return sheetEntry.sheetName;
        }
        if (object instanceof WbFile) {
            WbFile wbFile = (WbFile)object;
            this.saveLastDirectory(wbFile);
            return wbFile.getFullPath();
        }
        return null;
    }

    private List getLocales() {
        Locale[] localeArray = Locale.getAvailableLocales();
        ArrayList<String> arrayList = new ArrayList<String>(localeArray.length);
        for (Locale locale : localeArray) {
            String string = locale.toString();
            if (!StringUtil.isNonEmpty(string)) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private List getChangeSets(SqlCommand sqlCommand, ArgumentParser argumentParser) {
        argumentParser.parse(this.sql);
        WbFile wbFile = sqlCommand.evaluateFileArgument(argumentParser.getValue("file"));
        String string = argumentParser.getValue("encoding", "UTF-8");
        try {
            MessageBuffer messageBuffer = new MessageBuffer(1);
            LiquibaseParser liquibaseParser = new LiquibaseParser(wbFile, string, messageBuffer, ParserType.Standard);
            List<ChangeSetIdentifier> list = liquibaseParser.getChangeSets();
            ArrayList<1> arrayList = new ArrayList<1>();
            for (final ChangeSetIdentifier changeSetIdentifier : list) {
                TooltipElement tooltipElement = new TooltipElement(){

                    @Override
                    public String getTooltip() {
                        return changeSetIdentifier.getComment();
                    }

                    public String toString() {
                        return changeSetIdentifier.toString();
                    }
                };
                arrayList.add(tooltipElement);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSheetnames(SqlCommand sqlCommand, ArgumentParser argumentParser, boolean bl) {
        argumentParser.parse(this.sql);
        String string = argumentParser.getValue("file");
        if (string == null) {
            string = argumentParser.getValue("file");
        }
        string = VariablePool.getInstance().replaceAllParameters(string);
        WbFile wbFile = sqlCommand.evaluateFileArgument(string);
        ArrayList<SheetEntry> arrayList = new ArrayList<SheetEntry>();
        if (wbFile == null) {
            return arrayList;
        }
        SpreadsheetReader spreadsheetReader = SpreadsheetReader.Factory.createReader(wbFile, -1, null);
        if (spreadsheetReader == null) {
            return arrayList;
        }
        try {
            List<String> list = spreadsheetReader.getSheets();
            for (int i = 0; i < list.size(); ++i) {
                String string2 = null;
                String string3 = list.get(i);
                string2 = bl ? NumberStringCache.getNumberString(i + 1) + " - " + string3 : string3;
                SheetEntry sheetEntry = new SheetEntry(i + 1, string3, string2);
                arrayList.add(sheetEntry);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read spreadsheet: " + wbFile.getFullPath(), exception);
        }
        finally {
            spreadsheetReader.done();
        }
        return arrayList;
    }

    @Override
    public boolean convertCase() {
        return this.changeCase;
    }

    protected String getCurrentParameter() {
        char c;
        if (this.cursorPos > 1 && this.cursorPos <= this.sql.length() && Character.isWhitespace(c = this.sql.charAt(this.cursorPos - 1))) {
            return null;
        }
        String string = StringUtil.getWordLeftOfCursor(this.sql, this.cursorPos, " \t");
        if (string == null) {
            return null;
        }
        if (string.charAt(0) == '-' && string.length() > 2) {
            int n = string.indexOf(61);
            if (n == -1) {
                n = string.length() - 1;
            }
            return string.substring(1, n);
        }
        return null;
    }

    @Override
    public boolean needsCommaForMultipleSelection() {
        return this.context != 6;
    }

    private static class SheetEntry
    implements TooltipElement {
        private final int sheetIndex;
        private final String sheetName;
        private final String displayString;

        SheetEntry(int n, String string, String string2) {
            this.sheetIndex = n;
            this.sheetName = string;
            this.displayString = string2;
        }

        @Override
        public String getTooltip() {
            return this.sheetName + " - " + NumberStringCache.getNumberString(this.sheetIndex);
        }

        public String toString() {
            return this.displayString;
        }
    }
}

