/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    public static final float TOP = 0.0f;
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float BOTTOM = 1.0f;
    public static final float RIGHT = 1.0f;
    private Icon[] icons;
    private Axis axis;
    private int gap;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;

    public CompoundIcon(Icon ... iconArray) {
        this(Axis.X_AXIS, iconArray);
    }

    public CompoundIcon(Axis axis, Icon ... iconArray) {
        this(axis, 0, iconArray);
    }

    public CompoundIcon(Axis axis, int n, Icon ... iconArray) {
        this(axis, n, 0.5f, 0.5f, iconArray);
    }

    public CompoundIcon(Axis axis, int n, CompoundIcon compoundIcon, Icon icon) {
        this.axis = axis;
        this.gap = n;
        this.alignmentX = 0.5f;
        this.alignmentY = 0.5f;
        this.icons = new Icon[compoundIcon.icons.length + 1];
        System.arraycopy(compoundIcon.icons, 0, this.icons, 0, compoundIcon.icons.length);
        this.icons[compoundIcon.icons.length] = icon;
    }

    public CompoundIcon(Axis axis, int n, float f, float f2, Icon ... iconArray) {
        this.axis = axis;
        this.gap = n;
        float f3 = f > 1.0f ? 1.0f : (this.alignmentX = f < 0.0f ? 0.0f : f);
        this.alignmentY = f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2);
        for (int i = 0; i < iconArray.length; ++i) {
            if (iconArray[i] != null) continue;
            String string = "Icon (" + i + ") cannot be null";
            throw new IllegalArgumentException(string);
        }
        this.icons = iconArray;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getGap() {
        return this.gap;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public int getIconCount() {
        return this.icons.length;
    }

    public Icon getIcon(int n) {
        return this.icons[n];
    }

    public boolean contains(Icon icon) {
        for (Icon icon2 : this.icons) {
            if (icon2 != icon) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getIconWidth() {
        int n = 0;
        if (this.axis == Axis.X_AXIS) {
            n += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                n += icon.getIconWidth();
            }
        } else {
            for (Icon icon : this.icons) {
                n = Math.max(n, icon.getIconWidth());
            }
        }
        return n;
    }

    @Override
    public int getIconHeight() {
        int n = 0;
        if (this.axis == Axis.Y_AXIS) {
            n += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                n += icon.getIconHeight();
            }
        } else {
            for (Icon icon : this.icons) {
                n = Math.max(n, icon.getIconHeight());
            }
        }
        return n;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.axis == Axis.X_AXIS) {
            int n3 = this.getIconHeight();
            for (Icon icon : this.icons) {
                int n4 = this.getOffset(n3, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(component, graphics, n, n2 + n4);
                n += icon.getIconWidth() + this.gap;
            }
        } else if (this.axis == Axis.Y_AXIS) {
            int n5 = this.getIconWidth();
            for (Icon icon : this.icons) {
                int n6 = this.getOffset(n5, icon.getIconWidth(), this.alignmentX);
                icon.paintIcon(component, graphics, n + n6, n2);
                n2 += icon.getIconHeight() + this.gap;
            }
        } else {
            int n7 = this.getIconWidth();
            int n8 = this.getIconHeight();
            for (Icon icon : this.icons) {
                int n9 = this.getOffset(n7, icon.getIconWidth(), this.alignmentX);
                int n10 = this.getOffset(n8, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(component, graphics, n + n9, n2 + n10);
            }
        }
    }

    private int getOffset(int n, int n2, float f) {
        float f2 = (float)(n - n2) * f;
        return Math.round(f2);
    }

    public static enum Axis {
        X_AXIS,
        Y_AXIS,
        Z_AXIS;

    }
}

