/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.util.ArrayList;
import java.util.Arrays;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.datatype.DataType;
import workbench.db.ColumnIdentifier;
import workbench.storage.DataStore;

public class DBUnitTableAdapter
implements ITable {
    private int[] selectedRows;
    private DataStore dataStore;

    public DBUnitTableAdapter(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public Object getValue(int n, String string) throws DataSetException {
        if (n < 0 || n >= this.getRowCount()) {
            throw new RowOutOfBoundsException();
        }
        if (this.selectedRows != null) {
            n = this.selectedRows[n];
        }
        return this.dataStore.getValue(n, string);
    }

    public void setSelectedRows(int[] nArray) {
        this.selectedRows = (int[])(nArray == null ? null : Arrays.copyOf(nArray, nArray.length));
    }

    public ITableMetaData getTableMetaData() {
        return new ITableMetaData(){

            public String getTableName() {
                if (DBUnitTableAdapter.this.dataStore.getUpdateTable() != null) {
                    return DBUnitTableAdapter.this.dataStore.getUpdateTable().getTableName();
                }
                if (DBUnitTableAdapter.this.dataStore.getResultInfo() != null && DBUnitTableAdapter.this.dataStore.getResultInfo().getUpdateTable() != null) {
                    return DBUnitTableAdapter.this.dataStore.getResultInfo().getUpdateTable().getTableName();
                }
                if (DBUnitTableAdapter.this.dataStore.getInsertTable() != null) {
                    return DBUnitTableAdapter.this.dataStore.getInsertTable();
                }
                return "UNKNOWN";
            }

            public Column[] getPrimaryKeys() throws DataSetException {
                if (!DBUnitTableAdapter.this.dataStore.hasPkColumns()) {
                    return null;
                }
                ColumnIdentifier[] columnIdentifierArray = DBUnitTableAdapter.this.dataStore.getColumns();
                if (columnIdentifierArray == null) {
                    return null;
                }
                ArrayList<Column> arrayList = new ArrayList<Column>(1);
                for (ColumnIdentifier columnIdentifier : columnIdentifierArray) {
                    if (!columnIdentifier.isPkColumn()) continue;
                    DataType dataType = DataType.forSqlType((int)columnIdentifier.getDataType());
                    Column column = new Column(columnIdentifier.getColumnName(), dataType);
                    arrayList.add(column);
                }
                if (arrayList.isEmpty()) {
                    return null;
                }
                ColumnIdentifier[] columnIdentifierArray2 = arrayList.toArray(new Column[0]);
                return columnIdentifierArray2;
            }

            public Column[] getColumns() throws DataSetException {
                ArrayList<Column> arrayList = new ArrayList<Column>();
                for (int i = 0; i < DBUnitTableAdapter.this.dataStore.getColumns().length; ++i) {
                    String string = DBUnitTableAdapter.this.dataStore.getColumnName(i);
                    DataType dataType = DataType.forSqlType((int)DBUnitTableAdapter.this.dataStore.getColumnType(i));
                    Column column = new Column(string, dataType);
                    arrayList.add(column);
                }
                return arrayList.toArray(new Column[arrayList.size()]);
            }

            public int getColumnIndex(String string) throws DataSetException {
                return DBUnitTableAdapter.this.dataStore.getColumnIndex(string);
            }
        };
    }

    public int getRowCount() {
        if (this.selectedRows != null) {
            return this.selectedRows.length;
        }
        return this.dataStore.getRowCount();
    }
}

