/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import workbench.gui.components.WbButton;
import workbench.resource.IconMgr;

public class DropDownButton
extends WbButton
implements ActionListener,
PopupMenuListener {
    private JPopupMenu popup;
    private boolean popupVisible;
    private Border menuBorder = BorderFactory.createLineBorder(Color.GRAY, 1);

    public DropDownButton(String string) {
        super(string);
        this.init();
    }

    public DropDownButton(Icon icon) {
        super(icon);
        this.init();
    }

    private void init() {
        this.setFocusable(false);
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.enableToolbarRollover();
        int n = IconMgr.getInstance().getSizeForLabel();
        Dimension dimension = this.getPreferredSize();
        int n2 = (dimension.height - n) / 2;
        int n3 = (dimension.height - n) / 2;
        this.setMargin(new Insets(n3, n2, n3, n2));
    }

    public void dispose() {
        if (this.popup != null) {
            this.popup.removePopupMenuListener(this);
            this.popup.setVisible(false);
            this.popup.removeAll();
            this.popup = null;
        }
    }

    public void setDropDownMenu(JPopupMenu jPopupMenu) {
        if (this.popup != null) {
            this.popup.removePopupMenuListener(this);
            this.popup.setVisible(false);
            this.popup.removeAll();
        }
        this.popup = jPopupMenu;
        this.popup.setBorder(this.menuBorder);
        this.popup.addPopupMenuListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.popup == null) {
            return;
        }
        if (this.popupVisible) {
            this.popup.setVisible(false);
            this.popupVisible = false;
        } else {
            this.popup.show(this, 0, this.getHeight() - 2);
            this.popupVisible = true;
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.popupVisible = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.popupVisible = false;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.popupVisible = false;
    }
}

