/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.AutoCompletionAction;
import workbench.gui.actions.EscAction;
import workbench.gui.components.PlainEditor;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbStatusLabel;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.ResultLogger;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.BatchRunner;
import workbench.sql.ErrorDescriptor;
import workbench.sql.ErrorReportLevel;
import workbench.sql.ExecutionStatus;
import workbench.util.WbThread;

public abstract class ExecuteSqlPanel
extends JPanel
implements ActionListener,
WindowListener {
    private JDialog window;
    private PlainEditor errorDisplay;
    protected EditorPanel sqlEditor;
    protected BatchRunner runner;
    protected ErrorDescriptor lastError;
    private EscAction escAction;
    private JSplitPane splitPane;
    private AutoCompletionAction autoComplete;
    protected int choice = 2;
    private WbStatusLabel statusBar;
    private String sqlToUse;
    private boolean initialized;
    private WbThread runThread;
    private ExecutionStatus execStatus;

    protected ExecuteSqlPanel(WbConnection wbConnection) {
        this(wbConnection, null);
    }

    protected ExecuteSqlPanel(WbConnection wbConnection, String string) {
        super(new GridBagLayout());
        this.sqlToUse = string;
        this.runner = new BatchRunner();
        this.runner.setConnection(wbConnection);
    }

    protected void showLastError() {
        this.showError(this.lastError);
    }

    public void showError(ErrorDescriptor errorDescriptor) {
        int n = 0;
        if (errorDescriptor != null) {
            this.errorDisplay.setText(errorDescriptor.getErrorMessage());
            if (errorDescriptor.getErrorPosition() > -1) {
                n = errorDescriptor.getErrorPosition();
            }
        }
        this.sqlEditor.setCaretPosition(n);
    }

    protected abstract JPanel getToolPanel();

    protected abstract JLabel getLabel();

    protected void closeDialog(int n) {
        this.choice = n;
        this.closeWindow();
    }

    protected void closeWindow() {
        if (this.window == null) {
            return;
        }
        EventQueue.invokeLater(() -> {
            this.window.setVisible(false);
            this.window.dispose();
        });
    }

    public int getChoice() {
        return this.choice;
    }

    public ErrorDescriptor getError() {
        return this.lastError;
    }

    protected void initUI() {
        if (this.initialized) {
            return;
        }
        this.errorDisplay = new PlainEditor("workbench.sql.error.wordwrap", false, false);
        this.sqlEditor = EditorPanel.createSqlEditor();
        this.statusBar = new WbStatusLabel();
        this.splitPane = new WbSplitPane(0, true, this.sqlEditor, this.errorDisplay);
        this.autoComplete = new AutoCompletionAction(this.sqlEditor, this.statusBar);
        this.sqlEditor.setDatabaseConnection(this.runner.getConnection());
        this.autoComplete.setConnection(this.runner.getConnection());
        if (this.sqlToUse != null) {
            this.sqlEditor.setText(this.sqlToUse);
        }
        JLabel jLabel = this.getLabel();
        int n = 8;
        Font font = null;
        FontMetrics fontMetrics = null;
        font = jLabel == null ? UIManager.getDefaults().getFont("Label.font") : jLabel.getFont();
        fontMetrics = this.statusBar.getFontMetrics(font);
        if (fontMetrics != null) {
            n = fontMetrics.getHeight() / 2;
        }
        int n2 = IconMgr.getInstance().getSizeForLabel();
        JPanel jPanel = this.getToolPanel();
        int n3 = n2 / 5;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(n3, n, n3, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        if (jLabel != null) {
            this.add((Component)jLabel, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(jLabel == null ? n : 0, n, n3, n);
        gridBagConstraints.fill = 1;
        this.add((Component)this.splitPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, n, n2, n);
        gridBagConstraints.fill = 2;
        this.add((Component)this.statusBar, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, n, n2 / 3, n);
        this.add((Component)jPanel, gridBagConstraints);
        this.initialized = true;
    }

    public boolean isSuccess() {
        return this.execStatus == ExecutionStatus.Success;
    }

    public void dispose() {
        if (this.autoComplete != null) {
            this.autoComplete.dispose();
        }
        this.sqlEditor.dispose();
    }

    protected void setButtonsEnabled(boolean bl) {
        this.autoComplete.setEnabled(bl);
    }

    protected void startSQL() {
        this.runThread = new WbThread("SqlExecThread"){

            @Override
            public void run() {
                ExecuteSqlPanel.this.runSQL();
            }
        };
        this.runThread.start();
    }

    protected void runSQL() {
        if (this.runner.getConnection() == null) {
            return;
        }
        if (this.runner.isBusy()) {
            return;
        }
        try {
            this.runner.setRowMonitor(this.statusBar.getMonitor());
            this.runner.setAbortOnError(true);
            this.runner.setStoreErrors(false);
            this.runner.setPrintStatements(false);
            this.runner.setShowProgress(false);
            this.runner.setShowTiming(false);
            this.runner.setStoreErrors(false);
            this.runner.setShowStatementWithResult(false);
            this.runner.setShowStatementSummary(false);
            this.runner.setErrorStatementLogging(ErrorReportLevel.none);
            this.runner.setMessageLogger(ResultLogger.DEV_NULL_LOGGER);
            this.runner.getConnection().setBusy(true);
            this.setButtonsEnabled(false);
            this.clearError();
            this.statusBar.setStatusMessage(ResourceMgr.getString("MsgExecutingSql"));
            this.execStatus = this.runner.runScript(this.sqlEditor.getText());
            this.lastError = this.runner.getLastError();
            if (this.isSuccess()) {
                this.scriptSuccess();
            } else {
                this.scriptError();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not run SQL script", exception);
            WbSwingUtilities.showErrorMessage(exception.getMessage());
        }
        finally {
            this.runner.getConnection().setBusy(false);
            this.statusBar.clearStatusMessage();
            this.runner.done();
            this.setButtonsEnabled(true);
            this.runThread = null;
        }
    }

    protected void cancel() {
        this.showStatusMessage(ResourceMgr.getString("MsgCancellingStmt"));
        if (this.runner != null) {
            this.runner.cancel();
        }
        try {
            if (this.runThread != null) {
                this.runThread.interrupt();
            }
            this.runThread = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.showStatusMessage("");
    }

    protected void showStatusMessage(String string) {
        this.statusBar.setStatusMessage(string);
    }

    protected void scriptError() {
        EventQueue.invokeLater(() -> {
            this.showLastError();
            this.sqlEditor.requestFocusInWindow();
        });
    }

    protected void scriptSuccess() {
        WbSwingUtilities.invoke(this::showSuccessMessage);
    }

    protected void clearError() {
        this.errorDisplay.setText("");
    }

    protected void showSuccessMessage() {
        this.errorDisplay.setText(ResourceMgr.getString("TxtScriptFinished"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.escAction) {
            this.closeDialog(2);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.splitPane.setDividerLocation(0.8);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    protected abstract String getWindowSettingsKey();

    protected void restoreSettings() {
        if (this.window != null && !Settings.getInstance().restoreWindowSize(this.window, this.getWindowSettingsKey())) {
            this.window.setSize(640, 480);
        }
    }

    protected void saveSettings() {
        if (this.window != null) {
            Settings.getInstance().storeWindowSize(this.window, this.getWindowSettingsKey());
        }
    }

    public void showDialog(Window window, String string, boolean bl) {
        this.window = bl ? new JDialog(window, string, Dialog.ModalityType.APPLICATION_MODAL) : new JDialog(window, string, Dialog.ModalityType.MODELESS);
        this.initUI();
        this.escAction = new EscAction(this.window, this);
        this.sqlEditor.addKeyBinding(this.escAction);
        this.window.getContentPane().add(this);
        this.restoreSettings();
        WbSwingUtilities.center(this.window, window);
        WbSwingUtilities.requestComponentFocus(this.window, this.sqlEditor);
        this.window.addWindowListener(this);
        this.window.setVisible(true);
        this.saveSettings();
    }
}

