/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class NumberField
extends JTextField {
    private NumberFormat integerFormatter;
    protected char decimalSep = (char)46;

    public NumberField() {
        this.init();
    }

    public NumberField(int n) {
        super(n);
        this.init();
    }

    private void init() {
        this.integerFormatter = NumberFormat.getNumberInstance(Locale.getDefault());
        this.integerFormatter.setParseIntegerOnly(true);
    }

    public void setDecimalChar(char c) {
        this.decimalSep = c;
    }

    public char getDecimalChar() {
        return this.decimalSep;
    }

    public int getValue() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            LogMgr.logError(new CallerInfo(){}, "Invalid value entered", parseException);
        }
        return n;
    }

    public final void setValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    @Override
    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                if (!Character.isDigit(cArray[i])) continue;
                cArray2[n2++] = cArray[i];
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

