/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.FilterDataAction;
import workbench.gui.actions.FilterPickerAction;
import workbench.gui.actions.QuickFilterAction;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.ResetFilterAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.HistoryTextField;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbMenu;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.dbobjects.QuickFilterExpressionBuilder;
import workbench.gui.filter.DefineFilterExpressionPanel;
import workbench.gui.filter.FilterDefinitionManager;
import workbench.interfaces.CriteriaPanel;
import workbench.interfaces.PropertyStorage;
import workbench.interfaces.QuickFilter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.FilterExpression;
import workbench.util.StringUtil;

public class QuickFilterPanel
extends JPanel
implements QuickFilter,
CriteriaPanel,
ActionListener,
MouseListener,
PropertyChangeListener,
KeyListener {
    private final WbTable searchTable;
    private String searchColumn;
    private HistoryTextField filterValue;
    private WbToolbar toolbar;
    private JComboBox columnDropDown;
    private QuickFilterAction filterAction;
    private String[] columnList;
    private final boolean showColumnDropDown;
    private FilterDefinitionManager filterMgr;
    private JCheckBoxMenuItem[] columnItems;
    private TextComponentMouseListener textListener;
    private boolean assumeWildcards;
    private boolean autoFilterEnabled;
    private ReloadAction delegateFilterAction;
    private boolean ignoreEvents;

    public QuickFilterPanel(WbTable wbTable, boolean bl, String string) {
        this(wbTable, bl, null, string);
    }

    public QuickFilterPanel(WbTable wbTable, boolean bl, FilterDefinitionManager filterDefinitionManager, String string) {
        this.searchTable = wbTable;
        this.searchTable.addPropertyChangeListener("model", this);
        this.showColumnDropDown = bl;
        this.filterMgr = filterDefinitionManager;
        this.initGui(string);
    }

    public void setReloadAction(ReloadAction reloadAction) {
        this.delegateFilterAction = reloadAction;
    }

    public void dispose() {
        WbAction.dispose(this.filterAction);
        this.delegateFilterAction = null;
        if (this.filterValue != null) {
            this.filterValue.dispose();
        }
        if (this.textListener != null) {
            this.textListener.dispose();
        }
        if (this.toolbar != null) {
            this.toolbar.removeAll();
        }
        if (this.searchTable != null) {
            this.searchTable.removePropertyChangeListener(this);
        }
        if (this.columnDropDown != null) {
            this.columnDropDown.removeActionListener(this);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.toolbar.setEnabled(bl);
        this.filterValue.setEnabled(bl);
        this.setActionsEnabled(bl);
    }

    public void setActionsEnabled(boolean bl) {
        ResetFilterAction resetFilterAction;
        this.filterAction.setEnabled(bl);
        if (this.searchTable != null && (resetFilterAction = this.searchTable.getResetFilterAction()) != null) {
            resetFilterAction.setEnabled(bl);
        }
    }

    public void setFilterOnType(boolean bl) {
        this.autoFilterEnabled = bl;
    }

    public void setAlwaysUseContainsFilter(boolean bl) {
        this.assumeWildcards = bl;
    }

    private void initDropDown() {
        this.columnDropDown = this.columnList == null ? new JComboBox<String>(new String[]{"        "}) : new JComboBox<String>(this.columnList);
        this.columnDropDown.addActionListener(this);
        this.columnDropDown.setSelectedIndex(0);
        this.columnDropDown.setToolTipText(ResourceMgr.getString("TxtQuickFilterColumnSelector"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.add((Component)this.columnDropDown, gridBagConstraints);
    }

    public void setFilterTooltip() {
        String string = "";
        if (this.searchColumn != null) {
            string = ResourceMgr.getFormattedString("TxtQuickFilterCurrCol", this.searchColumn);
        }
        String string2 = GuiSettings.getUseRegexInQuickFilter() ? ResourceMgr.getFormattedString("TxtQuickFilterRegexHint", string) : ResourceMgr.getFormattedString("TxtQuickFilterColumnHint", string);
        this.filterValue.setToolTipText(string2);
    }

    @Override
    public void setToolTipText(String string) {
        this.filterValue.setToolTipText(string);
    }

    private void initGui(String string) {
        Serializable serializable;
        Object object;
        this.setLayout(new GridBagLayout());
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.filterValue = new HistoryTextField(string);
        this.setFilterTooltip();
        this.filterValue.setColumns(10);
        this.initPopup();
        this.toolbar = new WbToolbar();
        this.filterAction = new QuickFilterAction(this);
        this.filterAction.setUseLabelIconSize(true);
        ResetFilterAction resetFilterAction = this.searchTable.getResetFilterAction();
        resetFilterAction.setUseLabelIconSize(true);
        this.toolbar.add(this.filterAction);
        if (this.filterMgr != null) {
            object = new FilterDataAction(this.searchTable, this.filterMgr);
            ((WbAction)object).setMenuTextByKey("MnuTxtDefineFilter");
            ((WbAction)object).removeIcon();
            this.filterAction.registerCtrlClickAction((WbAction)object);
            serializable = new WbAction(){

                @Override
                public void executeAction(ActionEvent actionEvent) {
                    FilterExpression filterExpression = DefineFilterExpressionPanel.loadFilter(QuickFilterPanel.this, QuickFilterPanel.this.filterMgr);
                    if (filterExpression != null) {
                        QuickFilterPanel.this.searchTable.applyFilter(filterExpression);
                    }
                }
            };
            ((WbAction)serializable).setMenuTextByKey("MnuTxtLoadFilter");
            FilterPickerAction filterPickerAction = new FilterPickerAction(this.searchTable, this.filterMgr, new WbAction[]{object, serializable});
            this.toolbar.add(filterPickerAction);
        }
        this.toolbar.add(resetFilterAction);
        this.toolbar.setMargin(WbSwingUtilities.getEmptyInsets());
        this.toolbar.setBorderPainted(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.toolbar, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.filterValue, gridBagConstraints);
        if (this.showColumnDropDown) {
            this.initDropDown();
        }
        object = new WbTraversalPolicy();
        ((WbTraversalPolicy)object).setDefaultComponent(this.filterValue);
        ((WbTraversalPolicy)object).addComponent(this.filterValue);
        ((WbTraversalPolicy)object).addComponent(this.filterAction.getToolbarButton());
        ((WbTraversalPolicy)object).addComponent(resetFilterAction.getToolbarButton());
        this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
        this.setFocusCycleRoot(false);
        this.filterValue.addActionListener(this);
        serializable = this.filterValue.getEditor().getEditorComponent();
        ((Component)serializable).addKeyListener(this);
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.quickfilter.useregex", new String[0]);
    }

    public void setToolbarBorder(Border border) {
        this.toolbar.setBorder(border);
    }

    public void addToToolbar(WbAction wbAction, int n) {
        this.toolbar.add(wbAction, n);
    }

    private void initPopup() {
        if (this.columnList == null) {
            return;
        }
        Component component = this.filterValue.getEditor().getEditorComponent();
        if (this.textListener != null) {
            component.removeMouseListener(this.textListener);
        }
        this.textListener = new TextComponentMouseListener();
        WbMenu wbMenu = new WbMenu(ResourceMgr.getString("MnuTextFilterOnColumn"));
        this.columnItems = new JCheckBoxMenuItem[this.columnList.length];
        for (int i = 0; i < this.columnList.length; ++i) {
            this.columnItems[i] = new JCheckBoxMenuItem(this.columnList[i]);
            this.columnItems[i].setSelected(i == 0);
            this.columnItems[i].putClientProperty("filterColumn", this.columnList[i]);
            this.columnItems[i].addActionListener(this);
            wbMenu.add(this.columnItems[i]);
        }
        this.textListener.addMenuItem(wbMenu);
        this.setFilterTooltip();
        component.addMouseListener(this.textListener);
    }

    @Override
    public void setColumnList(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (StringUtil.arraysEqual(stringArray, this.columnList)) {
            return;
        }
        this.columnList = Arrays.copyOf(stringArray, stringArray.length);
        this.searchColumn = stringArray[0];
        this.initPopup();
        if (this.showColumnDropDown) {
            if (this.columnDropDown == null) {
                this.initDropDown();
            } else {
                this.columnDropDown.setModel(new DefaultComboBoxModel<String>(this.columnList));
            }
        }
    }

    @Override
    public void saveSettings(PropertyStorage propertyStorage, String string) {
        this.filterValue.saveSettings(propertyStorage, string);
    }

    @Override
    public void restoreSettings(PropertyStorage propertyStorage, String string) {
        this.filterValue.removeActionListener(this);
        this.filterValue.restoreSettings(propertyStorage, string);
        this.filterValue.addActionListener(this);
    }

    @Override
    public void saveSettings() {
        this.filterValue.saveSettings();
    }

    @Override
    public void restoreSettings() {
        this.filterValue.removeActionListener(this);
        this.filterValue.restoreSettings();
        this.filterValue.addActionListener(this);
    }

    @Override
    public void setFocusToEntryField() {
        this.filterValue.grabFocus();
    }

    @Override
    public void applyQuickFilter() {
        this.applyFilter(this.filterValue.getEditorText(), true);
    }

    @Override
    public void resetFilter() {
        this.applyFilter(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilter(String string, boolean bl) {
        block8: {
            JTextField jTextField = (JTextField)this.filterValue.getEditor().getEditorComponent();
            int n = jTextField.getCaretPosition();
            try {
                this.ignoreEvents = true;
                if (StringUtil.isEmptyString(string) || string.trim().equals("*") || string.trim().equals("%")) {
                    this.searchTable.resetFilter();
                    this.searchTable.clearLastFilter(false);
                    break block8;
                }
                this.filterValue.setText(string);
                try {
                    QuickFilterExpressionBuilder quickFilterExpressionBuilder = new QuickFilterExpressionBuilder();
                    ColumnExpression columnExpression = quickFilterExpressionBuilder.buildExpression(string, this.searchColumn, this.assumeWildcards);
                    this.searchTable.applyFilter(columnExpression);
                    if (bl) {
                        this.filterValue.addToHistory(string);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.searchTable.resetFilter();
                    LogMgr.logError(new CallerInfo(){}, "Cannot apply filter expression", patternSyntaxException);
                    String string2 = ResourceMgr.getFormattedString("ErrBadRegex", string);
                    WbSwingUtilities.showErrorMessage(this, string2);
                }
                catch (Throwable throwable) {
                    LogMgr.logError(new CallerInfo(){}, "Cannot apply filter expression", throwable);
                    WbSwingUtilities.showErrorMessage(this, throwable.getLocalizedMessage());
                }
            }
            finally {
                jTextField.setCaretPosition(n);
                this.setCaretPosition(jTextField, n);
                this.ignoreEvents = false;
            }
        }
    }

    private void setCaretPosition(JTextField jTextField, int n) {
        WbSwingUtilities.invokeLater(() -> {
            if (jTextField.getCaretPosition() != n) {
                jTextField.setCaretPosition(n);
            }
            if (jTextField.getSelectionStart() != jTextField.getSelectionEnd()) {
                jTextField.select(n, n);
            }
        });
    }

    @Override
    public String getText() {
        return this.filterValue.getText();
    }

    @Override
    public void setText(String string) {
        this.filterValue.setText(string);
    }

    @Override
    public void addToToolbar(WbAction wbAction, boolean bl, boolean bl2) {
        JButton jButton = wbAction.getToolbarButton();
        if (bl) {
            this.toolbar.add((Component)jButton, 0);
            if (bl2) {
                this.toolbar.addSeparator(1);
            }
        } else {
            this.toolbar.addSeparator();
            if (bl2) {
                this.toolbar.add(jButton);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block10: {
            block8: {
                block9: {
                    if (actionEvent.getSource() != this.filterValue || this.ignoreEvents) break block8;
                    if (this.delegateFilterAction == null) break block9;
                    this.delegateFilterAction.executeAction(actionEvent);
                    break block10;
                }
                if (!this.filterValue.isPopupVisible() || !"comboBoxChanged".equals(actionEvent.getActionCommand())) break block10;
                this.applyQuickFilter();
                break block10;
            }
            if (actionEvent.getSource() instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                for (JCheckBoxMenuItem jCheckBoxMenuItem : this.columnItems) {
                    jCheckBoxMenuItem.setSelected(false);
                }
                jMenuItem.setSelected(true);
                this.searchColumn = (String)jMenuItem.getClientProperty("filterColumn");
                if (this.columnDropDown != null) {
                    this.columnDropDown.setSelectedItem(this.searchColumn);
                }
            } else if (actionEvent.getSource() == this.columnDropDown) {
                Object object = this.columnDropDown.getSelectedItem();
                if (object != null) {
                    this.searchColumn = (String)object;
                }
                if (this.columnItems != null) {
                    for (JCheckBoxMenuItem jCheckBoxMenuItem : this.columnItems) {
                        jCheckBoxMenuItem.setSelected(jCheckBoxMenuItem.getText().equals(this.searchColumn));
                    }
                }
            }
        }
        this.setFilterTooltip();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.searchTable) {
            int n = this.searchTable.getColumnCount();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.searchTable.getColumnName(i);
            }
            this.setColumnList(stringArray);
        } else if (propertyChangeEvent.getPropertyName().equals("workbench.gui.quickfilter.useregex")) {
            this.setFilterTooltip();
        }
    }

    private synchronized void filterByEditorValue(boolean bl) {
        Component component = this.filterValue.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            String string = jTextField.getText();
            this.applyFilter(string, bl);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.ignoreEvents) {
            return;
        }
        if (WbAction.isAltPressed(keyEvent.getModifiers()) || WbAction.isCtrlPressed(keyEvent.getModifiers())) {
            return;
        }
        EventQueue.invokeLater(() -> {
            if (keyEvent.getKeyChar() == '\u001b') {
                this.applyFilter(null, false);
                keyEvent.consume();
            } else if (keyEvent.getKeyChar() == '\n') {
                this.filterByEditorValue(true);
                keyEvent.consume();
            } else if (this.autoFilterEnabled) {
                this.filterByEditorValue(false);
                keyEvent.consume();
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

