/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;

public class StringSelectionAdapter
implements Transferable,
ClipboardOwner {
    private final DataFlavor[] flavors;
    private final String data;
    private final String dataAsHTML;

    public StringSelectionAdapter(String string, boolean bl) {
        this.data = string;
        if (bl) {
            this.flavors = new DataFlavor[]{DataFlavor.fragmentHtmlFlavor, DataFlavor.stringFlavor};
            this.dataAsHTML = this.createHtmlFragment(string);
        } else {
            this.flavors = new DataFlavor[]{DataFlavor.stringFlavor};
            this.dataAsHTML = null;
        }
    }

    private String createHtmlFragment(String string) {
        try {
            String string2 = "table, th, td { border: 1px solid black; border-collapse: collapse; } th, td { padding: 5px; text-align: left; } table tr:nth-child(even) { background-color: #eee; } table tr:nth-child(odd) { background-color:#fff; } table th { background-color: black; color: white; }";
            String string3 = Settings.getInstance().getCssForClipboardHtml(string2);
            String string4 = "<html><head><style>" + string3 + "</style></head><body><table>";
            String string5 = "</table></body></html>";
            String string6 = "<tr>";
            String string7 = "</tr>";
            String string8 = "<td>";
            String string9 = "</td>";
            StringReader stringReader = new StringReader(string);
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            StringBuilder stringBuilder = new StringBuilder(string.length());
            stringBuilder.append(string4);
            String string10 = bufferedReader.readLine();
            while (string10 != null) {
                String[] stringArray = string10.split("\t");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = string8 + stringArray[i] + string9;
                }
                stringBuilder.append(string6);
                for (String string11 : stringArray) {
                    stringBuilder.append(string11);
                }
                stringBuilder.append(string7);
                string10 = bufferedReader.readLine();
            }
            stringBuilder.append(string5);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not create HTML fragment", exception);
            return null;
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : this.flavors) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.equals(DataFlavor.fragmentHtmlFlavor) && this.dataAsHTML != null) {
            return this.dataAsHTML;
        }
        return this.data;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

