/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.CloseIcon;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.lnf.LnFHelper;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;

public class TabButtonComponent
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private final WbTabbedPane pane;
    private final JLabel label;
    private final WbButton closeButton;
    private boolean isJGoodies;

    public TabButtonComponent(String string, WbTabbedPane wbTabbedPane, boolean bl) {
        super(new BorderLayout());
        this.pane = wbTabbedPane;
        this.label = new JLabel(string){

            @Override
            public Color getBackground() {
                return TabButtonComponent.this.getBackground();
            }

            @Override
            public Color getForeground() {
                return TabButtonComponent.this.getForeground();
            }

            @Override
            public Insets getInsets(Insets insets) {
                return WbSwingUtilities.getEmptyInsets();
            }

            @Override
            public Insets getInsets() {
                return WbSwingUtilities.getEmptyInsets();
            }
        };
        this.label.setOpaque(true);
        this.label.setBorder(WbSwingUtilities.EMPTY_BORDER);
        int n = WbSwingUtilities.getFontHeight(this.label);
        BorderLayout borderLayout = (BorderLayout)this.getLayout();
        borderLayout.setHgap(n / 3);
        CloseIcon closeIcon = new CloseIcon(n);
        CloseIcon closeIcon2 = new CloseIcon(n, Color.WHITE, Color.RED);
        CloseIcon closeIcon3 = new CloseIcon(n, Color.WHITE, Color.RED.darker());
        this.closeButton = new WbButton((Icon)closeIcon){

            @Override
            public Color getBackground() {
                return TabButtonComponent.this.getBackground();
            }

            @Override
            public Color getForeground() {
                return TabButtonComponent.this.getForeground();
            }

            @Override
            public Insets getInsets(Insets insets) {
                return WbSwingUtilities.getEmptyInsets();
            }

            @Override
            public Insets getInsets() {
                return WbSwingUtilities.getEmptyInsets();
            }
        };
        this.closeButton.setOpaque(true);
        if (GuiSettings.useFlatTabCloseButton()) {
            this.closeButton.setContentAreaFilled(false);
            this.closeButton.setBorderPainted(false);
            this.closeButton.setRolloverEnabled(true);
            this.closeButton.setIcon(closeIcon);
            this.closeButton.setRolloverIcon(closeIcon2);
            this.closeButton.setPressedIcon(closeIcon3);
        } else {
            this.closeButton.enableBasicRollover();
        }
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(this);
        this.setupComponents();
        if (!bl) {
            this.closeButton.setVisible(bl);
        }
        this.isJGoodies = LnFHelper.isJGoodies();
        this.setOpaque(this.isJGoodies);
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.closebutton.right", new String[0]);
    }

    @Override
    public Insets getInsets() {
        return WbSwingUtilities.getEmptyInsets();
    }

    @Override
    public Insets getInsets(Insets insets) {
        return WbSwingUtilities.getEmptyInsets();
    }

    @Override
    public Color getBackground() {
        if (!this.isJGoodies && super.getBackground() != null) {
            return super.getBackground();
        }
        Color color = null;
        if (this.pane != null) {
            color = this.pane.getTabComponentAt(this.pane.getSelectedIndex()) == this ? UIManager.getColor("TabbedPane.selected") : UIManager.getColor("TabbedPane.unselectedBackground");
        }
        if (color == null) {
            color = UIManager.getColor("TabbedPane.tabAreaBackground");
        }
        if (color == null) {
            color = UIManager.getColor("TabbedPane.background");
        }
        if (color == null) {
            super.getBackground();
        }
        return color;
    }

    @Override
    public Color getForeground() {
        if (!this.isJGoodies && super.getForeground() != null) {
            return super.getForeground();
        }
        Color color = null;
        if (this.pane != null) {
            color = this.pane.getForeground();
        }
        if (color == null) {
            color = UIManager.getColor("TabbedPane.foreground");
        }
        if (color == null) {
            color = super.getForeground();
        }
        return color;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Settings.getInstance().removePropertyChangeListener(this);
    }

    @Override
    public final void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.label != null) {
            this.label.setOpaque(bl);
        }
        if (this.closeButton != null) {
            this.closeButton.setOpaque(bl);
        }
    }

    public void setDisplayedMnemonicIndex(int n) throws IllegalArgumentException {
        this.label.setDisplayedMnemonicIndex(n);
    }

    public void setDisplayedMnemonic(char c) {
        this.label.setDisplayedMnemonic(c);
    }

    public void setDisplayedMnemonic(int n) {
        this.label.setDisplayedMnemonic(n);
    }

    public void setButtonVisible(boolean bl) {
        this.closeButton.setVisible(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.closeButton.setEnabled(bl);
    }

    public void setTitle(String string) {
        this.label.setText(string);
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.pane.indexOfTabComponent(this);
        if (n != -1) {
            this.pane.closeButtonClicked(n);
        }
    }

    private void setupComponents() {
        boolean bl = GuiSettings.getShowCloseButtonOnRightSide();
        this.remove(this.label);
        this.remove(this.closeButton);
        this.add((Component)this.label, "Center");
        if (bl) {
            this.add((Component)this.closeButton, "After");
        } else {
            this.add((Component)this.closeButton, "Before");
        }
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setupComponents();
    }
}

