/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringReader;
import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.MultilineWrapAction;
import workbench.gui.actions.RestoreDataAction;
import workbench.gui.actions.SelectFkValueAction;
import workbench.gui.actions.SetNullAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.CellWindowEdit;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbTable;
import workbench.gui.renderer.WbRenderer;
import workbench.gui.renderer.WrapEnabledEditor;
import workbench.interfaces.NullableEditor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.util.WbDateFormatter;

public class WbCellEditor
extends AbstractCellEditor
implements TableCellEditor,
MouseListener,
NullableEditor,
DocumentListener,
WrapEnabledEditor {
    private TextAreaEditor editor;
    private WbTable parentTable;
    private JScrollPane scroll;
    private Color defaultBackground;
    private boolean isNull;
    private RestoreDataAction restoreValue;
    private SetNullAction setNull;
    private MultilineWrapAction multilineWrapAction;
    private TextComponentMouseListener contextMenu;
    private SelectFkValueAction selectFk;

    public WbCellEditor(WbTable wbTable) {
        this.parentTable = wbTable;
        this.editor = new TextAreaEditor();
        this.defaultBackground = this.editor.getBackground();
        this.setFont(wbTable.getFont());
        this.scroll = new TextAreaScrollPane(this.editor);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.scroll.setHorizontalScrollBarPolicy(31);
        boolean bl = GuiSettings.getWrapMultilineEditor();
        this.editor.setLineWrap(bl);
        this.editor.setWrapStyleWord(bl);
        this.editor.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.scroll.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.restoreValue = new RestoreDataAction(this);
        this.contextMenu = new TextComponentMouseListener(this.editor);
        this.setNull = new SetNullAction(this);
        this.multilineWrapAction = new MultilineWrapAction(this, this.getEditor(), "workbench.gui.display.multiline.editor.wrap");
        this.selectFk = new SelectFkValueAction(wbTable);
        this.selectFk.addToInputMap(this.editor);
        this.contextMenu.addAction(this.setNull);
        this.contextMenu.addAction(this.selectFk);
        this.contextMenu.addAction(this.restoreValue);
        this.contextMenu.addAction(this.multilineWrapAction);
        this.editor.addMouseListener(this);
    }

    public void dispose() {
        WbAction.dispose(this.multilineWrapAction, this.setNull, this.restoreValue);
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
        }
    }

    @Override
    public void setWordwrap(boolean bl) {
        this.editor.setLineWrap(bl);
        this.editor.setWrapStyleWord(bl);
        GuiSettings.setWrapMultilineEditor(bl);
    }

    @Override
    public void restoreOriginal() {
        Object object;
        int n = this.parentTable.getEditingRow();
        int n2 = this.parentTable.getEditingColumn();
        if (n >= 0 && n2 >= 0 && (object = this.parentTable.restoreColumnValue(n, n2)) != null) {
            this.editor.setText(object.toString());
            this.isNull = false;
        }
    }

    @Override
    public void setNull(boolean bl) {
        if (bl) {
            this.editor.setText("");
        }
        this.isNull = bl;
    }

    @Override
    public JTextComponent getEditor() {
        return this.editor;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.parentTable.adjustRowHeight();
    }

    @Override
    public boolean stopCellEditing() {
        boolean bl = super.stopCellEditing();
        this.parentTable.adjustRowHeight();
        return bl;
    }

    public void setText(String string) {
        this.editor.setText(string);
        this.editor.selectAll();
        this.isNull = false;
    }

    public final void setFont(Font font) {
        this.editor.setFont(font);
    }

    public Component getComponent() {
        return this.scroll;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isNull) {
            return null;
        }
        return this.editor.getText();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        boolean bl = true;
        if (eventObject instanceof MouseEvent) {
            boolean bl2 = bl = ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        if (bl) {
            WbSwingUtilities.requestFocus(this.editor);
        }
        return bl;
    }

    private String getRendererDisplay(JTable jTable, int n, int n2) {
        String string = null;
        TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
        if (tableCellRenderer instanceof WbRenderer) {
            WbRenderer wbRenderer = (WbRenderer)((Object)tableCellRenderer);
            string = wbRenderer.getDisplayValue();
        } else if (tableCellRenderer instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)((Object)tableCellRenderer);
            string = jTextComponent.getText();
        } else if (tableCellRenderer instanceof JLabel) {
            string = ((JLabel)((Object)tableCellRenderer)).getText();
        } else if (jTable instanceof WbTable) {
            string = ((WbTable)jTable).getValueAsString(n, n2);
        }
        return string;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string;
        String string2 = string = object == null ? "" : object.toString();
        if (WbDateFormatter.isDateTimeValue(object)) {
            string = this.getRendererDisplay(jTable, n, n2);
        }
        if (GuiSettings.getUseReaderForMultilineRenderer()) {
            StringReader stringReader = new StringReader(string);
            try {
                this.editor.read(stringReader, null);
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not set value using StringReader", throwable);
                this.editor.setText(string);
            }
        } else {
            this.editor.setText(string);
        }
        this.editor.selectAll();
        this.setNull(false);
        this.setEditable(!this.parentTable.isReadOnly());
        this.restoreValue.setEnabled(this.parentTable.getDataStoreTableModel().isColumnModified(n, n2));
        return this.scroll;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && this.parentTable != null) {
            CellWindowEdit cellWindowEdit = new CellWindowEdit(this.parentTable);
            cellWindowEdit.openEditWindow();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setEditable(boolean bl) {
        this.editor.setEditable(bl);
        if (!bl) {
            this.editor.setBackground(this.defaultBackground);
        }
        this.editor.getCaret().setVisible(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setNull(false);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setNull(false);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setNull(false);
    }

    public class TextAreaScrollPane
    extends JScrollPane
    implements NullableEditor {
        TextAreaScrollPane(TextAreaEditor textAreaEditor) {
            super(textAreaEditor);
            this.setFocusCycleRoot(false);
            Set set = Collections.emptySet();
            this.setFocusTraversalKeys(0, set);
        }

        @Override
        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isManagingFocus() {
            return false;
        }

        @Override
        public boolean requestFocus(boolean bl) {
            return WbCellEditor.this.editor.requestFocus(bl);
        }

        @Override
        public void requestFocus() {
            WbCellEditor.this.editor.requestFocus();
        }

        @Override
        public boolean requestFocusInWindow() {
            return WbCellEditor.this.editor.requestFocusInWindow();
        }

        @Override
        public boolean requestFocusInWindow(boolean bl) {
            return WbCellEditor.this.editor.requestFocusInWindow();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return WbCellEditor.this.editor.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        @Override
        public void setNull(boolean bl) {
            WbCellEditor.this.setNull(bl);
        }

        @Override
        public JTextComponent getEditor() {
            return WbCellEditor.this.editor;
        }

        @Override
        public void restoreOriginal() {
            WbCellEditor.this.restoreOriginal();
        }
    }

    private static class TextAreaEditor
    extends JTextArea {
        TextAreaEditor() {
            this.setFocusCycleRoot(false);
            Set set = Collections.emptySet();
            this.setFocusTraversalKeys(0, set);
            Object object = this.getInputMap().get(WbSwingUtilities.TAB);
            this.getInputMap().put(WbSwingUtilities.TAB, "wb-do-nothing-at-all");
            if (object != null) {
                this.getInputMap().put(WbSwingUtilities.CTRL_TAB, object);
            }
            Object object2 = this.getInputMap().get(WbSwingUtilities.ENTER);
            this.getInputMap().put(WbSwingUtilities.ENTER, "wb-stop-editing");
            if (object2 != null) {
                this.getInputMap().put(WbSwingUtilities.CTRL_ENTER, object2);
                this.getInputMap().put(WbSwingUtilities.ALT_ENTER, object2);
            }
        }

        @Override
        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public Insets getMargin() {
            return new Insets(1, 0, 0, 0);
        }

        @Override
        public boolean isManagingFocus() {
            return false;
        }

        @Override
        public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
    }
}

