/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.interfaces.Reloadable;
import workbench.util.CollectionUtil;

public interface DbObjectList
extends Reloadable {
    public TableIdentifier getObjectTable();

    public TableDefinition getCurrentTableDefinition();

    public List<DbObject> getSelectedObjects();

    public List<TableIdentifier> getSelectedTables();

    public WbConnection getConnection();

    public Component getComponent();

    public int getSelectionCount();

    public static class Util {
        public static List<TableIdentifier> getSelectedTableObjects(DbObjectList dbObjectList) {
            if (dbObjectList == null) {
                return Collections.emptyList();
            }
            WbConnection wbConnection = dbObjectList.getConnection();
            if (wbConnection == null) {
                return Collections.emptyList();
            }
            DbMetadata dbMetadata = wbConnection.getMetadata();
            if (dbMetadata == null) {
                return Collections.emptyList();
            }
            List<DbObject> list = dbObjectList.getSelectedObjects();
            if (CollectionUtil.isEmpty(list)) {
                return Collections.emptyList();
            }
            ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(list.size());
            for (DbObject dbObject : list) {
                if (!(dbObject instanceof TableIdentifier) || !dbMetadata.objectTypeCanContainData(dbObject.getObjectType())) continue;
                arrayList.add((TableIdentifier)dbObject);
            }
            return arrayList;
        }
    }
}

