/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.TableDependencySorter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.EditWindow;
import workbench.gui.components.NoSelectionModel;
import workbench.gui.components.WbButton;
import workbench.gui.components.WbStatusLabel;
import workbench.interfaces.ObjectDropper;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.ExceptionUtil;
import workbench.util.WbThread;

public class ObjectDropperUI
extends JPanel
implements RowActionMonitor,
WindowListener {
    private JDialog dialog;
    private boolean cancelled;
    private boolean running;
    private boolean success;
    private ObjectDropper dropper;
    private Thread checkThread;
    private Thread dropThread;
    protected JCheckBox addMissingTables;
    protected JPanel buttonPanel;
    protected JButton cancelButton;
    protected JCheckBox checkBoxCascadeConstraints;
    protected JButton checkFKButton;
    protected JPanel checkPanel;
    protected JButton dropButton;
    protected JScrollPane jScrollPane1;
    protected JSeparator jSeparator1;
    protected JPanel mainPanel;
    protected JList objectList;
    protected JPanel optionPanel;
    protected JButton showScriptButton;
    protected JLabel statusLabel;

    public ObjectDropperUI(ObjectDropper objectDropper) {
        this.dropper = objectDropper;
        this.initComponents();
        if (!this.dropper.supportsFKSorting()) {
            this.checkFKButton.setEnabled(false);
            this.addMissingTables.setEnabled(false);
            this.addMissingTables.setSelected(false);
            this.optionPanel.remove(this.checkPanel);
        }
    }

    private boolean isConnectionBusy() {
        if (this.dropper == null) {
            return false;
        }
        WbConnection wbConnection = this.dropper.getConnection();
        if (wbConnection == null) {
            return false;
        }
        return wbConnection.isBusy();
    }

    private void setConnectionBusy(boolean bl) {
        if (this.dropper == null) {
            return;
        }
        WbConnection wbConnection = this.dropper.getConnection();
        if (wbConnection == null) {
            return;
        }
        wbConnection.setBusy(bl);
    }

    protected void doDrop() {
        if (this.running || this.isConnectionBusy()) {
            return;
        }
        this.success = true;
        try {
            this.setConnectionBusy(true);
            this.running = true;
            this.cancelled = false;
            this.dropper.dropObjects();
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            this.success = false;
            WbSwingUtilities.showErrorMessage(this.dialog, string);
            LogMgr.logError(new CallerInfo(){}, "Error when dropping objects", throwable);
        }
        finally {
            this.running = false;
            this.dropThread = null;
            this.setConnectionBusy(false);
        }
        EventQueue.invokeLater(() -> {
            if (this.cancelled) {
                this.dropButton.setEnabled(true);
            } else {
                this.dialog.setVisible(false);
                this.dialog.dispose();
                this.dialog = null;
            }
        });
    }

    public boolean success() {
        return this.success;
    }

    public boolean dialogWasCancelled() {
        return this.cancelled;
    }

    protected void initDisplay() {
        List<? extends DbObject> list = this.dropper.getObjects();
        int n = list.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = list.get(i).getObjectType() + " " + list.get(i).getObjectNameForDrop(this.dropper.getConnection());
        }
        this.objectList.setListData(stringArray);
        if (!this.dropper.supportsCascade()) {
            this.optionPanel.remove(this.checkBoxCascadeConstraints);
            this.checkBoxCascadeConstraints.setSelected(false);
        }
    }

    protected void showScript() {
        this.dropper.setCascade(this.checkBoxCascadeConstraints.isSelected());
        CharSequence charSequence = this.dropper.getScript();
        EditWindow editWindow = new EditWindow((Dialog)this.dialog, ResourceMgr.getString("TxtWindowTitleGeneratedScript"), charSequence.toString(), "workbench.objectdropper.scriptwindow", true);
        editWindow.setVisible(true);
        editWindow.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDialog(Frame frame) {
        this.initDisplay();
        this.dialog = new JDialog(frame, ResourceMgr.getString("TxtDropObjectsTitle"), true);
        try {
            int n;
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(this);
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
            int n2 = this.dialog.getHeight();
            if ((double)n2 > (double)frame.getHeight() * 0.8) {
                n2 = (int)((double)frame.getHeight() * 0.7);
            }
            if ((n = this.dialog.getWidth()) < 200) {
                n = 200;
            } else if ((double)this.dialog.getWidth() > (double)frame.getWidth() * 0.9) {
                n = (int)((double)frame.getWidth() * 0.7);
            }
            if (n != this.dialog.getWidth() || n2 != this.dialog.getHeight()) {
                this.dialog.setSize(n, n2);
            }
            WbSwingUtilities.center(this.dialog, frame);
            this.cancelled = true;
            this.dialog.setVisible(true);
        }
        finally {
            if (this.dialog != null) {
                this.dialog.dispose();
                this.dialog = null;
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void cancel() {
        if (!this.running) {
            return;
        }
        this.cancelled = true;
        try {
            this.statusLabel.setText(ResourceMgr.getString("MsgCancelling"));
            this.dropper.cancel();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when cancelling drop", exception);
        }
        finally {
            this.statusLabel.setText("");
        }
        if (this.dropThread != null) {
            try {
                this.dropThread.interrupt();
                this.dropThread.join(1500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.objectList = new JList();
        this.optionPanel = new JPanel();
        this.checkPanel = new JPanel();
        this.checkFKButton = new JButton();
        this.addMissingTables = new JCheckBox();
        this.showScriptButton = new JButton();
        this.checkBoxCascadeConstraints = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.buttonPanel = new JPanel();
        this.dropButton = new WbButton();
        this.cancelButton = new WbButton();
        this.statusLabel = new WbStatusLabel();
        this.setLayout(new GridBagLayout());
        this.mainPanel.setLayout(new BorderLayout(0, 2));
        this.objectList.setSelectionMode(0);
        this.objectList.setSelectionModel(new NoSelectionModel());
        this.jScrollPane1.setViewportView(this.objectList);
        this.mainPanel.add((Component)this.jScrollPane1, "Center");
        this.optionPanel.setLayout(new GridBagLayout());
        this.checkPanel.setLayout(new FlowLayout(0, 0, 0));
        this.checkFKButton.setText(ResourceMgr.getString("LblCheckFKDeps"));
        this.checkFKButton.setToolTipText(ResourceMgr.getDescription("LblCheckFKDeps"));
        this.checkFKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectDropperUI.this.checkFKButtonActionPerformed(actionEvent);
            }
        });
        this.checkPanel.add(this.checkFKButton);
        this.addMissingTables.setSelected(true);
        this.addMissingTables.setText(ResourceMgr.getString("LblIncFkTables"));
        this.addMissingTables.setToolTipText(ResourceMgr.getDescription("LblIncFkTables"));
        this.addMissingTables.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.checkPanel.add(this.addMissingTables);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 6, 0);
        this.optionPanel.add((Component)this.checkPanel, gridBagConstraints);
        this.showScriptButton.setText(ResourceMgr.getString("LblShowScript"));
        this.showScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectDropperUI.this.showScriptButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 3, 0);
        this.optionPanel.add((Component)this.showScriptButton, gridBagConstraints);
        this.checkBoxCascadeConstraints.setText(ResourceMgr.getString("LblCascadeConstraints"));
        this.checkBoxCascadeConstraints.setToolTipText(ResourceMgr.getDescription("LblCascadeConstraints"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 3, 0);
        this.optionPanel.add((Component)this.checkBoxCascadeConstraints, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 10, 2);
        this.optionPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.mainPanel.add((Component)this.optionPanel, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.dropButton.setText(ResourceMgr.getString("LblDrop"));
        this.dropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectDropperUI.this.dropButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.dropButton);
        this.cancelButton.setText(ResourceMgr.getString("LblCancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectDropperUI.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.buttonPanel, gridBagConstraints);
        this.statusLabel.setMinimumSize(new Dimension(150, 24));
        this.statusLabel.setPreferredSize(new Dimension(150, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.statusLabel, gridBagConstraints);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        if (this.running) {
            this.cancel();
        } else {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private void dropButtonActionPerformed(ActionEvent actionEvent) {
        if (this.running) {
            return;
        }
        this.dropButton.setEnabled(false);
        this.dropper.setCascade(this.checkBoxCascadeConstraints.isSelected());
        this.dropper.setRowActionMonitor(this);
        this.dropThread = new WbThread("DropThread"){

            @Override
            public void run() {
                ObjectDropperUI.this.doDrop();
            }
        };
        this.dropThread.start();
    }

    private void showScriptButtonActionPerformed(ActionEvent actionEvent) {
        this.showScript();
    }

    private void fkCheckFinished(List<DbObject> list) {
        this.checkThread = null;
        EventQueue.invokeLater(() -> {
            this.statusLabel.setText("");
            this.dropper.setObjects(list);
            this.initDisplay();
            this.dropButton.setEnabled(true);
            this.showScriptButton.setEnabled(true);
            this.cancelButton.setEnabled(true);
            WbSwingUtilities.showDefaultCursor(this.dialog);
        });
    }

    private void checkFKButtonActionPerformed(ActionEvent actionEvent) {
        final WbConnection wbConnection = this.dropper.getConnection();
        if (wbConnection == null || wbConnection.isBusy()) {
            return;
        }
        this.dropButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.showScriptButton.setEnabled(false);
        this.statusLabel.setText(ResourceMgr.getString("MsgFkDeps"));
        WbSwingUtilities.showWaitCursor(this.dialog);
        this.checkThread = new WbThread("FKCheck"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList arrayList = new ArrayList();
                try {
                    wbConnection.setBusy(true);
                    TableDependencySorter tableDependencySorter = new TableDependencySorter(wbConnection);
                    ArrayList<TableIdentifier> arrayList2 = new ArrayList<TableIdentifier>();
                    ArrayList<DbObject> arrayList3 = new ArrayList<DbObject>();
                    for (DbObject dbObject : ObjectDropperUI.this.dropper.getObjects()) {
                        if (dbObject instanceof TableIdentifier && wbConnection.getMetadata().isTableType(dbObject.getObjectType())) {
                            arrayList2.add((TableIdentifier)dbObject);
                            continue;
                        }
                        arrayList3.add(dbObject);
                    }
                    List<TableIdentifier> list = tableDependencySorter.sortForDelete(arrayList2, ObjectDropperUI.this.addMissingTables.isSelected());
                    arrayList.addAll(arrayList3);
                    arrayList.addAll(list);
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error checking FK dependencies", exception);
                    WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
                    arrayList = null;
                }
                finally {
                    wbConnection.setBusy(false);
                    ObjectDropperUI.this.fkCheckFinished(arrayList);
                }
            }
        };
        this.checkThread.start();
    }

    @Override
    public void setMonitorType(int n) {
    }

    @Override
    public int getMonitorType() {
        return 7;
    }

    @Override
    public void saveCurrentType(String string) {
    }

    @Override
    public void restoreType(String string) {
    }

    @Override
    public void setCurrentObject(String string, long l, long l2) {
        String string2 = ResourceMgr.getFormattedString("LblDropping", string);
        this.statusLabel.setText(string2);
    }

    @Override
    public void setCurrentRow(long l, long l2) {
    }

    @Override
    public void jobFinished() {
    }
}

