/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import workbench.WbManager;
import workbench.db.ColumnIdentifier;
import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.DropType;
import workbench.db.GenericObjectDropper;
import workbench.db.IndexDefinition;
import workbench.db.PartitionLister;
import workbench.db.SynonymDDLHandler;
import workbench.db.TableColumnsDatastore;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.db.TriggerReader;
import workbench.db.TriggerReaderFactory;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.db.dependency.DependencyReaderFactory;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.AlterObjectAction;
import workbench.gui.actions.CompileDbObjectAction;
import workbench.gui.actions.CountTableRowsAction;
import workbench.gui.actions.CreateDropScriptAction;
import workbench.gui.actions.CreateDummySqlAction;
import workbench.gui.actions.DeleteTablesAction;
import workbench.gui.actions.DropDbObjectAction;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.SchemaReportAction;
import workbench.gui.actions.ScriptDbObjectAction;
import workbench.gui.actions.SpoolDataAction;
import workbench.gui.actions.ToggleTableSourceAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.FlatButton;
import workbench.gui.components.MultiSelectComboBox;
import workbench.gui.components.QuickFilterPanel;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.DbObjectSourcePanel;
import workbench.gui.dbobjects.DbObjectTable;
import workbench.gui.dbobjects.EditorTabSelectMenu;
import workbench.gui.dbobjects.ExplorerUtils;
import workbench.gui.dbobjects.FkDisplayPanel;
import workbench.gui.dbobjects.IsolationLevelChanger;
import workbench.gui.dbobjects.ObjectDependencyPanel;
import workbench.gui.dbobjects.SummaryLabel;
import workbench.gui.dbobjects.TableChangeValidator;
import workbench.gui.dbobjects.TableDataPanel;
import workbench.gui.dbobjects.TableDefinitionPanel;
import workbench.gui.dbobjects.TableHistoryModel;
import workbench.gui.dbobjects.TableIndexPanel;
import workbench.gui.dbobjects.TableLister;
import workbench.gui.dbobjects.TablePartitionsPanel;
import workbench.gui.dbobjects.TriggerDisplayPanel;
import workbench.gui.dbobjects.VerticaProjectionPanel;
import workbench.gui.dbobjects.objecttree.RowCountDisplay;
import workbench.gui.dbobjects.objecttree.ShowRowCountAction;
import workbench.gui.filter.FilterDefinitionManager;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.settings.PlacementChooser;
import workbench.interfaces.DbExecutionListener;
import workbench.interfaces.ListSelectionControl;
import workbench.interfaces.ObjectDropListener;
import workbench.interfaces.PropertyStorage;
import workbench.interfaces.Reloadable;
import workbench.interfaces.Resettable;
import workbench.interfaces.ShareableDisplay;
import workbench.interfaces.WbSelectionModel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.NamedSortDefinition;
import workbench.storage.SortDefinition;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.LowMemoryException;
import workbench.util.StringUtil;
import workbench.util.WbProperties;
import workbench.util.WbThread;
import workbench.util.WbWorkspace;

public class TableListPanel
extends JPanel
implements ActionListener,
ChangeListener,
ListSelectionListener,
MouseListener,
ShareableDisplay,
PropertyChangeListener,
TableModelListener,
DbObjectList,
ListSelectionControl,
TableLister,
ObjectDropListener,
RowCountDisplay {
    public static final String PROP_DO_SAVE_SORT = "workbench.gui.dbexplorer.tablelist.sort";
    private static final ColumnIdentifier ROW_COUNT_COLUMN = new ColumnIdentifier("ROWCOUNT", 4, 5);
    protected WbConnection dbConnection;
    protected JPanel listPanel;
    protected QuickFilterPanel findPanel;
    protected DbObjectTable tableList;
    protected TableDefinitionPanel tableDefinition;
    protected WbTable indexes;
    protected VerticaProjectionPanel projections;
    protected FkDisplayPanel importedKeys;
    protected FkDisplayPanel exportedKeys;
    protected ReloadAction reloadAction;
    protected TableDataPanel tableData;
    protected ObjectDependencyPanel dependencyPanel;
    protected TablePartitionsPanel partitionsPanel;
    private TableIndexPanel indexPanel;
    private final TriggerDisplayPanel triggers;
    protected DbObjectSourcePanel tableSource;
    private JTabbedPane displayTab;
    private final WbSplitPane splitPane;
    private JComboBox tableTypes;
    private String currentSchema;
    private String currentCatalog;
    private final SpoolDataAction spoolData;
    private CompileDbObjectAction compileAction;
    private CountTableRowsAction rowCountWindowAction;
    private ShowRowCountAction rowCountAction;
    private final AlterObjectAction renameAction;
    private MainWindow parentWindow;
    private TableIdentifier selectedTable;
    private JComboBox tableHistory;
    private boolean shiftDown;
    protected boolean shouldRetrieve;
    protected boolean shouldRetrieveTable;
    protected boolean shouldRetrieveTableSource;
    protected boolean shouldRetrieveTriggers;
    protected boolean shouldRetrieveIndexes;
    protected boolean shouldRetrieveProjections;
    protected boolean shouldRetrieveExportedKeys;
    protected boolean shouldRetrieveImportedKeys;
    protected boolean shouldRetrievePartitions;
    protected boolean shouldRetrieveTableData;
    protected boolean busy;
    protected boolean ignoreStateChanged;
    private EditorTabSelectMenu showDataMenu;
    private final ToggleTableSourceAction toggleTableSource;
    private List<JTable> tableListClients;
    private NamedSortDefinition savedSort;
    protected JDialog infoWindow;
    private final JPanel statusPanel;
    private final FlatButton alterButton;
    private final SummaryLabel summaryStatusBarLabel;
    private String tableTypeToSelect;
    private final ReentrantLock connectionLock = new ReentrantLock();
    private TableChangeValidator validator = new TableChangeValidator();
    private IsolationLevelChanger levelChanger = new IsolationLevelChanger();
    private FilterDefinitionManager filterMgr;
    private final int maxTypeItems = 25;
    private int currentRetrievalPanel = -1;
    private boolean sourceExpanded = false;
    protected Thread panelRetrieveThread;
    private final Object busyLock = new Object();

    public TableListPanel(MainWindow mainWindow) throws Exception {
        this.parentWindow = mainWindow;
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        int n = PlacementChooser.getPlacementLocation();
        this.displayTab = new WbTabbedPane(n);
        this.displayTab.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.displayTab.setName("displaytab");
        if (DbExplorerSettings.getDbExplorerMultiSelectTypes()) {
            this.tableTypes = new MultiSelectComboBox();
            ((MultiSelectComboBox)this.tableTypes).setCloseOnSelect(DbExplorerSettings.getDbExplorerMultiSelectTypesAutoClose());
        } else {
            this.tableTypes = new JComboBox();
        }
        this.tableDefinition = new TableDefinitionPanel();
        this.tableDefinition.setName("tabledefinition");
        this.tableDefinition.addPropertyChangeListener("index", this);
        this.tableDefinition.addPropertyChangeListener("tableDefinition", this);
        Reloadable reloadable = () -> {
            this.shouldRetrieveIndexes = true;
            this.startRetrieveCurrentPanel();
        };
        this.indexes = new WbTable();
        this.indexes.setRendererSetup(RendererSetup.getBaseSetup());
        this.indexes.setName("indexlist");
        this.indexes.setAdjustToColumnLabel(false);
        this.indexes.setSelectOnRightButtonClick(true);
        this.indexPanel = new TableIndexPanel(this.indexes, reloadable);
        Reloadable reloadable2 = () -> {
            this.shouldRetrieveTable = true;
            this.shouldRetrieveIndexes = true;
            this.shouldRetrieveTableSource = true;
            this.startRetrieveCurrentPanel();
        };
        this.tableSource = new DbObjectSourcePanel(mainWindow, reloadable2);
        this.tableSource.allowReformat();
        if (DbExplorerSettings.allowSourceEditing()) {
            this.tableSource.allowEditing(true);
        }
        this.tableData = new TableDataPanel();
        this.importedKeys = new FkDisplayPanel(this, true);
        this.exportedKeys = new FkDisplayPanel(this, false);
        this.triggers = new TriggerDisplayPanel();
        this.listPanel = new JPanel();
        this.tableList = new DbObjectTable(PROP_DO_SAVE_SORT);
        this.tableList.setName("dbtablelist");
        this.tableList.setSelectOnRightButtonClick(true);
        this.tableList.getSelectionModel().addListSelectionListener(this);
        this.tableList.getSelectionModel().setSelectionMode(2);
        this.tableList.setAdjustToColumnLabel(true);
        this.tableList.addTableModelListener(this);
        this.tableList.setSortIgnoreCase(DbExplorerSettings.sortIgnoreCase());
        this.spoolData = new SpoolDataAction(this);
        this.tableList.addPopupAction(this.spoolData, true);
        this.renameAction = new AlterObjectAction(this.tableList);
        this.renameAction.setReloader(this);
        this.renameAction.addPropertyChangeListener(this);
        this.extendPopupMenu();
        if (DbExplorerSettings.enableExtendedObjectFilter()) {
            this.filterMgr = new FilterDefinitionManager();
        }
        this.findPanel = new QuickFilterPanel(this.tableList, false, this.filterMgr, "tablelist");
        Settings.getInstance().addPropertyChangeListener(this, "workbench.dbexplorer.instantfilter", "workbench.dbexplorer.assumewildcards", "workbench.gui.dbobjects.tabletabs", "workbench.dbexplorer.tablelist.history", "workbench.dbexplorer.tablelist.filter.retrieve", "workbench.dbexplorer.allow.source.edit");
        this.reloadAction = new ReloadAction(this);
        this.reloadAction.setUseLabelIconSize(true);
        this.reloadAction.getToolbarButton().setToolTipText(ResourceMgr.getString("TxtRefreshTableList"));
        this.reloadAction.addToInputMap(this.tableList);
        this.configureFindPanel();
        this.findPanel.addToToolbar(this.reloadAction, true, false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.6;
        jPanel2.add((Component)this.tableTypes, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.findPanel, gridBagConstraints);
        this.listPanel.setLayout(new BorderLayout());
        this.listPanel.add((Component)jPanel2, "North");
        this.statusPanel = new JPanel(new BorderLayout());
        this.statusPanel.setBorder(new EmptyBorder(2, 0, 1, 0));
        this.alterButton = new FlatButton(this.renameAction);
        this.alterButton.showMessageOnEnable("MsgApplyDDLHint");
        this.alterButton.setResourceKey("MnuTxtRunAlter");
        this.summaryStatusBarLabel = new SummaryLabel("");
        this.statusPanel.add((Component)this.summaryStatusBarLabel, "Center");
        if (DbExplorerSettings.getDbExplorerShowTableHistory()) {
            this.showTableHistory();
        }
        this.listPanel.add((Component)this.statusPanel, "South");
        this.splitPane = new WbSplitPane(1);
        WbScrollPane wbScrollPane = new WbScrollPane(this.tableList);
        this.listPanel.add((Component)wbScrollPane, "Center");
        this.listPanel.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.splitPane.setLeftComponent(this.listPanel);
        this.splitPane.setRightComponent(this.displayTab);
        this.splitPane.setDividerSize(6);
        this.splitPane.setDividerBorder(WbSwingUtilities.EMPTY_BORDER);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.setDefaultComponent(this.findPanel);
        wbTraversalPolicy.addComponent(this.findPanel);
        wbTraversalPolicy.addComponent(this.tableList);
        wbTraversalPolicy.addComponent(this.tableDefinition);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.setFocusCycleRoot(false);
        this.displayTab.addMouseListener(this);
        this.tableList.addMouseListener(this);
        this.initIndexDropper(reloadable);
        this.toggleTableSource = new ToggleTableSourceAction(this, "MnuTxtToggleDbExpSplit");
        this.splitPane.setOneTouchTooltip(this.toggleTableSource.getTooltipTextWithKeys());
        this.setupActionMap();
        if (DbExplorerSettings.showFocusInDbExplorer()) {
            EventQueue.invokeLater(() -> {
                this.indexes.showFocusBorder();
                this.tableList.showFocusBorder();
            });
        }
        this.projections = new VerticaProjectionPanel();
        this.tableList.setRememberColumnOrder(DbExplorerSettings.getRememberMetaColumnOrder("tablelist"));
        this.tableList.setListSelectionControl(this);
        this.tableList.setReadOnly(!DbExplorerSettings.allowAlterInDbExplorer());
        this.tableList.setAllowEditMode(true);
        this.dependencyPanel = new ObjectDependencyPanel();
        this.showObjectDefinitionPanels(false);
    }

    private boolean getApplyFilterWhileTyping() {
        if (DbExplorerSettings.getUseFilterForRetrieve()) {
            return false;
        }
        return DbExplorerSettings.getFilterDuringTyping();
    }

    private void hideTableHistory() {
        if (this.tableHistory != null) {
            this.disposeTableHistory();
            this.statusPanel.remove(this.tableHistory);
            this.tableHistory = null;
            this.updateStatusPanel();
        }
    }

    private void resetTableHistory() {
        if (this.tableHistory != null) {
            TableHistoryModel tableHistoryModel = (TableHistoryModel)this.tableHistory.getModel();
            tableHistoryModel.removeAllElements();
        }
    }

    private void disposeTableHistory() {
        if (this.tableHistory != null) {
            TableHistoryModel tableHistoryModel = (TableHistoryModel)this.tableHistory.getModel();
            tableHistoryModel.removeAllElements();
            tableHistoryModel.clearListeners();
            this.tableHistory.removeActionListener(this);
        }
    }

    private void showTableHistory() {
        if (this.tableHistory == null) {
            this.tableHistory = new JComboBox();
            this.tableHistory.addActionListener(this);
            this.tableHistory.setModel(new TableHistoryModel());
            this.statusPanel.add((Component)this.tableHistory, "North");
            this.updateStatusPanel();
        }
    }

    private void updateStatusPanel() {
        this.listPanel.invalidate();
        this.listPanel.validate();
    }

    private void initIndexDropper(Reloadable reloadable) {
        DbObjectList dbObjectList = new DbObjectList(){

            @Override
            public void reload() {
                TableListPanel.this.reload();
            }

            @Override
            public Component getComponent() {
                return TableListPanel.this;
            }

            @Override
            public WbConnection getConnection() {
                return TableListPanel.this.dbConnection;
            }

            @Override
            public TableIdentifier getObjectTable() {
                return TableListPanel.this.getObjectTable();
            }

            @Override
            public TableDefinition getCurrentTableDefinition() {
                return TableListPanel.this.getCurrentTableDefinition();
            }

            @Override
            public int getSelectionCount() {
                return TableListPanel.this.indexes.getSelectedRowCount();
            }

            @Override
            public List<TableIdentifier> getSelectedTables() {
                return Collections.emptyList();
            }

            @Override
            public List<DbObject> getSelectedObjects() {
                int[] nArray = TableListPanel.this.indexes.getSelectedRows();
                if (nArray == null) {
                    return null;
                }
                ArrayList<DbObject> arrayList = new ArrayList<DbObject>(nArray.length);
                TableIdentifier tableIdentifier = this.getObjectTable();
                for (int i = 0; i < nArray.length; ++i) {
                    String string = TableListPanel.this.indexes.getValueAsString(nArray[i], 0);
                    IndexDefinition indexDefinition = new IndexDefinition(tableIdentifier, string);
                    arrayList.add(indexDefinition);
                }
                return arrayList;
            }
        };
        DropDbObjectAction dropDbObjectAction = new DropDbObjectAction("MnuTxtDropIndex", dbObjectList, this.indexes.getSelectionModel(), reloadable);
        this.indexes.addPopupAction(dropDbObjectAction, true);
    }

    public boolean isModified() {
        if (this.tableData == null) {
            return false;
        }
        return this.tableData.isModified();
    }

    public void dispose() {
        this.reset();
        this.disposeTableHistory();
        this.tableDefinition.dispose();
        this.tableList.dispose();
        this.tableData.dispose();
        this.tableSource.dispose();
        this.findPanel.dispose();
        this.dependencyPanel.dispose();
        if (this.indexes != null) {
            this.indexes.dispose();
        }
        if (this.indexPanel != null) {
            this.indexPanel.dispose();
        }
        if (this.projections != null) {
            this.projections.dispose();
        }
        if (this.partitionsPanel != null) {
            this.partitionsPanel.dispose();
        }
        WbAction.dispose(this.compileAction, this.rowCountAction, this.rowCountWindowAction, this.reloadAction, this.renameAction, this.spoolData, this.toggleTableSource);
        Settings.getInstance().removePropertyChangeListener(this);
    }

    private void extendPopupMenu() {
        if (DbExplorerSettings.showRowCountsInline()) {
            this.rowCountAction = new ShowRowCountAction(this, this, this.summaryStatusBarLabel);
            this.tableList.addPopupAction(this.rowCountAction, false);
        } else {
            this.rowCountWindowAction = new CountTableRowsAction(this, WbSelectionModel.Factory.createFacade(this.tableList.getSelectionModel()));
            this.tableList.addPopupAction(this.rowCountWindowAction, false);
        }
        if (this.parentWindow != null) {
            this.showDataMenu = new EditorTabSelectMenu(ResourceMgr.getString("MnuTxtShowTableData"), "LblShowDataInNewTab", "LblShowDataInTab", this.parentWindow, true);
            this.showDataMenu.setObjectList(this);
            this.showDataMenu.setEnabled(false);
            this.tableList.addPopupMenu(this.showDataMenu, false);
        }
        this.tableList.addPopupAction(CreateDummySqlAction.createDummyInsertAction((DbObjectList)this, this.tableList.getSelectionModel()), true);
        this.tableList.addPopupAction(CreateDummySqlAction.createDummyUpdateAction((DbObjectList)this, this.tableList.getSelectionModel()), false);
        this.tableList.addPopupAction(CreateDummySqlAction.createDummySelectAction((DbObjectList)this, this.tableList.getSelectionModel()), false);
        WbSelectionModel wbSelectionModel = WbSelectionModel.Factory.createFacade(this.tableList.getSelectionModel());
        ScriptDbObjectAction scriptDbObjectAction = new ScriptDbObjectAction(this, wbSelectionModel);
        this.tableList.addPopupAction(scriptDbObjectAction, false);
        SchemaReportAction schemaReportAction = new SchemaReportAction(this);
        this.tableList.addPopupMenu(schemaReportAction.getMenuItem(), false);
        this.compileAction = new CompileDbObjectAction(this, wbSelectionModel);
        this.tableList.addPopupAction(this.compileAction, false);
        DropDbObjectAction dropDbObjectAction = new DropDbObjectAction(this, wbSelectionModel);
        dropDbObjectAction.addDropListener(this);
        this.tableList.addPopupAction(dropDbObjectAction, true);
        CreateDropScriptAction createDropScriptAction = new CreateDropScriptAction(this, wbSelectionModel);
        this.tableList.addPopupAction(createDropScriptAction, false);
        this.tableList.addPopupAction(new DeleteTablesAction(this, wbSelectionModel, this.tableData), false);
        this.tableList.addPopupAction(this.renameAction, true);
    }

    public void setDbExecutionListener(DbExecutionListener dbExecutionListener) {
        this.tableData.addDbExecutionListener(dbExecutionListener);
    }

    private void setDirty(boolean bl) {
        this.shouldRetrieve = bl;
    }

    private void setupActionMap() {
        ComponentInputMap componentInputMap = new ComponentInputMap(this);
        ActionMap actionMap = new ActionMap();
        this.setInputMap(2, componentInputMap);
        this.setActionMap(actionMap);
        this.toggleTableSource.addToInputMap(componentInputMap, actionMap);
    }

    protected void showTablePanels() {
        if (this.displayTab.indexOfComponent(this.exportedKeys) > -1) {
            return;
        }
        WbSwingUtilities.invoke(() -> {
            try {
                this.ignoreStateChanged = true;
                int n = this.displayTab.getSelectedIndex();
                this.displayTab.removeAll();
                this.addBaseObjectPanels();
                this.addDataPanel();
                if (DBID.Vertica.isDB(this.dbConnection)) {
                    this.displayTab.add(ResourceMgr.getString("TxtDbExplorerProjections"), this.projections);
                } else {
                    this.addIndexPanel();
                }
                this.displayTab.add(ResourceMgr.getString("TxtDbExplorerFkColumns"), this.importedKeys);
                this.displayTab.add(ResourceMgr.getString("TxtDbExplorerReferencedColumns"), this.exportedKeys);
                this.addTriggerPanel();
                this.addDependencyPanelIfSupported();
                this.addPartitionsPanelIfSupported();
                this.restoreIndex(n);
            }
            finally {
                this.ignoreStateChanged = false;
            }
        });
    }

    protected void showOnlySourcePanel() {
        WbSwingUtilities.invoke(() -> {
            try {
                this.ignoreStateChanged = true;
                this.displayTab.removeAll();
                this.addSourcePanel();
                this.displayTab.setSelectedIndex(0);
            }
            finally {
                this.ignoreStateChanged = false;
            }
        });
    }

    private void restoreIndex(int n) {
        if (this.displayTab.getTabCount() == 0) {
            return;
        }
        if (n >= 0 && n < this.displayTab.getTabCount()) {
            this.displayTab.setSelectedIndex(n);
        } else {
            this.displayTab.setSelectedIndex(0);
        }
    }

    private void showObjectDefinitionPanels(boolean bl) {
        int n = this.displayTab.getTabCount();
        WbSwingUtilities.invoke(() -> {
            try {
                int n2 = this.displayTab.getSelectedIndex();
                this.ignoreStateChanged = true;
                this.displayTab.removeAll();
                this.currentRetrievalPanel = -1;
                this.addBaseObjectPanels();
                if (bl) {
                    this.addDataPanel();
                }
                this.showIndexesIfSupported();
                this.showTriggerIfSupported();
                this.addDependencyPanelIfSupported();
                this.addPartitionsPanelIfSupported();
                this.dependencyPanel.reset();
                this.exportedKeys.reset();
                this.indexes.reset();
                this.triggers.reset();
                this.importedKeys.reset();
                this.projections.reset();
                if (!bl) {
                    this.tableData.reset();
                    this.shouldRetrieveTableData = false;
                }
                if (this.displayTab.getTabCount() != n) {
                    this.displayTab.setSelectedIndex(0);
                } else {
                    this.restoreIndex(n2);
                }
            }
            finally {
                this.ignoreStateChanged = false;
            }
        });
    }

    private void addDependencyPanelIfSupported() {
        if (this.dbConnection == null) {
            return;
        }
        DependencyReader dependencyReader = DependencyReaderFactory.getReader(this.dbConnection);
        TableIdentifier tableIdentifier = this.getObjectTable();
        if (tableIdentifier == null) {
            return;
        }
        if (dependencyReader != null && (dependencyReader.supportsIsUsingDependency(tableIdentifier.getType()) || dependencyReader.supportsUsedByDependency(tableIdentifier.getObjectType()))) {
            this.displayTab.add(ResourceMgr.getString("TxtDeps"), this.dependencyPanel);
        }
    }

    private void addPartitionsPanelIfSupported() {
        if (this.dbConnection == null) {
            return;
        }
        PartitionLister partitionLister = PartitionLister.Factory.createReader(this.dbConnection);
        if (partitionLister != null && this.isTable()) {
            TablePartitionsPanel tablePartitionsPanel = this.getPartitionsPanel();
            tablePartitionsPanel.reset();
            tablePartitionsPanel.setCurrentTable(this.selectedTable);
            this.displayTab.add(ResourceMgr.getString("TxtPartitions"), tablePartitionsPanel);
        }
    }

    private synchronized TablePartitionsPanel getPartitionsPanel() {
        if (this.partitionsPanel == null) {
            this.partitionsPanel = new TablePartitionsPanel();
            this.partitionsPanel.setConnection(this.dbConnection);
        }
        return this.partitionsPanel;
    }

    private boolean viewTriggersSupported() {
        TriggerReader triggerReader = TriggerReaderFactory.createReader(this.dbConnection);
        if (triggerReader == null) {
            return false;
        }
        return triggerReader.supportsTriggersOnViews();
    }

    private void showTriggerIfSupported() {
        if (!this.viewTriggersSupported()) {
            return;
        }
        TableIdentifier tableIdentifier = this.getObjectTable();
        if (tableIdentifier == null) {
            return;
        }
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        if (dbSettings.isViewType(tableIdentifier.getType())) {
            this.addTriggerPanel();
        }
    }

    private void showIndexesIfSupported() {
        TableIdentifier tableIdentifier = this.getObjectTable();
        if (tableIdentifier == null) {
            return;
        }
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        if (dbSettings.isViewType(tableIdentifier.getType()) && dbSettings.supportsIndexedViews()) {
            this.addIndexPanel();
        }
        if (dbSettings.isMview(tableIdentifier.getType())) {
            this.addIndexPanel();
        }
    }

    protected void addTriggerPanel() {
        this.displayTab.add(ResourceMgr.getString("TxtDbExplorerTriggers"), this.triggers);
    }

    protected void addIndexPanel() {
        this.displayTab.add(ResourceMgr.getString("TxtDbExplorerIndexes"), this.indexPanel);
    }

    protected void addBaseObjectPanels() {
        TableIdentifier tableIdentifier = this.getObjectTable();
        if (tableIdentifier == null) {
            return;
        }
        if (tableIdentifier != null && this.dbConnection.getMetadata().hasColumns(tableIdentifier)) {
            this.displayTab.add(ResourceMgr.getString("TxtDbExplorerTableDefinition"), this.tableDefinition);
        }
        this.addSourcePanel();
    }

    protected void addSourcePanel() {
        this.displayTab.add(ResourceMgr.getString("TxtDbExplorerSource"), this.tableSource);
    }

    protected void addDataPanel() {
        this.displayTab.add(ResourceMgr.getString("TxtDbExplorerData"), this.tableData);
    }

    public void toggleExpandSource() {
        if (this.sourceExpanded) {
            int n = this.splitPane.getLastDividerLocation();
            this.splitPane.setDividerLocation(n);
        } else {
            int n = this.splitPane.getDividerLocation();
            this.splitPane.setLastDividerLocation(n);
            this.splitPane.setDividerLocation(0);
        }
        this.sourceExpanded = !this.sourceExpanded;
    }

    public void setInitialFocus() {
        this.findPanel.setFocusToEntryField();
    }

    public void disconnect() {
        try {
            this.tableData.storeColumnOrder();
            this.reset();
            this.ignoreStateChanged = true;
            this.dbConnection = null;
            this.tableTypes.removeActionListener(this);
            this.displayTab.removeChangeListener(this);
            this.tableData.setConnection(null);
            this.tableTypes.removeAllItems();
            this.tableDefinition.setConnection(null);
            if (this.partitionsPanel != null) {
                this.partitionsPanel.setConnection(null);
            }
        }
        finally {
            this.ignoreStateChanged = false;
        }
    }

    public void reset() {
        this.selectedTable = null;
        this.invalidateData();
        if (this.isBusy()) {
            return;
        }
        this.tableList.saveColumnOrder();
        WbSwingUtilities.invoke(() -> {
            this.tableList.cancelEditing();
            if (this.displayTab.getTabCount() > 0) {
                try {
                    this.ignoreStateChanged = true;
                    this.displayTab.setSelectedIndex(0);
                }
                finally {
                    this.ignoreStateChanged = false;
                }
            }
            this.tableDefinition.reset();
            this.importedKeys.reset();
            this.exportedKeys.reset();
            if (this.projections != null) {
                this.projections.reset();
            }
            this.indexes.reset();
            this.triggers.reset();
            this.tableSource.reset();
            this.tableData.reset();
            this.tableList.reset();
            if (this.partitionsPanel != null) {
                this.partitionsPanel.reset();
            }
            this.resetTableHistory();
        });
    }

    protected void resetCurrentPanel() {
        WbSwingUtilities.invoke(() -> {
            Resettable resettable = (Resettable)((Object)this.displayTab.getSelectedComponent());
            if (resettable != null) {
                resettable.reset();
            }
        });
    }

    protected void invalidateData() {
        this.shouldRetrieveTable = true;
        this.shouldRetrieveTableData = true;
        if (this.tableData != null) {
            if (this.selectedTable != null) {
                this.tableData.setTable(this.selectedTable);
            } else {
                this.tableData.reset();
            }
        }
        if (this.partitionsPanel != null) {
            this.partitionsPanel.setCurrentTable(this.selectedTable);
        }
        this.shouldRetrieveTableSource = true;
        this.shouldRetrieveTriggers = true;
        this.shouldRetrieveIndexes = true;
        this.shouldRetrieveExportedKeys = true;
        this.shouldRetrieveImportedKeys = true;
        this.shouldRetrieveProjections = true;
        this.shouldRetrievePartitions = true;
    }

    private void setupSingleSelectTypes() {
        Collection<String> collection = this.dbConnection.getMetadata().getObjectTypes();
        collection.remove("EVENT TRIGGER");
        this.tableTypes.removeAllItems();
        this.tableTypes.addItem("*");
        try {
            String string = "";
            for (String string2 : collection) {
                this.tableTypes.addItem(string2);
                if (string2.length() <= string.length()) continue;
                string = string2;
            }
            int n = (int)((double)WbSwingUtilities.calculateCharWidth(this, string.length() * 2) * 1.2);
            int n2 = (int)((double)IconMgr.getInstance().getSizeForLabel() * 1.2);
            Dimension dimension = new Dimension(n, n2);
            this.tableTypes.setMaximumSize(dimension);
            this.tableTypes.setPreferredSize(dimension);
            String string3 = this.dbConnection.getMetadata().getBaseTableTypeName() + "," + this.dbConnection.getMetadata().getViewTypeName();
            String string4 = Settings.getInstance().getProperty("workbench.dbexplorer." + this.dbConnection.getDbId() + ".typefilter.additional", null);
            if (string4 == null) {
                string4 = Settings.getInstance().getProperty("workbench.dbexplorer.typefilter.additional", string3);
            }
            List<String> list = StringUtil.stringToList(string4, ";", true, true);
            for (String string5 : list) {
                List<String> list2 = StringUtil.stringToList(string5, ",");
                list2.retainAll(collection);
                String string6 = StringUtil.listToString(list2, ',');
                if (!StringUtil.isNonBlank(string6) || collection.contains(string6)) continue;
                this.tableTypes.addItem(string6);
            }
            if (this.tableTypeToSelect != null) {
                this.tableTypes.setSelectedItem(this.tableTypeToSelect.toUpperCase());
            } else {
                this.tableTypes.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when setting table types", exception);
        }
    }

    private void setupMultiSelectTypes() {
        MultiSelectComboBox multiSelectComboBox = (MultiSelectComboBox)this.tableTypes;
        ArrayList<String> arrayList = new ArrayList<String>(this.dbConnection.getMetadata().getObjectTypes());
        List<String> list = new ArrayList<String>();
        if (this.tableTypeToSelect != null) {
            if (this.tableTypeToSelect.equals("*")) {
                list.addAll(arrayList);
            } else {
                list = StringUtil.stringToList(this.tableTypeToSelect.toUpperCase(), ",", true, true, false, false);
            }
        }
        multiSelectComboBox.setItems(arrayList, list);
        if (list.isEmpty()) {
            multiSelectComboBox.selectAll();
        }
    }

    private void initVertica() {
        if (this.dbConnection == null) {
            return;
        }
        if (DBID.Vertica.isDB(this.dbConnection)) {
            this.projections.setConnection(this.dbConnection);
        } else if (this.projections != null) {
            this.projections.reset();
            this.displayTab.remove(this.projections);
        }
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.tableTypes.removeActionListener(this);
        this.displayTab.removeChangeListener(this);
        this.importedKeys.setConnection(wbConnection);
        this.exportedKeys.setConnection(wbConnection);
        this.tableData.setConnection(wbConnection);
        this.tableDefinition.setConnection(wbConnection);
        this.triggers.setConnection(wbConnection);
        this.tableSource.setDatabaseConnection(wbConnection);
        this.dependencyPanel.setConnection(wbConnection);
        if (this.partitionsPanel != null) {
            this.partitionsPanel.setConnection(wbConnection);
        }
        this.renameAction.setConnection(this.dbConnection);
        this.validator.setConnection(this.dbConnection);
        this.reset();
        if (this.tableTypes instanceof MultiSelectComboBox) {
            this.setupMultiSelectTypes();
        } else {
            this.setupSingleSelectTypes();
        }
        this.tableTypes.setMaximumRowCount(Math.min(this.tableTypes.getItemCount() + 1, 25));
        this.tableTypes.addActionListener(this);
        this.displayTab.addChangeListener(this);
        this.compileAction.setConnection(wbConnection);
        this.initVertica();
    }

    public boolean isReallyVisible() {
        if (!this.isVisible()) {
            return false;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window == null) {
            return false;
        }
        return window.isVisible();
    }

    public void setCatalogAndSchema(String string, String string2, boolean bl) throws Exception {
        this.currentSchema = string2;
        this.currentCatalog = string;
        this.invalidateData();
        if (this.isBusy()) {
            this.setDirty(bl);
            return;
        }
        this.reset();
        if (!bl) {
            return;
        }
        if (this.dbConnection == null) {
            return;
        }
        if (this.isReallyVisible() || this.isClientVisible()) {
            this.retrieve();
            this.setFocusToTableList();
        } else {
            this.setDirty(true);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.summaryStatusBarLabel.showObjectListInfo(this.tableList.getDataStoreTableModel());
    }

    protected void checkAlterButton() {
        WbSwingUtilities.invoke(() -> {
            if (this.renameAction.isEnabled() && !WbSwingUtilities.containsComponent(this.statusPanel, this.alterButton)) {
                this.statusPanel.add((Component)this.alterButton, "East");
                this.statusPanel.validate();
            } else {
                this.statusPanel.remove(this.alterButton);
            }
        });
    }

    protected void setFocusToTableList() {
        EventQueue.invokeLater(() -> {
            this.listPanel.requestFocus();
            this.tableList.requestFocus();
        });
    }

    private String[] getSelectedTypes() {
        if (this.tableTypes == null) {
            return null;
        }
        String[] stringArray = null;
        if (this.tableTypes instanceof MultiSelectComboBox) {
            MultiSelectComboBox multiSelectComboBox = (MultiSelectComboBox)this.tableTypes;
            List<String> list = multiSelectComboBox.getSelectedItems();
            stringArray = list.toArray(new String[0]);
        } else {
            String string = (String)this.tableTypes.getSelectedItem();
            if (!"*".equals(string)) {
                List<String> list = StringUtil.stringToList(string);
                stringArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    stringArray[i] = list.get(i);
                }
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve() {
        if (this.isBusy()) {
            this.invalidateData();
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        if (this.dbConnection == null) {
            LogMgr.logDebug(callerInfo, "Connection object not accessible", new Exception());
            WbSwingUtilities.showErrorMessageKey(this, "ErrConnectionGone");
            return;
        }
        if (this.dbConnection.getMetadata() == null) {
            LogMgr.logDebug(callerInfo, "Database Metadata object not accessible", new Exception());
            WbSwingUtilities.showErrorMessageKey(this, "ErrConnectionMetaGone");
            return;
        }
        try {
            Object object;
            WbSwingUtilities.showWaitCursor(this);
            this.tableTypes.setEnabled(false);
            this.setFindPanelEnabled(false);
            this.reloadAction.setEnabled(false);
            this.summaryStatusBarLabel.setText(ResourceMgr.getString("MsgRetrieving"));
            NamedSortDefinition namedSortDefinition = this.tableList.getCurrentSort();
            this.reset();
            this.setBusy(true);
            String[] stringArray = this.getSelectedTypes();
            if (!this.dbConnection.isShared()) {
                this.levelChanger.changeIsolationLevel(this.dbConnection);
            }
            DataStore dataStore = null;
            if (DbExplorerSettings.getUseFilterForRetrieve()) {
                object = this.findPanel.getText();
                object = this.dbConnection.getMetadata().adjustObjectnameCase((String)object);
                object = this.dbConnection.getMetadata().removeQuotes((String)object);
                dataStore = this.dbConnection.getMetadata().getObjects(this.currentCatalog, this.currentSchema, (String)object, stringArray);
            } else {
                dataStore = this.dbConnection.getMetadata().getObjects(this.currentCatalog, this.currentSchema, stringArray);
            }
            dataStore.setUseNaturalSort(DbExplorerSettings.useNaturalSort());
            this.dbConnection.getObjectCache().addTableList(dataStore, this.currentSchema);
            this.tableList.setOriginalOrder(dataStore);
            object = new DataStoreTableModel(dataStore);
            ((DataStoreTableModel)object).setSortIgnoreCase(DbExplorerSettings.sortIgnoreCase());
            if (this.savedSort != null) {
                ((DataStoreTableModel)object).setSortDefinition(this.savedSort);
                this.savedSort = null;
            } else if (namedSortDefinition != null) {
                ((DataStoreTableModel)object).setSortDefinition(namedSortDefinition);
            } else {
                SortDefinition sortDefinition = SortDefinition.getTableListSort();
                sortDefinition.setUseNaturalSort(DbExplorerSettings.useNaturalSort());
                sortDefinition.setIgnoreCase(DbExplorerSettings.sortIgnoreCase());
                ((DataStoreTableModel)object).setSortDefinition(sortDefinition);
            }
            ((DataStoreTableModel)object).setValidator(this.validator);
            int n = ((DataStoreTableModel)object).findColumn("REMARKS");
            WbSwingUtilities.invoke(() -> this.lambda$retrieve$10((DataStoreTableModel)object, n));
            this.setDirty(false);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setBusy(false);
            this.reset();
            this.setDirty(true);
            WbManager.getInstance().showOutOfMemoryError();
        }
        catch (LowMemoryException lowMemoryException) {
            this.setBusy(false);
            this.reset();
            this.setDirty(true);
            WbManager.getInstance().showLowMemoryError();
        }
        catch (NullPointerException nullPointerException) {
            LogMgr.logError(callerInfo, "Error retrieving table list", nullPointerException);
        }
        catch (Throwable throwable) {
            if (throwable instanceof SQLException) {
                LogMgr.logError(callerInfo, "Error retrieving table list", (SQLException)throwable);
            } else {
                LogMgr.logError(callerInfo, "Error retrieving table list", throwable);
            }
            String string = ExceptionUtil.getDisplay(throwable);
            this.invalidateData();
            this.setDirty(true);
            WbSwingUtilities.showErrorMessage(this, string);
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
            this.setBusy(false);
            this.tableTypes.setEnabled(true);
            this.levelChanger.restoreIsolationLevel(this.dbConnection);
            this.setFindPanelEnabled(true);
            this.reloadAction.setEnabled(true);
            this.endTransaction();
        }
    }

    private void setFindPanelEnabled(boolean bl) {
        this.findPanel.setEnabled(bl);
        if (bl && DbExplorerSettings.getUseFilterForRetrieve()) {
            this.findPanel.setActionsEnabled(false);
        }
    }

    protected void startRetrieve(final boolean bl) {
        if (this.dbConnection == null) {
            LogMgr.logDebug(new CallerInfo(){}, "startRetrieve() called, but no connection available", new Exception());
            return;
        }
        WbThread wbThread = new WbThread("TableListPanel retrieve() thread"){

            @Override
            public void run() {
                TableListPanel.this.retrieve();
                if (bl) {
                    TableListPanel.this.setFocusToTableList();
                }
            }
        };
        wbThread.start();
    }

    public void panelSelected() {
        if (this.shouldRetrieve) {
            this.startRetrieve(true);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.shouldRetrieve) {
            this.startRetrieve(false);
        }
    }

    private String getWorkspacePrefix(int n) {
        return "dbexplorer" + n + ".tablelist.";
    }

    public void saveSettings() {
        this.triggers.saveSettings();
        this.tableData.saveSettings();
        this.tableDefinition.saveSettings();
        String string = this.getClass().getName() + ".";
        this.storeSettings(Settings.getInstance(), string);
        this.findPanel.saveSettings(Settings.getInstance(), "workbench.quickfilter.");
    }

    public void restoreSettings() {
        String string = this.getClass().getName() + ".";
        this.readSettings(Settings.getInstance(), string);
        this.findPanel.restoreSettings(Settings.getInstance(), "workbench.quickfilter.");
        this.triggers.restoreSettings();
        this.tableData.restoreSettings();
        this.tableDefinition.restoreSettings();
        this.projections.restoreSettings();
    }

    public void saveToWorkspace(WbWorkspace wbWorkspace, int n) {
        this.tableData.saveToWorkspace(wbWorkspace, n);
        this.projections.saveToWorkspace(wbWorkspace, n);
        WbProperties wbProperties = wbWorkspace.getSettings();
        String string = this.getWorkspacePrefix(n);
        this.storeSettings(wbProperties, string);
        this.findPanel.saveSettings(wbProperties, "workbench.quickfilter.");
    }

    public void readFromWorkspace(WbWorkspace wbWorkspace, int n) {
        this.restoreSettings();
        this.tableData.readFromWorkspace(wbWorkspace, n);
        this.projections.readFromWorkspace(wbWorkspace, n);
        WbProperties wbProperties = wbWorkspace.getSettings();
        String string = this.getWorkspacePrefix(n);
        this.readSettings(wbProperties, string);
        this.findPanel.restoreSettings(wbProperties, "workbench.quickfilter.");
    }

    private void storeSettings(PropertyStorage propertyStorage, String string) {
        try {
            Object object;
            String string2 = this.tableTypes != null && this.tableTypes.getModel().getSize() > 0 ? StringUtil.arrayToString(this.getSelectedTypes()) : this.tableTypeToSelect;
            if (string2 != null) {
                propertyStorage.setProperty(string + "objecttype", string2);
            }
            propertyStorage.setProperty(string + "divider", Integer.toString(this.splitPane.getDividerLocation()));
            propertyStorage.setProperty(string + "exportedtreedivider", Integer.toString(this.exportedKeys.getDividerLocation()));
            propertyStorage.setProperty(string + "importedtreedivider", Integer.toString(this.importedKeys.getDividerLocation()));
            propertyStorage.setProperty(string + "exportedtree.retrieveall", Boolean.toString(this.exportedKeys.getRetrieveAll()));
            propertyStorage.setProperty(string + "importedtree.retrieveall", Boolean.toString(this.importedKeys.getRetrieveAll()));
            if (Settings.getInstance().getBoolProperty(PROP_DO_SAVE_SORT, false)) {
                object = this.tableList.getCurrentSort();
                if (object == null) {
                    object = this.savedSort;
                }
                String string3 = null;
                if (object != null) {
                    string3 = ((NamedSortDefinition)object).getDefinitionString();
                }
                propertyStorage.setProperty(string + "tablelist.sort", string3);
            }
            if ((object = this.tableList.saveColumnOrder()) != null) {
                propertyStorage.setProperty(string + "columnorder", StringUtil.listToString((Collection)object, ','));
            }
            if (this.filterMgr != null) {
                this.filterMgr.saveSettings(propertyStorage, string);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error storing settings", throwable);
        }
    }

    private void readSettings(PropertyStorage propertyStorage, String string) {
        String string2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)(dimension.getWidth() - 50.0);
        int n2 = propertyStorage.getIntProperty(string + "divider", -1);
        if (n2 != -1) {
            if (n2 == 0 || n2 > n) {
                n2 = 200;
            }
            this.splitPane.setDividerLocation(n2);
        }
        if ((n2 = propertyStorage.getIntProperty(string + "exportedtreedivider", -1)) != -1) {
            if (n2 == 0 || n2 > n) {
                n2 = 200;
            }
            this.exportedKeys.setDividerLocation(n2);
        }
        if ((n2 = propertyStorage.getIntProperty(string + "importedtreedivider", -1)) != -1) {
            if (n2 == 0 || n2 > n) {
                n2 = 200;
            }
            this.importedKeys.setDividerLocation(n2);
        }
        this.importedKeys.setRetrieveAll(propertyStorage.getBoolProperty(string + "importedtree.retrieveall", true));
        this.exportedKeys.setRetrieveAll(propertyStorage.getBoolProperty(string + "exportedtree.retrieveall", true));
        String string3 = DbExplorerSettings.getDefaultExplorerObjectType();
        this.tableTypeToSelect = DbExplorerSettings.getStoreExplorerObjectType() ? propertyStorage.getProperty(string + "objecttype", string3) : string3;
        String string4 = propertyStorage.getProperty(string + "columnorder", null);
        if (StringUtil.isNonEmpty(string4)) {
            this.tableList.setNewColumnOrder(StringUtil.stringToList(string4, ","));
        }
        if (StringUtil.isNonBlank(string2 = propertyStorage.getProperty(string + "tablelist.sort", null))) {
            this.savedSort = NamedSortDefinition.parseDefinitionString(string2);
            if (this.savedSort != null) {
                this.savedSort.setUseNaturalSort(DbExplorerSettings.useNaturalSort());
                this.savedSort.setIgnoreCase(DbExplorerSettings.sortIgnoreCase());
            }
        }
        if (this.filterMgr != null) {
            this.filterMgr.loadSettings(propertyStorage, string);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.tableList.getSelectionModel()) {
            if (this.showDataMenu != null) {
                this.showDataMenu.setEnabled(this.tableList.getSelectedRowCount() == 1);
            }
            if (this.rowCountAction != null) {
                this.rowCountAction.setEnabled(this.tableList.getSelectedRowCount() > 0);
            } else if (this.rowCountWindowAction != null) {
                this.rowCountAction.setEnabled(this.tableList.getSelectedRowCount() > 0);
            }
            try {
                WbSwingUtilities.showWaitCursor(this);
                this.updateDisplay();
            }
            finally {
                WbSwingUtilities.showDefaultCursor(this);
            }
        }
    }

    @Override
    public boolean canChangeSelection() {
        if (this.isBusy()) {
            return false;
        }
        if (this.tableData == null) {
            return true;
        }
        if (GuiSettings.getConfirmDiscardResultSetChanges() && this.isModified()) {
            if (!WbSwingUtilities.getProceedCancel(this, "MsgDiscardDataChanges", new Object[0])) {
                return false;
            }
            this.tableList.getSelectionModel().setValueIsAdjusting(false);
        }
        return true;
    }

    private DbObject getSelectedUserObject() {
        Object object;
        int n = this.tableList.getSelectedRowCount();
        int n2 = this.tableList.getSelectedRow();
        if (n == 1 && n2 > -1 && (object = this.tableList.getDataStore().getRow(n2).getUserObject()) instanceof DbObject) {
            return (DbObject)object;
        }
        return null;
    }

    private void updateSelectedTable() {
        int n = this.tableList.getSelectedRowCount();
        int n2 = this.tableList.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        if (n == 1 && n2 > -1) {
            this.selectedTable = this.createTableIdentifier(n2);
        }
    }

    private boolean isScriptOnlyObject() {
        if (this.dbConnection == null) {
            return false;
        }
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        if (dbSettings == null) {
            return false;
        }
        if (this.selectedTable == null) {
            return false;
        }
        String string = this.selectedTable.getType();
        return dbSettings.getScriptOnlyObjects().contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisplay() {
        int n = this.tableList.getSelectedRowCount();
        this.spoolData.setEnabled(n > 0);
        if (n > 1) {
            return;
        }
        int n2 = this.tableList.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        this.updateSelectedTable();
        this.invalidateData();
        boolean bl = this.isTable();
        boolean bl2 = bl || this.canContainData();
        boolean bl3 = this.isScriptOnlyObject();
        if (bl) {
            this.showTablePanels();
        } else if (bl3) {
            this.showOnlySourcePanel();
        } else {
            this.showObjectDefinitionPanels(bl2);
        }
        if (!bl3) {
            this.tableData.reset();
            this.tableData.setTable(this.selectedTable);
            this.dependencyPanel.reset();
            this.dependencyPanel.setCurrentObject(this.selectedTable);
        }
        if (this.tableHistory != null) {
            TableHistoryModel tableHistoryModel = (TableHistoryModel)this.tableHistory.getModel();
            try {
                this.ignoreStateChanged = true;
                tableHistoryModel.addTable(this.selectedTable);
            }
            finally {
                this.ignoreStateChanged = false;
            }
        }
        this.setShowDataMenuStatus(bl2);
        this.startRetrieveCurrentPanel();
    }

    private void setShowDataMenuStatus(boolean bl) {
        if (this.showDataMenu != null) {
            this.showDataMenu.setEnabled(bl);
        }
    }

    private boolean isSynonym(TableIdentifier tableIdentifier) {
        DbSettings dbSettings;
        if (tableIdentifier == null) {
            return false;
        }
        DbMetadata dbMetadata = this.dbConnection != null ? this.dbConnection.getMetadata() : null;
        DbSettings dbSettings2 = dbSettings = this.dbConnection != null ? this.dbConnection.getDbSettings() : null;
        if (dbMetadata == null || dbSettings == null) {
            return false;
        }
        return dbMetadata.supportsSynonyms() && dbSettings.isSynonymType(tableIdentifier.getType());
    }

    private boolean isTable() {
        TableIdentifier tableIdentifier;
        DbSettings dbSettings;
        if (this.selectedTable == null) {
            return false;
        }
        if (this.dbConnection == null) {
            return false;
        }
        DbMetadata dbMetadata = this.dbConnection != null ? this.dbConnection.getMetadata() : null;
        DbSettings dbSettings2 = dbSettings = this.dbConnection != null ? this.dbConnection.getDbSettings() : null;
        if (dbMetadata == null || dbSettings == null) {
            return false;
        }
        String string = this.selectedTable.getType();
        if (dbMetadata.isExtendedTableType(string)) {
            return true;
        }
        if (GuiSettings.showSynonymTargetInDbExplorer() && dbMetadata.supportsSynonyms() && dbSettings.isSynonymType(string) && (tableIdentifier = this.getObjectTable()) != null) {
            return dbMetadata.isTableType(tableIdentifier.getType());
        }
        LogMgr.logDebug(new CallerInfo(){}, "Object " + this.selectedTable.getTableExpression() + ", type=[" + this.selectedTable.getType() + "] is not considered a table");
        return false;
    }

    private boolean canContainData() {
        boolean bl;
        DbSettings dbSettings;
        if (this.selectedTable == null) {
            return false;
        }
        String string = this.selectedTable.getType();
        DbMetadata dbMetadata = this.dbConnection != null ? this.dbConnection.getMetadata() : null;
        DbSettings dbSettings2 = dbSettings = this.dbConnection != null ? this.dbConnection.getDbSettings() : null;
        if (dbMetadata == null || dbSettings == null) {
            return false;
        }
        if (GuiSettings.showSynonymTargetInDbExplorer() && dbMetadata.supportsSynonyms() && dbSettings.isSynonymType(string)) {
            TableIdentifier tableIdentifier = this.getObjectTable();
            if (tableIdentifier == null) {
                return false;
            }
            string = tableIdentifier.getType();
        }
        boolean bl2 = bl = dbMetadata.objectTypeCanContainData(string) || dbMetadata.isExtendedTableType(string);
        if (!bl) {
            LogMgr.logDebug(new CallerInfo(){}, "Object " + this.selectedTable.getTableExpression() + ", type=[" + this.selectedTable.getType() + "] is not considered to contain selectable data");
        }
        return bl;
    }

    private String getDropForCurrentObject(DropType dropType) {
        DbObject dbObject = this.getSelectedUserObject();
        GenericObjectDropper genericObjectDropper = new GenericObjectDropper();
        genericObjectDropper.setConnection(this.dbConnection);
        String string = genericObjectDropper.getDropForObject(dbObject == null ? this.selectedTable : dbObject, dropType == DropType.cascaded).toString();
        if (string.length() > 0) {
            string = string + "\n\n";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveTableSource() {
        if (this.selectedTable == null) {
            return;
        }
        if (this.dbConnection == null) {
            return;
        }
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        if (dbMetadata == null) {
            return;
        }
        if (dbSettings == null) {
            return;
        }
        this.tableSource.setPlainText(ResourceMgr.getString("TxtRetrievingSourceCode"));
        this.tableSource.setEnabled(false);
        TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(this.dbConnection);
        try {
            Object object;
            this.setActivePanelIndex(this.tableSource);
            WbSwingUtilities.showWaitCursor(this);
            WbSwingUtilities.showWaitCursor(this.tableSource);
            String string = this.selectedTable.getType();
            CharSequence charSequence = null;
            DropType dropType = DbExplorerSettings.getDropTypeToGenerate(string);
            if (dbMetadata.isExtendedObject(this.selectedTable)) {
                object = "";
                if (dropType != DropType.none) {
                    object = this.getDropForCurrentObject(dropType);
                }
                CharSequence charSequence2 = null;
                DbObject dbObject = this.getSelectedUserObject();
                if (dbObject != null) {
                    charSequence2 = dbObject.getSource(this.dbConnection);
                }
                charSequence = StringUtil.isNonEmpty(charSequence2) ? (String)object + charSequence2 : (String)object + dbMetadata.getObjectSource(this.selectedTable);
            } else if (dbSettings.isViewType(string)) {
                if (this.shouldRetrieveTable) {
                    this.retrieveTableDefinition();
                }
                object = new TableDefinition(this.selectedTable, TableColumnsDatastore.createColumnIdentifiers(dbMetadata, this.tableDefinition.getDataStore()));
                charSequence = dbMetadata.getViewReader().getExtendedViewSource((TableDefinition)object, dropType, false);
            } else if (dbSettings.isSynonymType(string)) {
                object = new SynonymDDLHandler();
                charSequence = ((SynonymDDLHandler)object).getSynonymSource(this.dbConnection, this.selectedTable, GuiSettings.showSynonymTargetInDbExplorer(), dropType);
            } else if (dbMetadata.isSequenceType(string)) {
                CharSequence charSequence3;
                object = dbMetadata.getSequenceReader();
                String string2 = "";
                if (dropType != DropType.none) {
                    string2 = this.getDropForCurrentObject(dropType);
                }
                charSequence = StringUtil.isEmptyString(charSequence3 = object.getSequenceSource(this.selectedTable.getCatalog(), this.selectedTable.getSchema(), this.selectedTable.getTableName())) ? ResourceMgr.getString("MsgSequenceSourceNotImplemented") + " " + dbMetadata.getProductName() : charSequence3.toString();
                charSequence = string2 + charSequence;
            } else if (dbMetadata.isExtendedTableType(string)) {
                charSequence = tableSourceBuilder.getTableSource(this.selectedTable, dropType, true, dbSettings.getGenerateTableGrants());
            }
            if (charSequence != null && this.dbConnection.generateCommitForDDL()) {
                charSequence = charSequence.toString() + "\nCOMMIT;\n";
            }
            object = charSequence == null ? "" : charSequence.toString();
            WbSwingUtilities.invokeLater(() -> this.lambda$retrieveTableSource$11((String)object));
            this.shouldRetrieveTableSource = false;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving table source", exception);
            String string = ExceptionUtil.getDisplay(exception);
            EventQueue.invokeLater(() -> this.tableSource.setPlainText(string));
        }
        finally {
            this.setActivePanelIndex(null);
            this.tableSource.setEnabled(true);
            WbSwingUtilities.showDefaultCursor(this.tableSource);
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    private void retrieveTableDefinition() throws SQLException {
        int n = this.currentRetrievalPanel;
        try {
            this.setActivePanelIndex(this.tableDefinition);
            if (this.selectedTable == null) {
                LogMgr.logDebug(new CallerInfo(){}, "No current table available!", new Exception("TraceBack"));
                this.updateSelectedTable();
            }
            if (this.selectedTable == null) {
                LogMgr.logWarning(new CallerInfo(){}, "No table selected!");
                return;
            }
            WbSwingUtilities.showWaitCursor(this);
            this.tableDefinition.retrieve(this.selectedTable);
            this.shouldRetrieveTable = false;
        }
        catch (SQLException sQLException) {
            this.shouldRetrieveTable = true;
            throw sQLException;
        }
        finally {
            this.currentRetrievalPanel = n;
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    protected void startRetrieveCurrentPanel() {
        if (this.isBusy()) {
            LogMgr.logWarning(new CallerInfo(){}, "Start retrieve called while connection was busy");
            return;
        }
        this.panelRetrieveThread = new WbThread("TableListPanel RetrievePanel"){

            @Override
            public void run() {
                try {
                    TableListPanel.this.retrieveCurrentPanel();
                }
                finally {
                    TableListPanel.this.panelRetrieveThread = null;
                }
            }
        };
        this.panelRetrieveThread.start();
    }

    private void setActivePanelIndex(JPanel jPanel) {
        this.currentRetrievalPanel = jPanel == null ? -1 : this.displayTab.indexOfComponent(jPanel);
    }

    protected void retrieveCurrentPanel() {
        if (this.dbConnection == null) {
            return;
        }
        if (this.isBusy() || this.dbConnection.isBusy()) {
            this.invalidateData();
            this.resetCurrentPanel();
            return;
        }
        if (this.tableList.getSelectedRowCount() <= 0) {
            return;
        }
        int n = this.displayTab.getSelectedIndex();
        this.setBusy(true);
        if (!this.connectionLock.tryLock()) {
            LogMgr.logWarning(new CallerInfo(){}, "Concurrent table list retrieval in process", new Exception("Backtrace"));
            this.invalidateData();
            return;
        }
        try {
            if (!this.dbConnection.isShared()) {
                this.levelChanger.changeIsolationLevel(this.dbConnection);
            }
            this.retrieveSelectedPanel();
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving panel " + n, throwable);
        }
        finally {
            this.connectionLock.unlock();
            WbSwingUtilities.showDefaultCursor(this);
            this.setBusy(false);
            this.repaint();
            this.levelChanger.restoreIsolationLevel(this.dbConnection);
            this.endTransaction();
        }
    }

    private void retrieveSelectedPanel() throws SQLException {
        Component component = this.displayTab.getSelectedComponent();
        if (component == this.tableDefinition && this.shouldRetrieveTable) {
            this.retrieveTableDefinition();
        }
        if (component == this.tableSource && this.shouldRetrieveTableSource) {
            this.retrieveTableSource();
        }
        if (component == this.tableData && this.shouldRetrieveTableData) {
            this.tableData.showData(!this.shiftDown);
            this.shouldRetrieveTableData = false;
        }
        if (component == this.indexPanel && this.shouldRetrieveIndexes) {
            this.retrieveIndexes();
        } else if (component == this.projections && this.shouldRetrieveProjections) {
            this.retrieveProjections();
        } else if (component == this.importedKeys && this.shouldRetrieveImportedKeys) {
            this.retrieveImportedTables();
        } else if (component == this.exportedKeys && this.shouldRetrieveExportedKeys) {
            this.retrieveExportedTables();
        } else if (component == this.triggers && this.shouldRetrieveTriggers) {
            this.retrieveTriggers();
        } else if (component == this.dependencyPanel && this.shouldRetrieveTriggers) {
            this.dependencyPanel.doLoad();
        } else if (component == this.partitionsPanel && this.shouldRetrievePartitions) {
            this.partitionsPanel.doLoad();
        }
    }

    private void endTransaction() {
        ExplorerUtils.endTransaction(this.dbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        if (this.dbConnection == null) {
            return false;
        }
        Object object = this.busyLock;
        synchronized (object) {
            if (this.busy) {
                return true;
            }
            return this.dbConnection != null && this.dbConnection.isBusy();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBusy(boolean bl) {
        Object object = this.busyLock;
        synchronized (object) {
            this.busy = bl;
            if (this.dbConnection != null) {
                this.dbConnection.setBusy(bl);
            }
        }
    }

    @Override
    public TableIdentifier getObjectTable() {
        if (this.selectedTable == null) {
            return null;
        }
        if (!this.isSynonym(this.selectedTable)) {
            return this.selectedTable;
        }
        if (this.selectedTable.getRealTable() == null) {
            TableIdentifier tableIdentifier = this.dbConnection.getMetadata().resolveSynonym(this.selectedTable);
            this.selectedTable.setRealTable(tableIdentifier);
        }
        return this.selectedTable.getRealTable();
    }

    protected void retrieveTriggers() throws SQLException {
        try {
            this.setActivePanelIndex(this.triggers);
            WbSwingUtilities.showDefaultCursor(this);
            this.triggers.readTriggers(this.getObjectTable());
            this.shouldRetrieveTriggers = false;
        }
        catch (Throwable throwable) {
            this.shouldRetrieveTriggers = true;
            LogMgr.logError(new CallerInfo(){}, "Error retrieving triggers", throwable);
            WbSwingUtilities.showErrorMessage(this, ExceptionUtil.getDisplay(throwable));
        }
        finally {
            this.setActivePanelIndex(null);
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveIndexes() throws SQLException {
        try {
            this.setActivePanelIndex(this.indexPanel);
            WbSwingUtilities.showWaitCursor(this);
            DbMetadata dbMetadata = this.dbConnection.getMetadata();
            DataStore dataStore = dbMetadata.getIndexReader().getTableIndexInformation(this.getObjectTable());
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
            WbSwingUtilities.invoke(() -> {
                this.indexes.setModel(dataStoreTableModel, true);
                this.indexes.adjustRowsAndColumns();
            });
            this.shouldRetrieveIndexes = false;
        }
        catch (Throwable throwable) {
            this.shouldRetrieveIndexes = true;
            LogMgr.logError(new CallerInfo(){}, "Error retrieving indexes", throwable);
            WbSwingUtilities.showErrorMessage(this, ExceptionUtil.getDisplay(throwable));
        }
        finally {
            this.setActivePanelIndex(null);
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    protected void retrieveExportedTables() throws SQLException {
        try {
            this.setActivePanelIndex(this.exportedKeys);
            WbSwingUtilities.showWaitCursor(this);
            this.exportedKeys.retrieve(this.getObjectTable());
            this.shouldRetrieveExportedKeys = false;
        }
        catch (Throwable throwable) {
            this.shouldRetrieveExportedKeys = true;
            LogMgr.logError(new CallerInfo(){}, "Error retrieving table references", throwable);
            WbSwingUtilities.showErrorMessage(this, ExceptionUtil.getDisplay(throwable));
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
            this.setActivePanelIndex(null);
        }
    }

    protected void retrieveImportedTables() throws SQLException {
        try {
            this.setActivePanelIndex(this.importedKeys);
            WbSwingUtilities.showWaitCursor(this);
            this.importedKeys.retrieve(this.getObjectTable());
            this.shouldRetrieveImportedKeys = false;
        }
        catch (Throwable throwable) {
            this.shouldRetrieveImportedKeys = true;
            LogMgr.logError(new CallerInfo(){}, "Error retrieving table references", throwable);
            WbSwingUtilities.showErrorMessage(this, ExceptionUtil.getDisplay(throwable));
        }
        finally {
            this.setActivePanelIndex(null);
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    protected void retrieveProjections() throws SQLException {
        try {
            this.setActivePanelIndex(this.projections);
            WbSwingUtilities.showWaitCursor(this);
            this.projections.retrieve(this.getObjectTable());
            this.shouldRetrieveProjections = false;
        }
        catch (Throwable throwable) {
            this.shouldRetrieveProjections = true;
            LogMgr.logError(new CallerInfo(){}, "Error retrieving projections", throwable);
            WbSwingUtilities.showErrorMessage(this, ExceptionUtil.getDisplay(throwable));
        }
        finally {
            this.setActivePanelIndex(null);
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    @Override
    public void reload() {
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        this.startRetrieve(false);
    }

    @Override
    public int getSelectionCount() {
        return this.tableList.getSelectedRowCount();
    }

    @Override
    public TableDefinition getCurrentTableDefinition() {
        if (this.selectedTable == null) {
            return null;
        }
        if (this.shouldRetrieveTable || this.tableDefinition.getRowCount() == 0) {
            try {
                this.retrieveTableDefinition();
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving table definition", exception);
                String string = ExceptionUtil.getDisplay(exception);
                WbSwingUtilities.showErrorMessage(this, string);
                return null;
            }
        }
        List<ColumnIdentifier> list = this.tableDefinition.getColumns();
        return new TableDefinition(this.selectedTable, list);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TableIdentifier tableIdentifier;
        if (this.ignoreStateChanged) {
            return;
        }
        if (actionEvent.getSource() == this.tableTypes && !this.isBusy()) {
            try {
                this.showObjectDefinitionPanels(false);
                this.startRetrieve(true);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error while retrieving", exception);
            }
        } else if (actionEvent.getSource() == this.tableHistory && (tableIdentifier = (TableIdentifier)this.tableHistory.getSelectedItem()) != null) {
            this.selectTable(tableIdentifier);
        }
    }

    private boolean isClientVisible() {
        if (this.tableListClients == null) {
            return false;
        }
        for (JTable jTable : this.tableListClients) {
            if (!jTable.isVisible()) continue;
            return true;
        }
        return false;
    }

    protected void updateDisplayClients() {
        if (this.tableListClients == null) {
            return;
        }
        TableModel tableModel = this.tableList.getModel();
        for (JTable jTable : this.tableListClients) {
            if (jTable == null || tableModel == null) continue;
            jTable.setModel(tableModel);
            if (jTable instanceof WbTable) {
                WbTable wbTable = (WbTable)jTable;
                wbTable.adjustRowsAndColumns();
            }
            jTable.repaint();
        }
    }

    @Override
    public void objectsDropped(List<DbObject> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        this.tableList.resetFilter();
        DataStore dataStore = this.tableList.getDataStore();
        int n = dataStore.getRowCount();
        for (int i = n - 1; i >= 0; --i) {
            int n2 = this.tableList.convertRowIndexToView(i);
            DbObject dbObject = this.getDbObject(n2);
            if (dbObject == null || !list.contains(dbObject)) continue;
            dataStore.deleteRow(i);
        }
        this.tableList.getDataStoreTableModel().fireTableDataChanged();
    }

    @Override
    public void addTableListDisplayClient(JTable jTable) {
        if (this.tableListClients == null) {
            this.tableListClients = new ArrayList<JTable>();
        }
        if (!this.tableListClients.contains(jTable)) {
            this.tableListClients.add(jTable);
        }
        if (this.tableList != null && this.tableList.getRowCount() > 0) {
            this.updateDisplayClients();
        }
    }

    @Override
    public void removeTableListDisplayClient(JTable jTable) {
        if (this.tableListClients == null) {
            return;
        }
        this.tableListClients.remove(jTable);
    }

    private TableIdentifier createTableIdentifier(int n) {
        DataStore dataStore = this.tableList.getDataStore();
        Object object = dataStore.getRow(n).getUserObject();
        if (object instanceof TableIdentifier) {
            return (TableIdentifier)object;
        }
        String[] stringArray = this.getConnection().getMetadata().getTableListColumns();
        String string = dataStore.getValueAsString(n, stringArray[0]);
        String string2 = dataStore.getValueAsString(n, stringArray[3]);
        String string3 = dataStore.getValueAsString(n, stringArray[2]);
        String string4 = dataStore.getValueAsString(n, stringArray[1]);
        String string5 = dataStore.getValueAsString(n, stringArray[4]);
        TableIdentifier tableIdentifier = new TableIdentifier(string3, string2, string, false);
        tableIdentifier.setType(string4);
        tableIdentifier.setNeverAdjustCase(true);
        tableIdentifier.setComment(string5);
        return tableIdentifier;
    }

    @Override
    public WbConnection getConnection() {
        return this.dbConnection;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private DbObject getDbObject(int n) {
        Object object = this.tableList.getDataStore().getRow(n).getUserObject();
        if (object instanceof DbObject) {
            return (DbObject)object;
        }
        TableIdentifier tableIdentifier = this.createTableIdentifier(n);
        tableIdentifier.checkQuotesNeeded(this.dbConnection);
        return tableIdentifier;
    }

    @Override
    public void rowCountStarting() {
        if (this.tableList.getColumnIndex(ROW_COUNT_COLUMN.getColumnName()) == -1) {
            int[] nArray = this.tableList.getSelectedRows();
            WbSwingUtilities.invoke(() -> {
                this.tableList.addColumn(ROW_COUNT_COLUMN, 1);
                this.tableList.restoreSelection(nArray);
            });
        }
    }

    @Override
    public void showRowCount(TableIdentifier tableIdentifier, long l) {
        DataStoreTableModel dataStoreTableModel = this.tableList.getDataStoreTableModel();
        if (dataStoreTableModel == null) {
            return;
        }
        int n = this.findTable(tableIdentifier);
        if (n < 0) {
            return;
        }
        String string = ROW_COUNT_COLUMN.getColumnName();
        int n2 = dataStoreTableModel.findColumn(string);
        dataStoreTableModel.setValue(l, n, n2);
    }

    @Override
    public void rowCountDone(int n) {
    }

    @Override
    public List<TableIdentifier> getSelectedTables() {
        List<DbObject> list = this.getSelectedObjects();
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(dbObject -> dbObject instanceof TableIdentifier).map(TableIdentifier.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<DbObject> getSelectedObjects() {
        int[] nArray = this.tableList.getSelectedRows();
        int n = nArray.length;
        if (n == 0) {
            return null;
        }
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>(n);
        for (int i = 0; i < n; ++i) {
            DbObject dbObject = this.getDbObject(nArray[i]);
            arrayList.add(dbObject);
        }
        return arrayList;
    }

    @Override
    public void selectTable(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            return;
        }
        if (this.tableList == null) {
            return;
        }
        if (this.selectedTable != null && this.selectedTable.equals(tableIdentifier)) {
            return;
        }
        int n = this.findTable(tableIdentifier);
        if (n < 0 && this.tableList.getDataStore().isFiltered()) {
            this.findPanel.resetFilter();
            n = this.findTable(tableIdentifier);
        }
        if (n > -1) {
            try {
                this.ignoreStateChanged = true;
                this.displayTab.setSelectedIndex(0);
            }
            finally {
                this.ignoreStateChanged = false;
            }
            this.tableList.scrollToRow(n);
            this.tableList.setRowSelectionInterval(n, n);
        }
    }

    private int findTable(TableIdentifier tableIdentifier) {
        for (int i = 0; i < this.tableList.getRowCount(); ++i) {
            TableIdentifier tableIdentifier2 = this.createTableIdentifier(i);
            if (!tableIdentifier2.compareNames(tableIdentifier)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.ignoreStateChanged) {
            return;
        }
        if (changeEvent.getSource() == this.displayTab) {
            if (this.isBusy() && this.displayTab.getSelectedIndex() != this.currentRetrievalPanel) {
                WbSwingUtilities.showMessageKey(SwingUtilities.getWindowAncestor(this), "ErrConnectionBusy");
                return;
            }
            EventQueue.invokeLater(this::startRetrieveCurrentPanel);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Set<String> set = CollectionUtil.caseInsensitiveSet("workbench.dbexplorer.instantfilter", "workbench.dbexplorer.tablelist.filter.retrieve", "workbench.dbexplorer.assumewildcards");
        if (propertyChangeEvent.getSource() == this.renameAction) {
            this.checkAlterButton();
        } else if ("workbench.dbexplorer.tablelist.history".equals(propertyChangeEvent.getPropertyName())) {
            WbSwingUtilities.invokeLater(() -> {
                if (DbExplorerSettings.getDbExplorerShowTableHistory()) {
                    this.showTableHistory();
                } else {
                    this.hideTableHistory();
                }
            });
        } else if ("workbench.dbexplorer.allow.source.edit".equals(propertyChangeEvent.getPropertyName())) {
            this.tableSource.allowEditing(DbExplorerSettings.allowSourceEditing());
        } else if ("index".equals(propertyChangeEvent.getPropertyName())) {
            this.shouldRetrieveIndexes = true;
        } else if ("tableDefinition".equals(propertyChangeEvent.getPropertyName())) {
            this.invalidateData();
            this.shouldRetrieveTable = false;
        } else if (set.contains(propertyChangeEvent.getPropertyName())) {
            this.configureFindPanel();
        } else if ("workbench.gui.dbobjects.tabletabs".equals(propertyChangeEvent.getPropertyName())) {
            EventQueue.invokeLater(() -> {
                int n = PlacementChooser.getPlacementLocation();
                this.displayTab.setTabPlacement(n);
                this.displayTab.validate();
            });
        }
    }

    private void configureFindPanel() {
        this.findPanel.setFilterOnType(this.getApplyFilterWhileTyping());
        this.findPanel.setAlwaysUseContainsFilter(DbExplorerSettings.getUsePartialMatch());
        if (DbExplorerSettings.getUseFilterForRetrieve()) {
            this.findPanel.setActionsEnabled(false);
            this.findPanel.setToolTipText(ResourceMgr.getString("TxtQuickFilterLikeHint"));
            this.findPanel.setReloadAction(this.reloadAction);
        } else {
            this.findPanel.setReloadAction(null);
            this.findPanel.setActionsEnabled(true);
            this.findPanel.setFilterTooltip();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.shiftDown = (mouseEvent.getModifiers() & 1) == 1;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private /* synthetic */ void lambda$retrieveTableSource$11(String string) {
        this.tableSource.setText(string, this.selectedTable.getTableName(), this.selectedTable.getObjectType());
        this.tableSource.setCaretPosition(0, false);
        if (DbExplorerSettings.getSelectSourcePanelAfterRetrieve()) {
            this.tableSource.requestFocusInWindow();
        }
    }

    private /* synthetic */ void lambda$retrieve$10(DataStoreTableModel dataStoreTableModel, int n) {
        this.tableList.setModel(dataStoreTableModel, true);
        this.tableList.getExportAction().setEnabled(true);
        if (n > -1) {
            this.tableList.setMultiLine(n);
        }
        this.tableList.adjustColumns();
        this.updateDisplayClients();
    }
}

