/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.db.PartitionLister;
import workbench.db.SubPartitionState;
import workbench.db.TableIdentifier;
import workbench.db.TablePartition;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ReloadAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.interfaces.Reloadable;
import workbench.interfaces.Resettable;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class TablePartitionsPanel
extends JPanel
implements Reloadable,
Resettable,
ListSelectionListener {
    private TableIdentifier currentTable;
    private ReloadAction reload;
    private WbConnection dbConnection;
    private PartitionLister reader;
    private JScrollPane usedScroll;
    private WbTable mainPartitions = new WbTable(false, false, false);
    private WbTable subPartitions = new WbTable(false, false, false);
    private boolean isRetrieving;
    private WbSplitPane split = new WbSplitPane(0);
    private JLabel partitionLabel;
    private JLabel subPartitionLabel;
    private JPanel subPanel;

    public TablePartitionsPanel() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.partitionLabel = this.createTitleLabel("TxtPartitions");
        jPanel.add((Component)this.partitionLabel, "First");
        this.usedScroll = new JScrollPane(this.mainPartitions);
        jPanel.add((Component)this.usedScroll, "Center");
        this.split.setTopComponent(jPanel);
        this.subPanel = new JPanel(new BorderLayout());
        this.subPartitionLabel = this.createTitleLabel("TxtSubPartitions");
        this.subPanel.add((Component)this.subPartitionLabel, "First");
        JScrollPane jScrollPane = new JScrollPane(this.subPartitions);
        this.subPanel.add((Component)jScrollPane, "Center");
        this.split.setBottomComponent(this.subPanel);
        this.split.setDividerLocation(0.5);
        this.split.setDividerSize(IconMgr.getInstance().getSizeForLabel() / 2);
        this.split.setDividerBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this.split, "Center");
        this.reload = new ReloadAction(this);
        this.reload.setEnabled(false);
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.add(this.reload);
        this.add((Component)wbToolbar, "First");
        this.mainPartitions.setSelectionMode(0);
        this.mainPartitions.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.loadSubPartitions();
    }

    private JLabel createTitleLabel(String string) {
        JLabel jLabel = new JLabel(ResourceMgr.getString(string));
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        jLabel.setIconTextGap(IconMgr.getInstance().getSizeForLabel() / 2);
        jLabel.setHorizontalTextPosition(10);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(1);
        FontMetrics fontMetrics = jLabel.getFontMetrics(font2);
        int n = fontMetrics.getHeight();
        int n2 = n / 3;
        int n3 = n / 5;
        jLabel.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(n2, n3, n2, n3)));
        jLabel.setFont(font2);
        return jLabel;
    }

    public void dispose() {
        this.reset();
        if (this.mainPartitions != null) {
            this.mainPartitions.dispose();
        }
        if (this.subPartitions != null) {
            this.subPartitions.dispose();
        }
    }

    public void setCurrentTable(TableIdentifier tableIdentifier) {
        this.currentTable = tableIdentifier;
        this.reset();
    }

    public void setConnection(WbConnection wbConnection) {
        this.reset();
        this.dbConnection = wbConnection;
        this.reader = PartitionLister.Factory.createReader(wbConnection);
        this.reload.setEnabled(this.reader != null);
    }

    @Override
    public void reset() {
        WbSwingUtilities.invoke(() -> {
            this.mainPartitions.reset();
            this.subPartitions.reset();
        });
    }

    public void cancel() {
    }

    @Override
    public void reload() {
        this.reset();
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        WbThread wbThread = new WbThread(this::doLoad, "Partition Retrieval Thread");
        wbThread.start();
    }

    public void doLoad() {
        if (this.reader == null) {
            return;
        }
        if (this.isRetrieving) {
            return;
        }
        try {
            this.isRetrieving = true;
            this.reload.setEnabled(false);
            WbSwingUtilities.showWaitCursor(this);
            List<? extends TablePartition> list = this.reader.getPartitions(this.currentTable);
            boolean bl = this.mightHaveSubPartitions(list);
            if (bl) {
                this.showSubPartitions();
            } else {
                this.hideSubPartitions();
            }
            EventQueue.invokeLater(() -> this.showPartitions(list, this.mainPartitions));
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
            this.reload.setEnabled(true);
            this.isRetrieving = false;
        }
    }

    private boolean mightHaveSubPartitions(List<? extends TablePartition> list) {
        if (CollectionUtil.isEmpty(list)) {
            return false;
        }
        for (TablePartition tablePartition : list) {
            SubPartitionState subPartitionState = tablePartition.getSubPartitionState();
            if (subPartitionState != SubPartitionState.unknown && subPartitionState != SubPartitionState.yes) continue;
            return true;
        }
        return false;
    }

    private void hideSubPartitions() {
        if (this.subPanel.isVisible()) {
            WbSwingUtilities.invoke(() -> {
                this.subPanel.setVisible(false);
                this.split.doLayout();
            });
        }
    }

    private void showSubPartitions() {
        if (!this.subPanel.isVisible()) {
            WbSwingUtilities.invoke(() -> {
                this.subPanel.setVisible(true);
                this.split.setDividerLocation(0.5);
                this.split.doLayout();
            });
        }
    }

    private void loadSubPartitions() {
        this.subPartitions.reset();
        if (this.reader == null) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        WbThread wbThread = new WbThread(this::doRetrieveSubPartitions, "SubPartition Retrieval Thread");
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRetrieveSubPartitions() {
        if (this.isRetrieving) {
            return;
        }
        int n = this.mainPartitions.getSelectedRow();
        if (n < 0) {
            return;
        }
        TablePartition tablePartition = (TablePartition)this.mainPartitions.getDataStore().getRow(n).getUserObject();
        if (tablePartition == null) {
            return;
        }
        try {
            this.isRetrieving = true;
            this.reload.setEnabled(false);
            WbSwingUtilities.showWaitCursor(this);
            List<? extends TablePartition> list = tablePartition.getSubPartitionState() == SubPartitionState.yes && tablePartition.getSubPartitions() != null ? tablePartition.getSubPartitions() : this.reader.getSubPartitions(this.currentTable, tablePartition);
            if (CollectionUtil.isNonEmpty(list)) {
                EventQueue.invokeLater(() -> this.showPartitions(list, this.subPartitions));
            }
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
            this.reload.setEnabled(true);
            this.isRetrieving = false;
        }
    }

    private void showPartitions(List<? extends TablePartition> list, WbTable wbTable) {
        String[] stringArray = new String[]{"PARTITION", "TYPE", "DEFINITION"};
        int[] nArray = new int[]{30, 20, 60};
        int[] nArray2 = new int[]{12, 12, 12};
        DataStore dataStore = new DataStore(stringArray, nArray2, nArray);
        for (TablePartition tablePartition : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 0, (Object)tablePartition.getObjectName());
            dataStore.setValue(n, 1, (Object)tablePartition.getPartitionStrategy());
            dataStore.setValue(n, 2, (Object)StringUtil.trim(tablePartition.getDefinition()));
            dataStore.getRow(n).setUserObject(tablePartition);
        }
        dataStore.resetStatus();
        DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
        wbTable.setModel(dataStoreTableModel, true);
    }
}

