/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.QuickFilterAction;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.CloseIcon;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.MultiSelectComboBox;
import workbench.gui.components.WbLabelField;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbStatusLabel;
import workbench.gui.components.WbToolbar;
import workbench.gui.components.WbToolbarButton;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.ExplorerUtils;
import workbench.gui.dbobjects.objecttree.ContextMenuFactory;
import workbench.gui.dbobjects.objecttree.DbObjectsTree;
import workbench.gui.dbobjects.objecttree.DbTreeSettings;
import workbench.gui.dbobjects.objecttree.ObjectFinder;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.RowCountDisplay;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.gui.dbobjects.objecttree.TreePosition;
import workbench.interfaces.ObjectDropListener;
import workbench.interfaces.QuickFilter;
import workbench.interfaces.Reloadable;
import workbench.interfaces.StatusBar;
import workbench.interfaces.WbSelectionModel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbProperties;
import workbench.util.WbThread;

public class DbTreePanel
extends JPanel
implements Reloadable,
ActionListener,
MouseListener,
DbObjectList,
ObjectDropListener,
KeyListener,
QuickFilter,
RowCountDisplay,
ObjectFinder,
TreeSelectionListener {
    public static final String PROP_DIVIDER = "divider.location";
    public static final String PROP_VISIBLE = "tree.visible";
    public static final String PROP_TYPES = "tree.selectedtypes";
    private static int instanceCount = 0;
    private DbObjectsTree tree;
    private int id = ++instanceCount;
    private WbConnection connection;
    private WbStatusLabel statusBar;
    private WbLabelField currentSchemaLabel = new WbLabelField();
    private JPanel schemaPanel;
    private MultiSelectComboBox<String> typeFilter;
    private List<String> selectedTypes;
    private JPanel toolPanel;
    private ReloadAction reload;
    private WbToolbarButton closeButton;
    private JTextField filterValue;
    private QuickFilterAction filterAction;
    private WbAction resetFilter;
    private List<TreePath> expandedNodes;
    private boolean isPrivateConnection;

    public DbTreePanel() {
        super(new BorderLayout());
        this.currentSchemaLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.statusBar = new WbStatusLabel(new CompoundBorder(new DividerBorder(4), new EmptyBorder(2, 2, 2, 0)));
        this.tree = new DbObjectsTree(this.statusBar);
        this.tree.addMouseListener(this);
        this.tree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.createToolbar();
        this.add((Component)this.toolPanel, "First");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.statusBar, "Last");
    }

    private void createToolbar() {
        this.toolPanel = new JPanel(new GridBagLayout());
        this.typeFilter = new MultiSelectComboBox();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.toolPanel.add(this.typeFilter, gridBagConstraints);
        this.reload = new ReloadAction(this);
        this.reload.setUseLabelIconSize(true);
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.add(this.reload);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, IconMgr.getInstance().getSizeForLabel(), 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.toolPanel.add((Component)wbToolbar, gridBagConstraints);
        CloseIcon closeIcon = new CloseIcon(IconMgr.getInstance().getToolbarIconSize());
        closeIcon.setUseLargeSize(true);
        this.closeButton = new WbToolbarButton(closeIcon);
        this.closeButton.setActionCommand("close-panel");
        this.closeButton.addActionListener(this);
        this.closeButton.setRolloverEnabled(true);
        WbToolbarButton wbToolbarButton = new WbToolbarButton(IconMgr.getInstance().getLabelIcon("save"));
        Dimension dimension = wbToolbarButton.getPreferredSize();
        int n = closeIcon.getIconWidth() / 2;
        int n2 = closeIcon.getIconHeight() / 2;
        int n3 = dimension.width / 2 - n - 2;
        int n4 = dimension.height / 2 - n2 - 2;
        this.closeButton.setMargin(new Insets(n4, n3, n4, n3));
        wbToolbar.add(this.closeButton);
        this.typeFilter.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(0, 1));
        jPanel.setBorder(new EmptyBorder(2, 0, 2, 4));
        this.filterValue = new JTextField();
        this.filterAction = new QuickFilterAction(this);
        this.resetFilter = new WbAction(){

            @Override
            public void executeAction(ActionEvent actionEvent) {
                DbTreePanel.this.resetFilter();
            }
        };
        this.resetFilter.setIcon("resetfilter");
        this.resetFilter.setEnabled(false);
        WbToolbar wbToolbar2 = new WbToolbar();
        wbToolbar2.add(this.filterAction);
        wbToolbar2.add(this.resetFilter);
        wbToolbar2.setMargin(WbSwingUtilities.getEmptyInsets());
        wbToolbar2.setBorderPainted(true);
        jPanel.add((Component)wbToolbar2, "Before");
        jPanel.add((Component)this.filterValue, "Center");
        this.filterValue.addKeyListener(this);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = WbSwingUtilities.getEmptyInsets();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.toolPanel.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.toolPanel.add((Component)this.createSchemaPanel(), gridBagConstraints);
    }

    private JPanel createSchemaPanel() {
        this.schemaPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.schemaPanel.add((Component)this.currentSchemaLabel, gridBagConstraints);
        CompoundBorder compoundBorder = new CompoundBorder(new DividerBorder(4), new EmptyBorder(2, 0, 2, 0));
        this.schemaPanel.setBorder(compoundBorder);
        return this.schemaPanel;
    }

    @Override
    public void reload() {
        if (!WbSwingUtilities.isConnectionIdle(this, this.connection)) {
            return;
        }
        this.resetExpanded();
        WbThread wbThread = new WbThread("DbTree Load Thread"){

            @Override
            public void run() {
                DbTreePanel.this.tree.reload();
            }
        };
        wbThread.start();
    }

    @Override
    public void selectObject(DbObject dbObject) {
        this.tree.selectObject(dbObject);
    }

    public DbObjectsTree getTree() {
        return this.tree;
    }

    public TreeLoader getLoader() {
        return this.tree.getLoader();
    }

    public void setConnectionToUse(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        if (this.isPrivateConnection && this.connection != null) {
            this.disconnect(true);
        }
        if (wbConnection != this.connection) {
            LogMgr.logDebug(new CallerInfo(){}, "Using connection " + wbConnection + " for DbTree");
            final boolean bl = this.connection == null;
            this.connection = wbConnection;
            this.connection.setShared(true);
            final TreePath treePath = this.tree.getSelectionPath();
            this.tree.setConnection(this.connection);
            this.isPrivateConnection = false;
            if (this.connection.isBusy()) {
                LogMgr.logWarning(new CallerInfo(){}, "Not loading tree, because connection is busy", new Exception("Backtrace"));
                return;
            }
            WbThread wbThread = new WbThread("Tree Loader"){

                @Override
                public void run() {
                    if (bl) {
                        DbTreePanel.this.loadTypes();
                    }
                    if (treePath == null || treePath.getPathCount() == 0) {
                        DbTreePanel.this.tree.load(true);
                    } else {
                        DbTreePanel.this.tree.reload(treePath);
                    }
                }
            };
            wbThread.start();
        }
    }

    public void connect(final ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            return;
        }
        if (this.connection != null && this.connection.getProfile().equals(connectionProfile)) {
            return;
        }
        final boolean bl = this.connection != null;
        this.isPrivateConnection = true;
        WbThread wbThread = new WbThread("DbTree Connect Thread"){

            @Override
            public void run() {
                if (bl) {
                    DbTreePanel.this.disconnect(true);
                }
                DbTreePanel.this.doConnect(connectionProfile);
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect(ConnectionProfile connectionProfile) {
        String string = "DbTree-" + Integer.toString(this.id);
        this.resetExpanded();
        ConnectionMgr connectionMgr = ConnectionMgr.getInstance();
        this.statusBar.setStatusMessage(ResourceMgr.getFormattedString("MsgConnectingTo", connectionProfile.getName()));
        try {
            this.connection = connectionMgr.getConnection(connectionProfile, string);
            CharSequence charSequence = SqlUtil.getWarnings(this.connection, null);
            if (StringUtil.isNonEmpty(charSequence)) {
                LogMgr.logWarning(new CallerInfo(){}, "Received warnings from connection: " + charSequence);
            }
            if (DbTreeSettings.useAutocommit(this.connection.getDbId()) && !DbTreeSettings.useTabConnection()) {
                LogMgr.logDebug(new CallerInfo(){}, "Setting connection " + string + " to auto commit");
                this.connection.changeAutoCommit(true);
            }
            ExplorerUtils.initDbExplorerConnection(this.connection);
            this.tree.setConnection(this.connection);
            this.statusBar.setStatusMessage(ResourceMgr.getString("MsgRetrieving"));
            this.loadTypes();
            this.tree.load(true);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not connect", throwable);
        }
        finally {
            this.statusBar.clearStatusMessage();
        }
    }

    private void loadTypes() {
        Set<String> set = this.connection.getDbSettings().getGlobalObjectTypes();
        ArrayList<String> arrayList = new ArrayList<String>(this.connection.getMetadata().getObjectTypes());
        if (!set.isEmpty() && !DbTreeSettings.applyTypeFilterForGlobalObjects()) {
            arrayList.removeAll(set);
        }
        LogMgr.logDebug(new CallerInfo(){}, "Using the following object types for the type filter: " + arrayList);
        arrayList.add("PROCEDURE");
        if (DbExplorerSettings.getShowTriggerPanel()) {
            arrayList.add("TRIGGER");
        }
        List list = (List)CollectionUtil.firstNonEmpty((Collection[])new List[]{this.selectedTypes, arrayList});
        WbSwingUtilities.invoke(() -> {
            try {
                this.typeFilter.removeActionListener(this);
                this.typeFilter.setItems(arrayList, list);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not set object types", throwable);
            }
            finally {
                this.typeFilter.addActionListener(this);
            }
        });
        List<String> list2 = this.typeFilter.getItems();
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList);
        arrayList2.removeAll(list2);
        if (!arrayList2.isEmpty()) {
            arrayList.remove("TRIGGER");
            arrayList.remove("PROCEDURE");
            LogMgr.logWarning(new CallerInfo(){}, "Not all types shown in the dropdown!\nTypes from the driver: " + arrayList + "\nTypes missing: " + arrayList2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSelectedNodes() {
        if (!WbSwingUtilities.isConnectionIdle(this, this.tree.getConnection())) {
            return;
        }
        List<ObjectTreeNode> list = this.getSelectedNodes();
        if (list.isEmpty()) {
            return;
        }
        try {
            this.statusBar.setStatusMessage(ResourceMgr.getString("MsgRetrieving"));
            WbSwingUtilities.showWaitCursor(this);
            for (ObjectTreeNode objectTreeNode : list) {
                try {
                    this.tree.reloadNode(objectTreeNode);
                }
                catch (SQLException sQLException) {
                    WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(sQLException));
                    LogMgr.logError(new CallerInfo(){}, "Could not load node " + objectTreeNode.getType() + " - " + objectTreeNode.getName(), sQLException);
                }
            }
        }
        finally {
            this.statusBar.clearStatusMessage();
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    public void dispose() {
        this.resetExpanded();
        this.tree.removeMouseListener(this);
        this.tree.clear();
        this.typeFilter.removeActionListener(this);
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void saveSettings(WbProperties wbProperties) {
        if (this.isVisible()) {
            wbProperties.setProperty("divider.location." + this.getCurrentPosition().name(), this.getDividerLocation());
        }
        List<String> list = this.typeFilter.getSelectedItems();
        wbProperties.setProperty(PROP_TYPES, StringUtil.listToString(list, ','));
    }

    private TreePosition getCurrentPosition() {
        WbSplitPane wbSplitPane = (WbSplitPane)this.getParent();
        if (wbSplitPane == null) {
            return DbTreeSettings.getDbTreePosition();
        }
        if (wbSplitPane.getLeftComponent() == this) {
            return TreePosition.left;
        }
        return TreePosition.right;
    }

    public void restoreSettings(WbProperties wbProperties) {
        WbSplitPane wbSplitPane;
        int n = wbProperties.getIntProperty("divider.location." + this.getCurrentPosition().name(), -1);
        String string = wbProperties.getProperty(PROP_TYPES);
        if (StringUtil.isBlank(string)) {
            string = DbExplorerSettings.getDefaultExplorerObjectType();
        }
        this.selectedTypes = StringUtil.stringToList(string, ",", true, true, false);
        this.tree.setTypesToShow(this.selectedTypes);
        if (n > -1 && (wbSplitPane = (WbSplitPane)this.getParent()) != null) {
            wbSplitPane.setDividerLocation(n);
        }
    }

    public void disconnectInBackground() {
        if (this.isPrivateConnection) {
            this.disconnect(false);
        }
    }

    public void disconnect() {
        if (this.isPrivateConnection) {
            this.disconnect(true);
        }
    }

    private void disconnect(boolean bl) {
        if (this.tree != null) {
            this.tree.clear();
            this.tree.setConnection(null);
        }
        Runnable runnable = () -> {
            WbConnection wbConnection = this.connection;
            this.connection = null;
            ConnectionMgr.getInstance().disconnect(wbConnection);
        };
        if (bl) {
            runnable.run();
        } else {
            WbThread wbThread = new WbThread(runnable, "Disconnect");
            wbThread.start();
        }
    }

    protected ObjectTreeNode getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        ObjectTreeNode objectTreeNode = (ObjectTreeNode)treePath.getLastPathComponent();
        return objectTreeNode;
    }

    public WbSelectionModel getSelectionModel() {
        return WbSelectionModel.Factory.createFacade(this.tree.getSelectionModel());
    }

    @Override
    public void objectsDropped(List<DbObject> list) {
        List<TreePath> list2 = this.tree.getExpandedNodes();
        boolean bl = this.tree.getModel().getFilteredNodes().size() > 0;
        this.tree.getModel().removeObjects(list);
        if (bl) {
            this.applyQuickFilter();
        }
        this.tree.expandNodes(list2);
    }

    @Override
    public int getSelectionCount() {
        List<DbObject> list = this.getSelectedObjects();
        return list == null ? 0 : list.size();
    }

    @Override
    public TableDefinition getCurrentTableDefinition() {
        ObjectTreeNode objectTreeNode = this.getSelectedNode();
        if (objectTreeNode == null) {
            return null;
        }
        DbObject dbObject = objectTreeNode.getDbObject();
        if (!(dbObject instanceof TableIdentifier)) {
            return null;
        }
        ObjectTreeNode objectTreeNode2 = this.tree.findNodeByType(objectTreeNode, "column-list");
        if (objectTreeNode2 == null) {
            return null;
        }
        int n = objectTreeNode2.getChildCount();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(n);
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode3 = objectTreeNode2.getChildAt(i);
            DbObject dbObject2 = objectTreeNode3.getDbObject();
            if (!(dbObject2 instanceof ColumnIdentifier)) continue;
            arrayList.add((ColumnIdentifier)dbObject2);
        }
        TableDefinition tableDefinition = new TableDefinition((TableIdentifier)dbObject, arrayList);
        return tableDefinition;
    }

    private TableIdentifier getTableParent(ObjectTreeNode objectTreeNode) {
        if (objectTreeNode == null) {
            return null;
        }
        while (objectTreeNode != null) {
            DbObject dbObject = objectTreeNode.getDbObject();
            if (dbObject instanceof TableIdentifier) {
                return (TableIdentifier)dbObject;
            }
            objectTreeNode = objectTreeNode.getParent();
        }
        return null;
    }

    @Override
    public TableIdentifier getObjectTable() {
        Serializable serializable;
        Object object;
        if (this.tree.getSelectionCount() <= 0) {
            return null;
        }
        if (this.tree.getSelectionCount() == 1) {
            object = this.getSelectedNode();
            if (object == null) {
                return null;
            }
            serializable = this.getTableParent((ObjectTreeNode)object);
            if (serializable != null) {
                return serializable;
            }
        }
        object = this.getSelectedNodes();
        serializable = ((ObjectTreeNode)object.get(0)).getParent();
        int n = 0;
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            ObjectTreeNode objectTreeNode = (ObjectTreeNode)object2.next();
            if (objectTreeNode.getParent() != serializable) {
                return null;
            }
            if (!(objectTreeNode.getDbObject() instanceof ColumnIdentifier)) continue;
            ++n;
        }
        if (n != object.size()) {
            return null;
        }
        object2 = ((ObjectTreeNode)serializable).getParent();
        if (((ObjectTreeNode)object2).getDbObject() instanceof TableIdentifier) {
            return (TableIdentifier)((ObjectTreeNode)object2).getDbObject();
        }
        return null;
    }

    public List<ObjectTreeNode> getSelectedNodes() {
        TreePath[] treePathArray;
        int n = this.tree.getSelectionCount();
        ArrayList<ObjectTreeNode> arrayList = new ArrayList<ObjectTreeNode>(n);
        if (n == 0) {
            return arrayList;
        }
        for (TreePath treePath : treePathArray = this.tree.getSelectionPaths()) {
            ObjectTreeNode objectTreeNode;
            if (treePath == null || (objectTreeNode = (ObjectTreeNode)treePath.getLastPathComponent()) == null) continue;
            arrayList.add(objectTreeNode);
        }
        return arrayList;
    }

    @Override
    public List<DbObject> getSelectedObjects() {
        List<ObjectTreeNode> list = this.getSelectedNodes();
        int n = list.size();
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>(n);
        if (n == 0) {
            return arrayList;
        }
        for (ObjectTreeNode objectTreeNode : list) {
            DbObject dbObject = objectTreeNode.getDbObject();
            if (dbObject == null) continue;
            arrayList.add(dbObject);
        }
        return arrayList;
    }

    @Override
    public List<TableIdentifier> getSelectedTables() {
        List<ObjectTreeNode> list = this.getSelectedTableNodes();
        int n = list.size();
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(n);
        if (n == 0) {
            return arrayList;
        }
        Set<String> set = this.getConnection().getMetadata().getObjectsWithData();
        for (ObjectTreeNode objectTreeNode : list) {
            DbObject dbObject = objectTreeNode.getDbObject();
            if (!(dbObject instanceof TableIdentifier) || !set.contains(dbObject.getObjectType())) continue;
            arrayList.add((TableIdentifier)dbObject);
        }
        return arrayList;
    }

    public List<ObjectTreeNode> getSelectedTableNodes() {
        TreePath[] treePathArray;
        int n = this.tree.getSelectionCount();
        ArrayList<ObjectTreeNode> arrayList = new ArrayList<ObjectTreeNode>(n);
        if (n == 0) {
            return arrayList;
        }
        DbMetadata dbMetadata = this.tree.getConnection().getMetadata();
        for (TreePath treePath : treePathArray = this.tree.getSelectionPaths()) {
            ObjectTreeNode objectTreeNode;
            if (treePath == null || (objectTreeNode = (ObjectTreeNode)treePath.getLastPathComponent()) == null) continue;
            if ("dbobject-type".equalsIgnoreCase(objectTreeNode.getType()) && dbMetadata.isViewOrTable(objectTreeNode.getName())) {
                arrayList.addAll(this.getTableNodes(objectTreeNode));
            } else if ("schema".equalsIgnoreCase(objectTreeNode.getType())) {
                arrayList.addAll(this.getSchemaTableNodes(objectTreeNode));
            }
            arrayList.add(objectTreeNode);
        }
        return arrayList;
    }

    private List<ObjectTreeNode> getSchemaTableNodes(ObjectTreeNode objectTreeNode) {
        ArrayList<ObjectTreeNode> arrayList = new ArrayList<ObjectTreeNode>();
        int n = objectTreeNode.getChildCount();
        DbMetadata dbMetadata = this.tree.getConnection().getMetadata();
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            if (!"dbobject-type".equalsIgnoreCase(objectTreeNode2.getType()) || !dbMetadata.isViewOrTable(objectTreeNode2.getName())) continue;
            arrayList.addAll(this.getTableNodes(objectTreeNode2));
        }
        return arrayList;
    }

    private List<ObjectTreeNode> getTableNodes(ObjectTreeNode objectTreeNode) {
        int n = objectTreeNode.getChildCount();
        ArrayList<ObjectTreeNode> arrayList = new ArrayList<ObjectTreeNode>(n);
        for (int i = 0; i < n; ++i) {
            ObjectTreeNode objectTreeNode2 = objectTreeNode.getChildAt(i);
            if (objectTreeNode2 == null || !(objectTreeNode2.getDbObject() instanceof TableIdentifier)) continue;
            arrayList.add(objectTreeNode2);
        }
        return arrayList;
    }

    @Override
    public WbConnection getConnection() {
        return this.connection;
    }

    @Override
    public Component getComponent() {
        return this.tree;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.tree.requestFocusInWindow();
    }

    private void closePanel() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof MainWindow) {
            MainWindow mainWindow = (MainWindow)window;
            EventQueue.invokeLater(mainWindow::closeDbTree);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            this.closePanel();
        }
        if (actionEvent.getSource() == this.typeFilter) {
            this.tree.setTypesToShow(this.typeFilter.getSelectedItems());
            this.reload();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.getConnection() == null) {
            return;
        }
        if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
            JPopupMenu jPopupMenu;
            TreePath treePath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (this.tree.getSelectionCount() == 1) {
                this.tree.setSelectionPath(treePath);
            }
            if ((jPopupMenu = ContextMenuFactory.createContextMenu(this, this.getSelectionModel())) != null) {
                jPopupMenu.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private boolean isEditKey(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\b': 
            case '\f': 
            case '\u007f': 
            case '\u009b': 
            case '\uffd1': {
                return true;
            }
        }
        return false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (Character.isISOControl(keyEvent.getKeyChar()) && !this.isEditKey(keyEvent)) {
            return;
        }
        if (DbTreeSettings.getFilterWhileTyping()) {
            EventQueue.invokeLater(this::applyQuickFilter);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() != this.filterValue || keyEvent.getModifiers() != 0) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                this.tree.dispatchEvent(keyEvent);
                break;
            }
            case 10: {
                keyEvent.consume();
                this.applyQuickFilter();
                break;
            }
            case 27: {
                keyEvent.consume();
                this.resetFilter();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void resetFilter() {
        List<TreePath> list = this.expandedNodes;
        if (list == null) {
            list = this.tree.getExpandedNodes();
        }
        this.tree.getModel().resetFilter();
        this.tree.expandNodes(list);
        this.resetFilter.setEnabled(false);
        this.resetExpanded();
    }

    @Override
    public synchronized void applyQuickFilter() {
        String string = this.filterValue.getText();
        if (StringUtil.isEmptyString(string)) {
            this.resetFilter();
            return;
        }
        if (this.expandedNodes == null) {
            this.expandedNodes = this.tree.getExpandedNodes();
        }
        this.tree.getModel().applyFilter(string);
        this.resetFilter.setEnabled(true);
        List<TreePath> list = null;
        list = DbTreeSettings.autoExpandFilteredNodes() ? this.tree.getFilteredNodes() : this.tree.getExpandedNodes();
        this.tree.expandNodes(list);
    }

    @Override
    public void rowCountDone(int n) {
    }

    @Override
    public void rowCountStarting() {
    }

    @Override
    public void showRowCount(TableIdentifier tableIdentifier, long l) {
        if (tableIdentifier == null) {
            return;
        }
        List<ObjectTreeNode> list = this.getSelectedTableNodes();
        for (ObjectTreeNode objectTreeNode : list) {
            if (!tableIdentifier.equals(objectTreeNode.getDbObject())) continue;
            objectTreeNode.setRowCount(l);
            EventQueue.invokeLater(() -> this.tree.getModel().nodeChanged(objectTreeNode));
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.currentSchemaLabel.setText(this.tree.getSelectedNamespace());
    }

    private void resetExpanded() {
        if (this.expandedNodes != null) {
            this.expandedNodes.clear();
            this.expandedNodes = null;
        }
    }

    private int getDividerLocation() {
        WbSplitPane wbSplitPane = (WbSplitPane)this.getParent();
        if (wbSplitPane == null) {
            return -1;
        }
        return wbSplitPane.getDividerLocation();
    }
}

