/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.objecttree.RowCountDisplay;
import workbench.interfaces.Interruptable;
import workbench.interfaces.StatusBar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.WbThread;

public class ShowRowCountAction
extends WbAction
implements Interruptable {
    private DbObjectList source;
    private StatusBar statusBar;
    private boolean cancelCount;
    private Statement currentStatement;
    private RowCountDisplay display;

    public ShowRowCountAction(DbObjectList dbObjectList, RowCountDisplay rowCountDisplay, StatusBar statusBar) {
        this.initMenuDefinition("MnuTxtShowRowCounts");
        this.source = dbObjectList;
        this.display = rowCountDisplay;
        this.statusBar = statusBar;
        this.setEnabled(this.getSelectedTables().size() > 0);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.countRows();
    }

    private void countRows() {
        if (!WbSwingUtilities.isConnectionIdle(this.source.getComponent(), this.source.getConnection())) {
            return;
        }
        List<TableIdentifier> list = this.getSelectedTables();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        WbThread wbThread = new WbThread("RowCount Thread"){

            @Override
            public void run() {
                ShowRowCountAction.this.doCount();
            }
        };
        wbThread.start();
    }

    private List<TableIdentifier> getSelectedTables() {
        if (this.source == null) {
            return Collections.emptyList();
        }
        return this.source.getSelectedTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCount() {
        List<TableIdentifier> list = this.getSelectedTables();
        if (list.isEmpty()) {
            return;
        }
        WbConnection wbConnection = this.source.getConnection();
        TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(wbConnection, "tablerowcount", "tabledata");
        boolean bl = wbConnection.getDbSettings().useSavePointForDML();
        CallerInfo callerInfo = new CallerInfo(){};
        ResultSet resultSet = null;
        int n = list.size();
        this.display.rowCountStarting();
        try {
            wbConnection.setBusy(true);
            WbSwingUtilities.showWaitCursor(this.source.getComponent());
            this.currentStatement = wbConnection.createStatementForQuery();
            for (int i = 0; i < n; ++i) {
                String string;
                TableIdentifier tableIdentifier = list.get(i);
                if (this.statusBar != null) {
                    string = ResourceMgr.getFormattedString("MsgProcessing", tableIdentifier.getRawTableName(), i + 1, n);
                    this.statusBar.setStatusMessage(string);
                }
                string = tableSelectBuilder.getSelectForCount(tableIdentifier);
                LogMgr.logDebug(callerInfo, "Retrieving rowcount using:\n" + string);
                resultSet = JdbcUtils.runQuery(wbConnection, this.currentStatement, string, bl);
                if (resultSet != null && resultSet.next()) {
                    long l = resultSet.getLong(1);
                    this.display.showRowCount(tableIdentifier, l);
                }
                JdbcUtils.closeResult(resultSet);
                if (this.cancelCount) break;
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(callerInfo, "Error counting rows: ", exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, this.currentStatement);
                if (wbConnection.selectStartsTransaction()) {
                    wbConnection.endReadOnlyTransaction(new CallerInfo(){});
                }
                this.currentStatement = null;
                wbConnection.setBusy(false);
                if (this.statusBar != null) {
                    this.statusBar.clearStatusMessage();
                }
                this.display.rowCountDone(n);
                WbSwingUtilities.showDefaultCursor(this.source.getComponent());
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, this.currentStatement);
            if (wbConnection.selectStartsTransaction()) {
                wbConnection.endReadOnlyTransaction(new /* invalid duplicate definition of identical inner class */);
            }
            this.currentStatement = null;
            wbConnection.setBusy(false);
            if (this.statusBar != null) {
                this.statusBar.clearStatusMessage();
            }
            this.display.rowCountDone(n);
            WbSwingUtilities.showDefaultCursor(this.source.getComponent());
        }
        JdbcUtils.closeAll(resultSet, this.currentStatement);
        if (wbConnection.selectStartsTransaction()) {
            wbConnection.endReadOnlyTransaction(new /* invalid duplicate definition of identical inner class */);
        }
        this.currentStatement = null;
        wbConnection.setBusy(false);
        if (this.statusBar != null) {
            this.statusBar.clearStatusMessage();
        }
        this.display.rowCountDone(n);
        WbSwingUtilities.showDefaultCursor(this.source.getComponent());
    }

    @Override
    public void cancelExecution() {
        this.cancelCount = true;
        if (this.currentStatement != null) {
            CallerInfo callerInfo = new CallerInfo(){};
            LogMgr.logDebug(callerInfo, "Trying to cancel the current statement");
            try {
                this.currentStatement.cancel();
            }
            catch (SQLException sQLException) {
                LogMgr.logWarning(callerInfo, "Could not cancel statement", sQLException);
            }
        }
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }
}

