/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import workbench.WbManager;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.actions.HelpContactAction;
import workbench.gui.components.WbLabelField;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.BrowserLauncher;
import workbench.util.MemoryWatcher;
import workbench.util.WbFile;

public class WbAboutDialog
extends JDialog
implements ActionListener {
    private EscAction escAction;
    private JLabel builtWithNbLabel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel contentPanel;
    private JLabel homepageLabel;
    private JPanel infoPanel;
    private JLabel jdkVersion;
    private JLabel jeditLabel;
    private JLabel labelCopyright;
    private JLabel labelDesc;
    private JLabel labelTitel;
    private JLabel labelVersion;
    private JLabel licenseLabel;
    private JTextField logfileLabel;
    private JLabel logo;
    private JLabel mailToLabel;
    private JLabel memoryLabel;
    private JTextField settingsLabel;

    public WbAboutDialog(Frame frame) {
        super(frame, true);
        this.initComponents();
        this.homepageLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.mailToLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.builtWithNbLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.jeditLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.licenseLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.jdkVersion.setToolTipText(System.getProperty("java.home"));
        this.getRootPane().setDefaultButton(this.closeButton);
        this.escAction = new EscAction(this, this);
        WbFile wbFile = Settings.getInstance().getConfigFile();
        String string = ResourceMgr.getFormattedString("LblSettingsLocation", wbFile.getFullPath());
        this.settingsLabel.setText(string);
        this.settingsLabel.setCaretPosition(0);
        this.settingsLabel.setBorder(new EmptyBorder(1, 0, 1, 0));
        WbFile wbFile2 = LogMgr.getLogfile();
        this.logfileLabel.setText(ResourceMgr.getFormattedString("LblLogLocation", wbFile2 == null ? "" : wbFile2.getFullPath()));
        this.logfileLabel.setCaretPosition(0);
        this.logfileLabel.setBorder(new EmptyBorder(1, 0, 1, 0));
        long l = MemoryWatcher.getFreeMemory() / 0x100000L;
        long l2 = MemoryWatcher.MAX_MEMORY / 0x100000L;
        this.memoryLabel.setText(ResourceMgr.getString("LblMemory") + " " + l + "MB/" + l2 + "MB");
        this.pack();
    }

    public static void showDialog(Frame frame) {
        if (frame == null) {
            frame = WbManager.getInstance().getCurrentWindow();
        }
        WbAboutDialog wbAboutDialog = new WbAboutDialog(frame);
        wbAboutDialog.setDefaultCloseOperation(2);
        WbSwingUtilities.center(wbAboutDialog, frame);
        wbAboutDialog.setVisible(true);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.contentPanel = new JPanel();
        this.logo = new JLabel();
        this.labelTitel = new JLabel();
        this.labelDesc = new JLabel();
        this.labelVersion = new JLabel();
        this.labelCopyright = new JLabel();
        this.builtWithNbLabel = new JLabel();
        this.jeditLabel = new JLabel();
        this.jdkVersion = new JLabel();
        this.homepageLabel = new JLabel();
        this.licenseLabel = new JLabel();
        this.mailToLabel = new JLabel();
        this.infoPanel = new JPanel();
        this.memoryLabel = new JLabel();
        this.settingsLabel = new WbLabelField();
        this.logfileLabel = new WbLabelField();
        this.setDefaultCloseOperation(2);
        this.setTitle(ResourceMgr.getString("TxtAbout") + " " + "SQL Workbench/J");
        this.setName("AboutDialog");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WbAboutDialog.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.closeButton.setText(ResourceMgr.getString("LblClose"));
        this.closeButton.setName("close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WbAboutDialog.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.contentPanel.setLayout(new GridBagLayout());
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/workbench/resource/images/hitchguide.gif")));
        this.logo.setBorder(BorderFactory.createEtchedBorder());
        this.logo.setIconTextGap(0);
        this.logo.setMaximumSize(new Dimension(172, 128));
        this.logo.setMinimumSize(new Dimension(172, 128));
        this.logo.setPreferredSize(new Dimension(172, 128));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.contentPanel.add((Component)this.logo, gridBagConstraints);
        this.labelTitel.setFont(new Font("Dialog", 1, 14));
        this.labelTitel.setText("SQL Workbench/J");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 8, 0, 5);
        this.contentPanel.add((Component)this.labelTitel, gridBagConstraints);
        this.labelDesc.setText(ResourceMgr.getString("TxtProductDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 5);
        this.contentPanel.add((Component)this.labelDesc, gridBagConstraints);
        this.labelVersion.setText(ResourceMgr.getBuildInfo());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 5);
        this.contentPanel.add((Component)this.labelVersion, gridBagConstraints);
        this.labelCopyright.setText(ResourceMgr.getString("TxtCopyright"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 8, 0, 5);
        this.contentPanel.add((Component)this.labelCopyright, gridBagConstraints);
        this.builtWithNbLabel.setText("<html>Built with NetBeans (<u>netbeans.apache.org</u>)</html>");
        this.builtWithNbLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                WbAboutDialog.this.builtWithNbLabelMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 5, 3, 5);
        this.contentPanel.add((Component)this.builtWithNbLabel, gridBagConstraints);
        this.jeditLabel.setText("<html>The editor is based on jEdit's 2.2.2 <u>syntax highlighting package</u></html>");
        this.jeditLabel.setToolTipText("https://syntax.jedit.org/");
        this.jeditLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                WbAboutDialog.this.jeditLabelMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 4, 5);
        this.contentPanel.add((Component)this.jeditLabel, gridBagConstraints);
        this.jdkVersion.setText(ResourceMgr.getJavaInfo());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 5);
        this.contentPanel.add((Component)this.jdkVersion, gridBagConstraints);
        this.homepageLabel.setText("<html><u>www.sql-workbench.eu</u></html>");
        this.homepageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                WbAboutDialog.this.homepageLabelMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 5);
        this.contentPanel.add((Component)this.homepageLabel, gridBagConstraints);
        this.licenseLabel.setText(ResourceMgr.getString("TxtLicense"));
        this.licenseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                WbAboutDialog.this.licenseLabelMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 4, 5);
        this.contentPanel.add((Component)this.licenseLabel, gridBagConstraints);
        this.mailToLabel.setText("support@sql-workbench.eu");
        this.mailToLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                WbAboutDialog.this.mailToLabelMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 5);
        this.contentPanel.add((Component)this.mailToLabel, gridBagConstraints);
        this.infoPanel.setLayout(new GridBagLayout());
        this.memoryLabel.setText("Memory:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.infoPanel.add((Component)this.memoryLabel, gridBagConstraints);
        this.settingsLabel.setText("Settings");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.infoPanel.add((Component)this.settingsLabel, gridBagConstraints);
        this.logfileLabel.setText("Logfile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.infoPanel.add((Component)this.logfileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.insets = new Insets(11, 7, 0, 7);
        this.contentPanel.add((Component)this.infoPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.pack();
    }

    private void mailToLabelMouseClicked(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.getClickCount() == 1) {
                Window window = this.getOwner();
                MainWindow mainWindow = null;
                if (window instanceof MainWindow) {
                    mainWindow = (MainWindow)window;
                }
                HelpContactAction.sendEmail(mainWindow);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void homepageLabelMouseClicked(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.getClickCount() == 1) {
                BrowserLauncher.openURL("https://www.sql-workbench.eu");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void builtWithNbLabelMouseClicked(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.getClickCount() == 1) {
                BrowserLauncher.openURL("https://netbeans.apache.org/");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void jeditLabelMouseClicked(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.getClickCount() == 1) {
                BrowserLauncher.openURL("https://syntax.jedit.org/");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void licenseLabelMouseClicked(MouseEvent mouseEvent) {
        try {
            if (mouseEvent.getClickCount() == 1) {
                BrowserLauncher.openURL("https://www.sql-workbench.eu/manual/license.html");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.escAction) {
            this.closeDialog(null);
        }
    }
}

