/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.dataimport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.db.importer.ImportOptions;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.EncodingDropDown;
import workbench.gui.components.HistoryTextField;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class GeneralImportOptionsPanel
extends JPanel
implements ImportOptions,
ValidatingComponent {
    private JComboBox dateFormat;
    private JLabel dateFormatLabel;
    private EncodingDropDown encodingPanel;
    private JPanel jPanel1;
    private JComboBox modeComboBox;
    private JLabel modeLabel;
    private JComboBox timestampFormat;
    private JLabel timestampFormatLabel;

    public GeneralImportOptionsPanel() {
        this.initComponents();
    }

    public void setEncodingVisible(boolean bl) {
        this.encodingPanel.setEnabled(false);
        this.encodingPanel.setVisible(false);
    }

    public void setModeSelectorEnabled(boolean bl) {
        this.modeComboBox.setEnabled(bl);
        this.modeComboBox.setSelectedIndex(0);
        this.modeComboBox.setVisible(bl);
    }

    public void saveSettings() {
        this.saveSettings("general");
    }

    public void saveSettings(String string) {
        HistoryTextField historyTextField = (HistoryTextField)this.dateFormat;
        HistoryTextField historyTextField2 = (HistoryTextField)this.timestampFormat;
        historyTextField.setSettingsProperty("dateformat");
        historyTextField2.setSettingsProperty("timestampformat");
        Settings settings = Settings.getInstance();
        if (StringUtil.isEmptyString(string)) {
            string = "general";
        }
        historyTextField.saveSettings(settings, "workbench.import." + string + ".");
        historyTextField2.saveSettings(settings, "workbench.import." + string + ".");
        settings.setProperty("workbench.import." + string + ".encoding", this.getEncoding());
        settings.setProperty("workbench.import." + string + ".mode", this.getMode());
        settings.removeProperty("workbench.import." + string + ".dateformat");
        settings.removeProperty("workbench.import." + string + ".timestampformat");
    }

    public void restoreSettings() {
        this.restoreSettings("general");
    }

    public void restoreSettings(String string) {
        Settings settings = Settings.getInstance();
        HistoryTextField historyTextField = (HistoryTextField)this.dateFormat;
        HistoryTextField historyTextField2 = (HistoryTextField)this.timestampFormat;
        historyTextField.setSettingsProperty("dateformat");
        historyTextField.restoreSettings(settings, "workbench.import." + string + ".");
        historyTextField2.setSettingsProperty("timestampformat");
        historyTextField2.restoreSettings(settings, "workbench.import." + string + ".");
        if (StringUtil.isEmptyString(historyTextField.getText())) {
            this.setDateFormat(settings.getProperty("workbench.import." + string + ".dateformat", settings.getDefaultDateFormat()));
        }
        if (StringUtil.isEmptyString(historyTextField2.getText())) {
            this.setTimestampFormat(settings.getProperty("workbench.import." + string + ".timestampformat", settings.getDefaultTimestampFormat()));
        }
        this.setEncoding(settings.getProperty("workbench.export." + string + ".encoding", settings.getDefaultDataEncoding()));
        this.setMode(settings.getProperty("workbench.import." + string + ".mode", "insert"));
    }

    @Override
    public String getMode() {
        return (String)this.modeComboBox.getSelectedItem();
    }

    @Override
    public void setMode(String string) {
        this.modeComboBox.setSelectedItem(string);
    }

    @Override
    public String getDateFormat() {
        return ((HistoryTextField)this.dateFormat).getText();
    }

    @Override
    public String getEncoding() {
        return this.encodingPanel.getEncoding();
    }

    @Override
    public String getTimestampFormat() {
        return ((HistoryTextField)this.timestampFormat).getText();
    }

    @Override
    public void setDateFormat(String string) {
        ((HistoryTextField)this.dateFormat).setText(string);
    }

    @Override
    public void setEncoding(String string) {
        this.encodingPanel.setEncoding(string);
    }

    @Override
    public void setTimestampFormat(String string) {
        ((HistoryTextField)this.timestampFormat).setText(string);
    }

    @Override
    public boolean validateInput() {
        String string;
        String string2 = this.getDateFormat();
        if (StringUtil.isNonBlank(string2) && (string = StringUtil.isDatePatternValid(string2)) != null) {
            String string3 = ResourceMgr.getFormattedString("ErrInvalidInput", this.dateFormatLabel.getText(), string);
            WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("TxtError"), string3);
            return false;
        }
        string2 = this.getTimestampFormat();
        if (StringUtil.isNonBlank(string2) && (string = StringUtil.isDatePatternValid(string2)) != null) {
            String string4 = ResourceMgr.getFormattedString("ErrInvalidInput", this.timestampFormatLabel.getText(), string);
            WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("TxtError"), string4);
            return false;
        }
        return true;
    }

    @Override
    public void componentDisplayed() {
    }

    @Override
    public void componentWillBeClosed() {
    }

    private void initComponents() {
        this.encodingPanel = new EncodingDropDown();
        this.dateFormatLabel = new JLabel();
        this.timestampFormatLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.modeLabel = new JLabel();
        this.modeComboBox = new JComboBox();
        this.dateFormat = new HistoryTextField();
        this.timestampFormat = new HistoryTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.encodingPanel, gridBagConstraints);
        this.dateFormatLabel.setText(ResourceMgr.getString("LblDateFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.dateFormatLabel, gridBagConstraints);
        this.timestampFormatLabel.setText(ResourceMgr.getString("LblTimestampFormat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.timestampFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.modeLabel.setText(ResourceMgr.getString("LblImportMode"));
        this.modeLabel.setToolTipText(ResourceMgr.getString("d_LblImportMode"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.modeLabel, gridBagConstraints);
        this.modeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"insert", "update", "insert,update", "update,insert"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.modeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.dateFormat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.timestampFormat, gridBagConstraints);
    }
}

