/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.dataimport;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import workbench.db.importer.ImportOptions;
import workbench.db.importer.ProducerFactory;
import workbench.db.importer.TextImportOptions;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.WbFileChooser;
import workbench.gui.dialogs.dataimport.ImportOptionsPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class ImportFileDialog
implements PropertyChangeListener {
    private ProducerFactory.ImportType importType = null;
    private File selectedFile = null;
    private boolean isCancelled = false;
    private Settings settings = Settings.getInstance();
    private ImportOptionsPanel importOptions = new ImportOptionsPanel();
    private WbFileChooser chooser;
    private boolean filterChange = false;
    private String lastDirConfigKey = "workbench.import.lastdir";
    private Component parentComponent;

    public ImportFileDialog(Component component) {
        this.parentComponent = component;
    }

    public void allowImportModeSelection(boolean bl) {
        this.importOptions.allowImportModeSelection(bl);
    }

    public void saveSettings() {
        this.saveSettings("general");
    }

    public void saveSettings(String string) {
        this.importOptions.saveSettings(string);
    }

    public void restoreSettings() {
        this.restoreSettings("general");
    }

    public void restoreSettings(String string) {
        this.importOptions.restoreSettings(string);
    }

    public TextImportOptions getTextOptions() {
        return this.importOptions.getTextOptions();
    }

    public ImportOptions getGeneralOptions() {
        return this.importOptions.getGeneralOptions();
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public ProducerFactory.ImportType getImportType() {
        return this.importType;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setLastDirConfigKey(String string) {
        this.lastDirConfigKey = string;
    }

    public boolean selectInput(String string, String string2) {
        this.importType = null;
        this.selectedFile = null;
        boolean bl = false;
        String string3 = this.settings.getProperty(this.lastDirConfigKey, null);
        this.chooser = new WbFileChooser(string3);
        this.chooser.setSettingsID("workbench." + string2 + ".selectfile");
        if (string != null) {
            this.chooser.setDialogTitle(string);
        }
        this.chooser.addChoosableFileFilter(ExtensionFileFilter.getTextFileFilter());
        this.chooser.addChoosableFileFilter(ExtensionFileFilter.getXmlFileFilter());
        this.chooser.addPropertyChangeListener("fileFilterChanged", this);
        this.chooser.setFileFilter(ExtensionFileFilter.getTextFileFilter());
        this.importOptions.addPropertyChangeListener("exportType", this);
        this.restoreSettings(string2);
        if (this.importOptions.getImportType() == null) {
            this.importOptions.setTypeText();
        }
        switch (this.importOptions.getImportType()) {
            case XML: {
                this.chooser.setFileFilter(ExtensionFileFilter.getXmlFileFilter());
                break;
            }
            case Text: {
                this.chooser.setFileFilter(ExtensionFileFilter.getTextFileFilter());
            }
        }
        this.chooser.setAccessory(this.importOptions);
        this.chooser.setEncodingSelector(this.importOptions);
        Window window = SwingUtilities.getWindowAncestor(this.parentComponent);
        int n = this.chooser.showOpenDialog(window);
        if (n == 0) {
            String string4 = null;
            this.isCancelled = false;
            File file = this.chooser.getSelectedFile();
            FileFilter fileFilter = this.chooser.getFileFilter();
            if (fileFilter instanceof ExtensionFileFilter) {
                ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)fileFilter;
                string4 = file.getAbsolutePath();
                String string5 = ExtensionFileFilter.getExtension(file);
                if (StringUtil.isEmptyString(string5)) {
                    if (!string4.endsWith(".")) {
                        string4 = string4 + ".";
                    }
                    string4 = string4 + extensionFileFilter.getDefaultExtension();
                }
                this.importType = this.getImportType(fileFilter);
            } else {
                string4 = file.getAbsolutePath();
                this.importType = this.importOptions.getImportType();
            }
            string3 = this.chooser.getCurrentDirectory().getAbsolutePath();
            this.settings.setProperty(this.lastDirConfigKey, string3);
            this.saveSettings(string2);
            this.selectedFile = new File(string4);
            bl = true;
        } else {
            this.isCancelled = true;
            bl = false;
        }
        return bl;
    }

    private ProducerFactory.ImportType getImportType(FileFilter fileFilter) {
        if (fileFilter == ExtensionFileFilter.getXmlFileFilter()) {
            return ProducerFactory.ImportType.XML;
        }
        if (fileFilter == ExtensionFileFilter.getTextFileFilter()) {
            return ProducerFactory.ImportType.Text;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.importOptions == null) {
            return;
        }
        if (propertyChangeEvent.getSource() instanceof JFileChooser && !this.filterChange) {
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (!(fileFilter instanceof ExtensionFileFilter)) return;
            ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)fileFilter;
            this.importOptions.setImportType(this.getImportType(extensionFileFilter));
            return;
        }
        if (propertyChangeEvent.getSource() != this.importOptions) return;
        if (this.chooser == null) return;
        try {
            FileFilter fileFilter = this.chooser.getFileFilter();
            if (!(fileFilter instanceof ExtensionFileFilter)) {
                return;
            }
            ProducerFactory.ImportType importType = (ProducerFactory.ImportType)((Object)propertyChangeEvent.getNewValue());
            this.filterChange = true;
            switch (importType) {
                case XML: {
                    this.chooser.setFileFilter(ExtensionFileFilter.getXmlFileFilter());
                    return;
                }
                case Text: {
                    this.chooser.setFileFilter(ExtensionFileFilter.getTextFileFilter());
                    return;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error: ", throwable);
            return;
        }
        finally {
            this.filterChange = false;
        }
    }
}

