/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.export;

import java.awt.Component;
import workbench.db.exporter.DataExporter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.dialogs.export.ExportFileDialog;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class DataStoreExporter {
    private DataStore source;
    private Component caller;
    private ExportFileDialog dialog;
    private WbFile output;
    private String configKey;

    public DataStoreExporter(DataStore dataStore, Component component) {
        this(dataStore, component, null);
    }

    public DataStoreExporter(DataStore dataStore, Component component, String string) {
        this.caller = component;
        this.source = dataStore;
        this.configKey = StringUtil.trimToNull(string);
    }

    public void saveAs() {
        this.dialog = new ExportFileDialog(this.caller, this.source);
        this.dialog.setSelectDirectoryOnly(false);
        if (this.configKey != null) {
            this.dialog.setConfigKey(this.configKey);
        }
        this.output = null;
        boolean bl = this.dialog.selectOutput();
        if (bl) {
            this.output = new WbFile(this.dialog.getSelectedFilename());
            this.writeFile();
            if (this.dialog.doOpenFile()) {
                this.dialog.openOutputFile();
            }
        }
    }

    public DataStore getSource() {
        return this.source;
    }

    public void setSource(DataStore dataStore) {
        this.source = dataStore;
    }

    private void writeFile() {
        if (this.source == null) {
            return;
        }
        if (this.output == null) {
            throw new NullPointerException("No outputfile defined");
        }
        DataExporter dataExporter = new DataExporter(this.source.getOriginalConnection());
        this.dialog.setExporterOptions(dataExporter);
        try {
            CharSequence charSequence;
            dataExporter.startExport(this.output, this.source, this.dialog.getColumnsToExport());
            if (!dataExporter.isSuccess() && (charSequence = dataExporter.getErrors()) != null) {
                WbSwingUtilities.showErrorMessage(this.caller, charSequence.toString());
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error writing export file", exception);
            WbSwingUtilities.showErrorMessage(this.caller, ExceptionUtil.getDisplay(exception));
        }
    }
}

