/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.export;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import workbench.db.ColumnIdentifier;
import workbench.db.WbConnection;
import workbench.db.exporter.ExportType;
import workbench.db.exporter.PoiHelper;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ColumnSelectorPanel;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.WbFilePicker;
import workbench.gui.dialogs.export.ExportOptions;
import workbench.gui.dialogs.export.GeneralExportOptionsPanel;
import workbench.gui.dialogs.export.HtmlOptions;
import workbench.gui.dialogs.export.HtmlOptionsPanel;
import workbench.gui.dialogs.export.SpreadSheetOptions;
import workbench.gui.dialogs.export.SpreadSheetOptionsPanel;
import workbench.gui.dialogs.export.SqlOptions;
import workbench.gui.dialogs.export.SqlOptionsPanel;
import workbench.gui.dialogs.export.TextOptions;
import workbench.gui.dialogs.export.TextOptionsPanel;
import workbench.gui.dialogs.export.XmlOptions;
import workbench.gui.dialogs.export.XmlOptionsPanel;
import workbench.interfaces.EncodingSelector;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ExportOptionsPanel
extends JPanel
implements EncodingSelector,
ActionListener,
ValidatingComponent,
PropertyChangeListener {
    private GeneralExportOptionsPanel generalOptions;
    private JPanel typeOptionsPanel;
    private CardLayout card;
    private WbFilePicker picker;
    private JCheckBox openFile;
    private JComboBox typeSelector;
    private JLabel pickerLabel;
    private JPanel pickerPanel;
    private TextOptionsPanel textOptions;
    private SqlOptionsPanel sqlOptions;
    private HtmlOptionsPanel htmlOptions;
    private XmlOptionsPanel xmlOptions;
    private SpreadSheetOptionsPanel odsOptions;
    private SpreadSheetOptionsPanel xlsOptions;
    private SpreadSheetOptionsPanel xlsmOptions;
    private SpreadSheetOptionsPanel xlsxOptions;
    private ExportType currentType;
    private List<ColumnIdentifier> selectedColumns;
    private Object columnSelectEventSource;
    private ColumnSelectorPanel columnSelectorPanel;
    private ResultInfo dataStoreColumns;
    private String query;
    private WbConnection dbConnection;
    private boolean poiAvailable = false;
    private boolean xlsxAvailable = false;
    private boolean allowOpenFile = true;
    private final String ODS_ITEM = ResourceMgr.getString("TxtOdsName");
    private final String XLS_ITEM = ResourceMgr.getString("TxtXlsName");
    private final String XLSM_ITEM = "Excel XML Spreadsheet (xml)";
    private final String XLSX_ITEM = "Excel Workbook (xlsx)";

    public ExportOptionsPanel() {
        this((ResultInfo)null);
    }

    public ExportOptionsPanel(ResultInfo resultInfo) {
        this.setLayout(new BorderLayout());
        this.poiAvailable = PoiHelper.isPoiAvailable();
        this.xlsxAvailable = PoiHelper.isXLSXAvailable();
        this.picker = new WbFilePicker(true);
        this.picker.addPropertyChangeListener("filename", this);
        this.typeSelector = new JComboBox();
        this.typeSelector.addItem("Text");
        this.typeSelector.addItem("SQL");
        this.typeSelector.addItem("XML");
        this.typeSelector.addItem("JSON");
        this.typeSelector.addItem(this.ODS_ITEM);
        this.typeSelector.addItem("HTML");
        if (this.poiAvailable) {
            this.typeSelector.addItem(this.XLS_ITEM);
        }
        this.typeSelector.addItem("Excel XML Spreadsheet (xml)");
        if (this.xlsxAvailable) {
            this.typeSelector.addItem("Excel Workbook (xlsx)");
        }
        this.pickerPanel = this.createPickerPanel();
        boolean bl = resultInfo != null;
        this.dataStoreColumns = resultInfo;
        this.generalOptions = new GeneralExportOptionsPanel();
        this.generalOptions.allowSelectColumns(bl);
        if (bl) {
            this.generalOptions.showSelectColumnsLabel();
            this.columnSelectEventSource = this.generalOptions.addColumnSelectListener(this);
        }
        int n = IconMgr.getInstance().getSizeForLabel() / 2;
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.pickerPanel, "First");
        jPanel.add((Component)this.generalOptions, "Center");
        this.add((Component)jPanel, "First");
        this.textOptions = new TextOptionsPanel();
        this.typeOptionsPanel = new JPanel();
        this.card = new CardLayout();
        this.typeOptionsPanel.setLayout(this.card);
        this.typeOptionsPanel.add((Component)this.textOptions, "text");
        this.sqlOptions = new SqlOptionsPanel(resultInfo);
        this.typeOptionsPanel.add((Component)this.sqlOptions, "sql");
        this.xmlOptions = new XmlOptionsPanel();
        this.typeOptionsPanel.add((Component)this.xmlOptions, "xml");
        this.odsOptions = new SpreadSheetOptionsPanel("ods");
        this.typeOptionsPanel.add((Component)this.odsOptions, "ods");
        this.htmlOptions = new HtmlOptionsPanel();
        this.typeOptionsPanel.add((Component)this.htmlOptions, "html");
        this.xlsmOptions = new SpreadSheetOptionsPanel("xlsm");
        this.typeOptionsPanel.add((Component)this.xlsmOptions, "xlsm");
        this.typeOptionsPanel.add((Component)new JPanel(), "empty");
        if (this.poiAvailable) {
            this.xlsOptions = new SpreadSheetOptionsPanel("xls");
            this.typeOptionsPanel.add((Component)this.xlsOptions, "xls");
        }
        if (this.xlsxAvailable) {
            this.xlsxOptions = new SpreadSheetOptionsPanel("xlsx");
            this.typeOptionsPanel.add((Component)this.xlsxOptions, "xlsx");
        }
        this.add((Component)this.typeOptionsPanel, "Center");
        this.typeSelector.addActionListener(this);
    }

    public void setExportInfo(String string) {
        if (StringUtil.isNonBlank(string)) {
            int n = IconMgr.getInstance().getSizeForLabel() / 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 0, n, 0);
            this.pickerPanel.add((Component)new JLabel(ResourceMgr.getFormattedString("LblExportInfo", string)), gridBagConstraints);
        }
    }

    public void setAllowOpenFile(boolean bl) {
        this.allowOpenFile = bl;
        this.openFile.setEnabled(bl);
        if (!this.openFile.isEnabled()) {
            this.openFile.setSelected(false);
        }
    }

    private JPanel createPickerPanel() {
        int n = IconMgr.getInstance().getSizeForLabel() / 2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.pickerLabel = new JLabel(ResourceMgr.getString("LblExportOutput"));
        JLabel jLabel = new JLabel(ResourceMgr.getString("LblExportType"));
        this.openFile = new JCheckBox(ResourceMgr.getString("LblExportOpenOutput"));
        this.openFile.setMargin(new Insets(0, 0, 0, 0));
        boolean bl = this.allowOpenFile && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
        this.openFile.setEnabled(bl);
        if (!bl) {
            this.openFile.setSelected(false);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, n);
        jPanel.add((Component)this.pickerLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.picker, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, n, 0, n);
        jPanel.add((Component)this.openFile, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(n, 0, 0, 0);
        jPanel.add((Component)this.typeSelector, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(n, 0, n, 0);
        jPanel.add((Component)new JSeparator(0), gridBagConstraints);
        return jPanel;
    }

    public void setSelectDirectoriesOnly(boolean bl) {
        this.picker.setSelectDirectoryOnly(bl);
        if (this.pickerLabel != null) {
            String string = bl ? ResourceMgr.getString("LblExportOutputDir") : ResourceMgr.getString("LblExportOutput");
            this.pickerLabel.setText(string);
        }
    }

    public void setLastDirProperty(String string) {
        this.picker.setLastDirProperty(string);
    }

    public boolean doOpenFile() {
        return this.openFile.isEnabled() && this.openFile.isSelected();
    }

    public File getSelectedFile() {
        return this.picker.getSelectedFile();
    }

    public FileFilter getFileFilter() {
        return this.picker.getFileFilter();
    }

    @Override
    public boolean validateInput() {
        if (this.getSelectedFile() == null) {
            WbSwingUtilities.showErrorMessageKey(this, "ErrExportOutputFileRequired");
            return false;
        }
        return true;
    }

    @Override
    public void componentDisplayed() {
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.picker) {
            File file = this.picker.getSelectedFile();
            boolean bl = file != null;
            this.firePropertyChange("editorValid", false, bl);
            if (file != null) {
                WbFile wbFile = new WbFile(file);
                String string = wbFile.getFullPath();
                FileFilter fileFilter = this.picker.getFileFilter();
                if (!this.picker.getSelectDirectoryOnly() && fileFilter instanceof ExtensionFileFilter) {
                    ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)fileFilter;
                    String string2 = ExtensionFileFilter.getExtension(wbFile);
                    if (StringUtil.isEmptyString(string2)) {
                        if (!string.endsWith(".")) {
                            string = string + ".";
                        }
                        string = string + extensionFileFilter.getDefaultExtension();
                        wbFile = new WbFile(string);
                        this.picker.setSelectedFile(wbFile);
                    }
                }
            }
        }
    }

    public void updateSqlOptions(DataStore dataStore) {
        WbConnection wbConnection = dataStore == null ? null : dataStore.getOriginalConnection();
        this.dataStoreColumns = dataStore == null ? null : dataStore.getResultInfo();
        boolean bl = dataStore != null && dataStore.canSaveAsSqlInsert();
        boolean bl2 = dataStore != null && dataStore.hasPkColumns();
        this.sqlOptions.setIncludeUpdate(bl2);
        this.sqlOptions.setIncludeDeleteInsert(bl && bl2);
        this.sqlOptions.setIncludeMerge(bl && bl2);
        if (wbConnection != null) {
            this.sqlOptions.setDbId(wbConnection.getDbId());
        }
    }

    public void setQuerySql(String string, WbConnection wbConnection) {
        this.query = string;
        this.dbConnection = wbConnection;
        this.dataStoreColumns = null;
        this.generalOptions.allowSelectColumns(true);
        this.generalOptions.showRetrieveColumnsLabel();
        if (this.columnSelectEventSource == null) {
            this.columnSelectEventSource = this.generalOptions.addColumnSelectListener(this);
        }
    }

    public void setIncludeMerge(boolean bl) {
        this.sqlOptions.setIncludeMerge(bl);
    }

    public void setIncludeSqlUpdate(boolean bl) {
        this.sqlOptions.setIncludeUpdate(bl);
    }

    public void setIncludeSqlDeleteInsert(boolean bl) {
        this.sqlOptions.setIncludeDeleteInsert(bl);
    }

    public List<ColumnIdentifier> getColumnsToExport() {
        return this.selectedColumns;
    }

    public void saveSettings() {
        this.generalOptions.saveSettings();
        this.sqlOptions.saveSettings();
        this.textOptions.saveSettings();
        this.htmlOptions.saveSettings();
        this.xmlOptions.saveSettings();
        this.odsOptions.saveSettings();
        this.xlsmOptions.saveSettings();
        if (this.xlsOptions != null) {
            this.xlsOptions.saveSettings();
        }
        if (this.xlsxOptions != null) {
            this.xlsxOptions.saveSettings();
        }
        Settings.getInstance().setProperty("workbench.export.type", this.currentType.getCode());
        Settings.getInstance().setProperty("workbench.export.open.output", this.doOpenFile());
    }

    public void restoreSettings() {
        this.generalOptions.restoreSettings();
        this.sqlOptions.restoreSettings();
        this.textOptions.restoreSettings();
        this.htmlOptions.restoreSettings();
        this.xmlOptions.restoreSettings();
        this.odsOptions.restoreSettings();
        this.xlsmOptions.restoreSettings();
        if (this.xlsOptions != null) {
            this.xlsOptions.restoreSettings();
        }
        if (this.xlsxOptions != null) {
            this.xlsxOptions.restoreSettings();
        }
        String string = Settings.getInstance().getProperty("workbench.export.type", ExportType.TEXT.getCode());
        ExportType exportType = ExportType.getTypeFromCode(string);
        this.setExportType(exportType);
        boolean bl = Settings.getInstance().getBoolProperty("workbench.export.open.output", false);
        if (this.openFile.isEnabled()) {
            this.openFile.setSelected(bl);
        }
    }

    public void setExportType(ExportType exportType) {
        if (exportType == null) {
            this.setTypeText();
            return;
        }
        switch (exportType) {
            case HTML: {
                this.setTypeHtml();
                break;
            }
            case SQL_INSERT: 
            case SQL_UPDATE: 
            case SQL_DELETE_INSERT: 
            case SQL_MERGE: {
                this.setTypeSql();
                break;
            }
            case TEXT: {
                this.setTypeText();
                break;
            }
            case XML: {
                this.setTypeXml();
                break;
            }
            case ODS: {
                this.setTypeOds();
                break;
            }
            case JSON: {
                this.setTypeJson();
                break;
            }
            case XLSM: {
                this.setTypeXlsM();
                break;
            }
            case XLSX: {
                if (!this.xlsxAvailable) break;
                this.setTypeXlsX();
                break;
            }
            case XLS: {
                if (!this.poiAvailable) break;
                this.setTypeXls();
            }
        }
    }

    public ExportType getExportType() {
        return this.currentType;
    }

    private void showTextOptions() {
        this.card.show(this.typeOptionsPanel, "text");
        this.picker.setFileFilter(ExtensionFileFilter.getTextFileFilter());
    }

    public void setTypeText() {
        this.showTextOptions();
        this.currentType = ExportType.TEXT;
        this.typeSelector.setSelectedItem("Text");
    }

    private void showSqlOptions() {
        this.card.show(this.typeOptionsPanel, "sql");
        this.picker.setFileFilter(ExtensionFileFilter.getSqlFileFilter());
    }

    public void setTypeSql() {
        this.showSqlOptions();
        this.currentType = ExportType.SQL_INSERT;
        this.typeSelector.setSelectedItem("SQL");
    }

    private void showXmlOptions() {
        this.card.show(this.typeOptionsPanel, "xml");
        this.picker.setFileFilter(ExtensionFileFilter.getXmlFileFilter());
    }

    public void setTypeXml() {
        this.showXmlOptions();
        this.currentType = ExportType.XML;
        this.typeSelector.setSelectedItem("XML");
    }

    private void showJsonOption() {
        this.card.show(this.typeOptionsPanel, "empty");
        this.picker.setFileFilter(ExtensionFileFilter.getJsonFilterFilter());
    }

    private void showHtmlOptions() {
        this.card.show(this.typeOptionsPanel, "html");
        this.picker.setFileFilter(ExtensionFileFilter.getHtmlFileFilter());
    }

    public void setTypeHtml() {
        this.showHtmlOptions();
        this.currentType = ExportType.HTML;
        this.typeSelector.setSelectedItem("HTML");
    }

    private void showOdsOptions() {
        this.card.show(this.typeOptionsPanel, "ods");
        this.picker.setFileFilter(ExtensionFileFilter.getOdsFileFilter());
    }

    public void setTypeOds() {
        this.showOdsOptions();
        this.currentType = ExportType.ODS;
        this.typeSelector.setSelectedItem(this.ODS_ITEM);
    }

    private void showXlsOptions() {
        this.card.show(this.typeOptionsPanel, "xls");
        this.picker.setFileFilter(ExtensionFileFilter.getXlsFileFilter());
    }

    private void showXlsXOptions() {
        this.card.show(this.typeOptionsPanel, "xlsx");
        this.picker.setFileFilter(ExtensionFileFilter.getXlsXFileFilter());
    }

    private void showXlsMOptions() {
        this.card.show(this.typeOptionsPanel, "xlsm");
        this.picker.setFileFilter(ExtensionFileFilter.getXlsMFileFilter());
    }

    public void setTypeXls() {
        this.showXlsOptions();
        this.currentType = ExportType.XLS;
        this.typeSelector.setSelectedItem(this.XLS_ITEM);
    }

    public void setTypeXlsX() {
        this.showXlsXOptions();
        this.currentType = ExportType.XLSX;
        this.typeSelector.setSelectedItem("Excel Workbook (xlsx)");
    }

    public void setTypeJson() {
        this.showJsonOption();
        this.currentType = ExportType.JSON;
        this.typeSelector.setSelectedItem("JSON");
    }

    public void setTypeXlsM() {
        this.showXlsMOptions();
        this.currentType = ExportType.XLSM;
        this.typeSelector.setSelectedItem("Excel XML Spreadsheet (xml)");
    }

    public SpreadSheetOptions getXlsMOptions() {
        return this.xlsmOptions;
    }

    public SpreadSheetOptions getXlsOptions() {
        return this.xlsOptions;
    }

    public SpreadSheetOptions getXlsXOptions() {
        return this.xlsxOptions;
    }

    public SpreadSheetOptions getOdsOptions() {
        return this.odsOptions;
    }

    public XmlOptions getXmlOptions() {
        return this.xmlOptions;
    }

    public HtmlOptions getHtmlOptions() {
        return this.htmlOptions;
    }

    public SqlOptions getSqlOptions() {
        return this.sqlOptions;
    }

    public ExportOptions getExportOptions() {
        return this.generalOptions;
    }

    public TextOptions getTextOptions() {
        return this.textOptions;
    }

    @Override
    public String getEncoding() {
        return this.generalOptions.getEncoding();
    }

    @Override
    public void setEncoding(String string) {
        this.generalOptions.setEncoding(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.typeSelector) {
            Object object = this.typeSelector.getSelectedItem();
            String string = object.toString();
            ExportType exportType = null;
            this.card.show(this.typeOptionsPanel, string);
            if ("text".equalsIgnoreCase(string)) {
                exportType = ExportType.TEXT;
                this.showTextOptions();
            } else if ("sql".equalsIgnoreCase(string)) {
                exportType = ExportType.SQL_INSERT;
                this.showSqlOptions();
            } else if ("xml".equalsIgnoreCase(string)) {
                exportType = ExportType.XML;
                this.showXmlOptions();
            } else if (object == this.ODS_ITEM) {
                exportType = ExportType.ODS;
                this.showOdsOptions();
            } else if (object == "Excel Workbook (xlsx)" && this.xlsxAvailable) {
                exportType = ExportType.XLSX;
                this.showXlsXOptions();
            } else if (object == this.XLS_ITEM && this.poiAvailable) {
                exportType = ExportType.XLS;
                this.showXlsOptions();
            } else if (object == "Excel XML Spreadsheet (xml)") {
                exportType = ExportType.XLSM;
                this.showXlsMOptions();
            } else if ("html".equalsIgnoreCase(string)) {
                exportType = ExportType.HTML;
                this.showHtmlOptions();
            } else if ("json".equalsIgnoreCase(string)) {
                exportType = ExportType.JSON;
                this.showJsonOption();
            }
            this.currentType = exportType;
            this.firePropertyChange("exportType", null, (Object)exportType);
        } else if (actionEvent.getSource() == this.columnSelectEventSource) {
            this.selectColumns();
        }
    }

    private void retrieveQueryColumns() {
        try {
            WbSwingUtilities.showWaitCursor(this);
            this.dataStoreColumns = SqlUtil.getResultInfoFromQuery(this.query, this.dbConnection);
            this.sqlOptions.setResultInfo(this.dataStoreColumns);
        }
        catch (Exception exception) {
            this.dataStoreColumns = null;
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve query columns", exception);
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    private void selectColumns() {
        if (this.dataStoreColumns == null && this.query != null) {
            this.retrieveQueryColumns();
        }
        if (this.dataStoreColumns == null) {
            return;
        }
        if (this.columnSelectorPanel == null) {
            this.columnSelectorPanel = new ColumnSelectorPanel(this.dataStoreColumns.getColumns());
            this.columnSelectorPanel.selectAll();
        } else {
            this.columnSelectorPanel.selectColumns(this.selectedColumns);
        }
        int n = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), this.columnSelectorPanel, ResourceMgr.getString("MsgSelectColumnsWindowTitle"), 2, -1);
        if (n == 0) {
            this.selectedColumns = this.columnSelectorPanel.getSelectedColumns();
        }
    }
}

