/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import workbench.gui.WbSwingUtilities;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.editor.SyntaxStyle;
import workbench.gui.editor.SyntaxUtilities;
import workbench.gui.editor.Token;
import workbench.gui.editor.TokenMarker;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.util.NumberStringCache;
import workbench.util.StringUtil;

public class TextAreaPainter
extends JComponent
implements TabExpander,
PropertyChangeListener {
    private final Segment currentLine;
    protected JEditTextArea textArea;
    protected SyntaxStyle[] styles;
    protected Color caretColor;
    protected Color selectionColor;
    protected Color currentLineColor;
    protected Color bracketHighlightColor;
    protected Color occuranceHighlightColor;
    protected boolean bracketHighlight;
    protected boolean matchBeforeCaret;
    protected boolean bracketHighlightRec;
    protected boolean bracketHighlightBoth;
    protected boolean selectionHighlightIgnoreCase;
    private final int cursorWidth = GuiSettings.getCaretWidth();
    protected int tabSize = -1;
    protected boolean showLineNumbers;
    protected int gutterWidth = 0;
    protected static final int GUTTER_MARGIN = 2;
    private Color gutterBackground = new Color(238, 240, 238);
    public static final Color DEFAULT_SELECTION_COLOR = new Color(204, 204, 255);
    private Color gutterTextColor = Color.DARK_GRAY;
    private final Object stylesLockMonitor = new Object();
    private String highlighText;
    private Map renderingHints;
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(2);

    public TextAreaPainter(JEditTextArea jEditTextArea) {
        this.textArea = jEditTextArea;
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.currentLine = new Segment();
        super.setCursor(DEFAULT_CURSOR);
        super.setFont(Settings.getInstance().getEditorFont());
        this.readBracketSettings();
        this.setColors();
        this.selectionHighlightIgnoreCase = Settings.getInstance().getSelectionHighlightIgnoreCase();
        this.showLineNumbers = Settings.getInstance().getShowLineNumbers();
        Settings.getInstance().addPropertyChangeListener(this, "workbench.editor.tabwidth", "workbench.editor.color.foreground", "workbench.editor.color.background", "workbench.editor.color.cursor", "workbench.editor.currentline.color", "workbench.editor.color.selection", "workbench.editor.occurance.highlight.color", "workbench.editor.occurance.highlight.casesensitive", "workbench.editor.bracket.hilite.enable", "workbench.editor.bracket.hilite.color", "workbench.editor.bracket.hilite.left", "workbench.editor.bracket.hilite.rectangle", "workbench.editor.bracket.hilite.both", "workbench.editor.color.comment1", "workbench.editor.color.comment2", "workbench.editor.color.keyword1", "workbench.editor.color.keyword2", "workbench.editor.color.keyword3", "workbench.editor.color.literal1", "workbench.editor.color.literal2", "workbench.editor.color.operator", "workbench.editor.color.datatype", "workbench.editor.syntax.style.comment1", "workbench.editor.syntax.style.comment2", "workbench.editor.syntax.style.keyword1", "workbench.editor.syntax.style.keyword2", "workbench.editor.syntax.style.keyword3", "workbench.editor.syntax.style.literal1", "workbench.editor.syntax.style.literal2", "workbench.editor.syntax.style.operator", "workbench.editor.syntax.style.datatype", "workbench.editor.showlinenumber");
        if (Settings.getInstance().getBoolProperty("workbench.editor.desktophints.enabled", true)) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.renderingHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (cursor != null && cursor.equals(Cursor.getPredefinedCursor(3))) {
            super.setCursor(cursor);
        } else {
            super.setCursor(DEFAULT_CURSOR);
        }
    }

    public void setHighlightValue(String string) {
        boolean bl = false;
        if (StringUtil.isNonBlank(string)) {
            bl = StringUtil.stringsAreNotEqual(this.highlighText, string);
            this.highlighText = string;
        } else {
            bl = this.highlighText != null;
            this.highlighText = null;
        }
        if (bl) {
            this.invalidateVisibleLines();
        }
    }

    public void dispose() {
        Settings.getInstance().removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("workbench.editor.tabwidth".equals(propertyChangeEvent.getPropertyName())) {
            if (this.textArea != null) {
                this.textArea.setTabSize(Settings.getInstance().getEditorTabWidth());
            }
            WbSwingUtilities.invoke(this::calculateTabSize);
        } else if ("workbench.editor.showlinenumber".equals(propertyChangeEvent.getPropertyName())) {
            this.showLineNumbers = Settings.getInstance().getShowLineNumbers();
        } else if (propertyChangeEvent.getPropertyName().startsWith("workbench.editor.bracket.hilite")) {
            this.readBracketSettings();
            this.textArea.invalidateBracketLine();
        } else if ("workbench.editor.occurance.highlight.casesensitive".equals(propertyChangeEvent.getPropertyName())) {
            this.selectionHighlightIgnoreCase = Settings.getInstance().getSelectionHighlightIgnoreCase();
        } else {
            WbSwingUtilities.invoke(this::setColors);
        }
        this.invalidate();
        WbSwingUtilities.repaintLater(this);
    }

    private void readBracketSettings() {
        this.bracketHighlight = Settings.getInstance().isBracketHighlightEnabled();
        this.matchBeforeCaret = Settings.getInstance().getBracketHighlightLeft();
        this.bracketHighlightColor = Settings.getInstance().getEditorBracketHighlightColor();
        this.bracketHighlightRec = Settings.getInstance().getBracketHighlightRectangle();
        this.bracketHighlightBoth = this.bracketHighlight && Settings.getInstance().getBracketHighlightBoth();
    }

    private Color getDefaultColor(String string, Color color) {
        Color color2 = UIManager.getColor(string);
        return color2 == null ? color : color2;
    }

    private void setColors() {
        Color color = Settings.getInstance().getEditorTextColor();
        if (color == null) {
            color = this.getDefaultColor("TextArea.foreground", Color.BLACK);
        }
        this.setForeground(color);
        Color color2 = Settings.getInstance().getEditorBackgroundColor();
        if (color2 == null) {
            color2 = this.getDefaultColor("TextArea.background", Color.WHITE);
        }
        this.setBackground(color2);
        if (!color.equals(Color.BLACK) && !color2.equals(Color.WHITE)) {
            this.gutterBackground = color2.darker();
            this.gutterTextColor = color.brighter();
        }
        this.setStyles(SyntaxUtilities.getDefaultSyntaxStyles());
        this.caretColor = Settings.getInstance().getEditorCursorColor();
        this.currentLineColor = Settings.getInstance().getEditorCurrentLineColor();
        this.bracketHighlightColor = Settings.getInstance().getEditorBracketHighlightColor();
        this.occuranceHighlightColor = Settings.getInstance().geSelectionHighlightColor();
        this.selectionColor = Settings.getInstance().getEditorSelectionColor();
        if (this.selectionColor == null) {
            this.selectionColor = this.getDefaultColor("TextArea.selectionBackground", DEFAULT_SELECTION_COLOR);
        }
    }

    @Override
    public boolean isManagingFocus() {
        return false;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public FontMetrics getStyleFontMetrics(byte by) {
        if (by == 0 || this.styles == null || by < 0 || by >= this.styles.length) {
            return this.getFontMetrics();
        }
        return this.getFontMetrics(this.styles[by].getStyledFont(this.getFont()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntaxStyle[] getStyles() {
        Object object = this.stylesLockMonitor;
        synchronized (object) {
            return this.styles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyles(SyntaxStyle[] syntaxStyleArray) {
        Object object = this.stylesLockMonitor;
        synchronized (object) {
            this.styles = new SyntaxStyle[syntaxStyleArray.length];
            System.arraycopy(syntaxStyleArray, 0, this.styles, 0, syntaxStyleArray.length);
        }
        this.repaint();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateLineRange(0, this.textArea.getLineCount());
    }

    @Override
    public void validate() {
        super.validate();
        this.invalidateLineRange(0, this.textArea.getLineCount());
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final void setCaretColor(Color color) {
        this.caretColor = color;
        this.invalidateSelectedLines();
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(Color color) {
        this.selectionColor = color;
        this.invalidateSelectedLines();
    }

    public final boolean isBracketHighlightEnabled() {
        return this.bracketHighlight;
    }

    public final void setBracketHighlightEnabled(boolean bl) {
        this.bracketHighlight = bl;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font font) {
        super.setFont(font);
        Object object = this.stylesLockMonitor;
        synchronized (object) {
            if (this.styles != null) {
                for (SyntaxStyle syntaxStyle : this.styles) {
                    if (syntaxStyle == null) continue;
                    syntaxStyle.clearFontCache();
                }
            }
        }
        this.calculateTabSize();
        this.calculateGutterWidth(this.getFontMetrics(font));
    }

    private void calculateGutterWidth(Graphics graphics) {
        FontMetrics fontMetrics = null;
        if (graphics != null) {
            fontMetrics = graphics.getFontMetrics();
        }
        if (fontMetrics == null) {
            fontMetrics = this.getFontMetrics();
        }
        this.calculateGutterWidth(fontMetrics);
    }

    private void calculateGutterWidth(FontMetrics fontMetrics) {
        if (this.showLineNumbers) {
            int n = this.textArea.getLineCount();
            String string = NumberStringCache.getNumberString(n);
            this.gutterWidth = fontMetrics.stringWidth(string) + 4;
        } else {
            this.gutterWidth = 0;
        }
    }

    public void calculateTabSize() {
        this.tabSize = -1;
        if (this.textArea == null) {
            return;
        }
        if (this.textArea.getDocument() == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics();
        if (fontMetrics == null) {
            return;
        }
        int n = Settings.getInstance().getEditorTabWidth();
        this.tabSize = fontMetrics.charWidth(' ') * n;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(this.getFont());
        this.calculateGutterWidth(graphics2D);
        FontMetrics fontMetrics = this.getFontMetrics();
        Rectangle rectangle = graphics2D.getClipBounds();
        int n2 = this.getWidth() - this.gutterWidth;
        int n3 = this.getHeight();
        int n4 = this.textArea.getLineCount();
        int n5 = this.textArea.getVisibleLines();
        int n6 = n = this.textArea.getFirstLine();
        int n7 = n + n5;
        int n8 = fontMetrics.getHeight();
        if (rectangle != null) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.showLineNumbers) {
                graphics2D.setColor(this.gutterBackground);
                graphics2D.fillRect(rectangle.x, rectangle.y, this.gutterWidth - rectangle.x, rectangle.height);
            }
            if ((n6 += rectangle.y / n8) > 1) {
                --n6;
            }
            n7 = n + (rectangle.y + rectangle.height) / n8;
        }
        if (this.renderingHints != null) {
            graphics2D.addRenderingHints(this.renderingHints);
        }
        n7 = n7 > n4 ? n4 : ++n7;
        Font font = graphics2D.getFont();
        Color color = this.getForeground();
        try {
            int n9 = this.textArea.getHorizontalOffset();
            int n10 = n + n5 + 1;
            if (n10 > n4) {
                n10 = n4;
            }
            int n11 = this.gutterWidth - 2;
            int n12 = this.textArea.getCaretLine();
            TokenMarker tokenMarker = this.textArea.getDocument().getTokenMarker();
            for (int i = n; i <= n10; ++i) {
                String string;
                int n13 = this.textArea.lineToY(i);
                if (this.showLineNumbers) {
                    string = NumberStringCache.getNumberString(i);
                    int n14 = fontMetrics.stringWidth(string);
                    graphics2D.setClip(0, 0, this.gutterWidth, n3);
                    graphics2D.setColor(this.gutterTextColor);
                    graphics2D.drawString(string, n11 - n14, n13);
                }
                if (i < n6 || i >= n7) continue;
                if (this.showLineNumbers) {
                    graphics2D.setClip(this.gutterWidth, 0, n2, n3);
                    graphics2D.translate(this.gutterWidth, 0);
                }
                this.textArea.getLineText(i, this.currentLine);
                String string2 = string = tokenMarker == null ? null : tokenMarker.markTokens(this.currentLine, i);
                if (i == n12) {
                    if (this.currentLineColor != null) {
                        graphics2D.setColor(this.currentLineColor);
                        graphics2D.fillRect(0, n13 + fontMetrics.getMaxDescent(), n2, n8);
                        graphics2D.setColor(this.getBackground());
                    }
                    this.paintCaret(graphics2D, this.currentLine, i, n13 + fontMetrics.getMaxDescent(), n8, (Token)((Object)string));
                }
                if (tokenMarker == null) {
                    this.paintPlainLine(graphics2D, this.currentLine, i, font, color, n9, n13);
                } else {
                    this.paintSyntaxLine(graphics2D, this.currentLine, (Token)((Object)string), i, font, color, n9, n13);
                }
                if (!this.showLineNumbers) continue;
                graphics2D.translate(-this.gutterWidth, 0);
                graphics2D.setClip(null);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error repainting line range {" + n6 + "," + n7 + "}", throwable);
        }
    }

    public final void invalidateLine(int n) {
        FontMetrics fontMetrics = this.getFontMetrics();
        this.repaint(0, this.textArea.lineToY(n) + fontMetrics.getMaxDescent(), this.getWidth(), fontMetrics.getHeight());
    }

    public int getGutterWidth() {
        return this.gutterWidth;
    }

    public final void invalidateLineRange(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        this.repaint(0, this.textArea.lineToY(n) + fontMetrics.getMaxDescent(), this.getWidth(), (n2 - n + 1) * fontMetrics.getHeight());
    }

    public void invalidateVisibleLines() {
        int n = this.textArea.getFirstLine();
        int n2 = n + this.textArea.getVisibleLines();
        this.invalidateLineRange(n, n2);
    }

    public final void invalidateSelectedLines() {
        this.invalidateLineRange(this.textArea.getSelectionStartLine(), this.textArea.getSelectionEndLine());
    }

    @Override
    public float nextTabStop(float f, int n) {
        if (this.tabSize == -1) {
            this.calculateTabSize();
        }
        int n2 = this.textArea.getHorizontalOffset();
        int n3 = ((int)f - n2) / this.tabSize;
        return (n3 + 1) * this.tabSize + n2;
    }

    protected void paintPlainLine(Graphics2D graphics2D, Segment segment, int n, Font font, Color color, int n2, int n3) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.paintHighlight(graphics2D, segment, n, n3, null);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        Utilities.drawTabbedText(segment, n2, n3 += fontMetrics.getHeight(), (Graphics)graphics2D, (TabExpander)this, 0);
    }

    protected void paintSyntaxLine(Graphics2D graphics2D, Segment segment, Token token, int n, Font font, Color color, int n2, int n3) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.paintHighlight(graphics2D, segment, n, n3, token);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        SyntaxUtilities.paintSyntaxLine(segment, token, this.styles, this, graphics2D, n2, n3 += fontMetrics.getHeight(), 0);
    }

    protected void paintHighlight(Graphics2D graphics2D, Segment segment, int n, int n2, Token token) {
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D.getFont());
        int n3 = fontMetrics.getHeight();
        n2 += fontMetrics.getMaxDescent();
        if (n >= this.textArea.getSelectionStartLine() && n <= this.textArea.getSelectionEndLine()) {
            this.paintLineHighlight(graphics2D, segment, n, n2, n3, token);
        }
        if (this.bracketHighlight && n == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(graphics2D, segment, n, n2, n3, this.textArea.getBracketPosition(), token);
        }
        if (this.highlighText != null) {
            int n4 = SyntaxUtilities.findMatch(segment, this.highlighText, 0, this.selectionHighlightIgnoreCase);
            int n5 = this.textArea.getLineStartOffset(n);
            while (n4 > -1) {
                if (n4 + n5 != this.textArea.getSelectionStart()) {
                    int n6 = this.textArea.offsetToX(graphics2D, n, n4);
                    int n7 = this.textArea.offsetToX(graphics2D, n, n4 + this.highlighText.length()) - n6;
                    graphics2D.setColor(this.occuranceHighlightColor);
                    graphics2D.fillRect(n6, n2, n7, n3);
                    graphics2D.setColor(this.getBackground());
                }
                n4 = SyntaxUtilities.findMatch(segment, this.highlighText, n4 + 1, this.selectionHighlightIgnoreCase);
            }
        }
    }

    protected void paintLineHighlight(Graphics2D graphics2D, Segment segment, int n, int n2, int n3, Token token) {
        int n4;
        int n5;
        int n6;
        int n7 = this.textArea.getSelectionStart();
        if (n7 == (n6 = this.textArea.getSelectionEnd())) {
            return;
        }
        Color color = this.textArea.getAlternateSelectionColor();
        if (color != null) {
            graphics2D.setColor(color);
        } else {
            graphics2D.setColor(this.selectionColor);
        }
        int n8 = this.textArea.getSelectionStartLine();
        int n9 = this.textArea.getSelectionEndLine();
        int n10 = this.textArea.getLineStartOffset(n);
        if (this.textArea.isSelectionRectangular()) {
            int n11 = this.textArea.getLineLength(n);
            n5 = this.textArea.offsetToX(graphics2D, n, Math.min(n11, n7 - this.textArea.getLineStartOffset(n8)), token);
            if (n5 == (n4 = this.textArea.offsetToX(graphics2D, n, Math.min(n11, n6 - this.textArea.getLineStartOffset(n9)), token))) {
                ++n4;
            }
        } else if (n8 == n9) {
            n5 = this.textArea.offsetToX(graphics2D, n, n7 - n10, token);
            n4 = this.textArea.offsetToX(graphics2D, n, n6 - n10, token);
        } else if (n == n8) {
            n5 = this.textArea.offsetToX(graphics2D, n, n7 - n10, token);
            n4 = this.getWidth();
        } else if (n == n9) {
            n5 = 0;
            n4 = this.textArea.offsetToX(graphics2D, n, n6 - n10, token);
        } else {
            n5 = 0;
            n4 = this.getWidth();
        }
        graphics2D.fillRect(n5 > n4 ? n4 : n5, n2, n5 > n4 ? n5 - n4 : n4 - n5, n3);
    }

    protected void paintBracketHighlight(Graphics2D graphics2D, Segment segment, int n, int n2, int n3, int n4, Token token) {
        if (n4 == -1) {
            return;
        }
        int n5 = this.textArea.offsetToX(graphics2D, n, n4, token);
        if (n5 > 1) {
            --n5;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = fontMetrics.charWidth('(') + 1;
        if (this.bracketHighlightColor != null) {
            graphics2D.setColor(this.bracketHighlightColor);
            graphics2D.fillRect(n5, n2, n6, n3 - 1);
        }
        if (this.bracketHighlightRec) {
            graphics2D.setColor(this.getForeground());
            graphics2D.drawRect(n5, n2, n6, n3 - 1);
        }
    }

    protected void paintCaret(Graphics2D graphics2D, Segment segment, int n, int n2, int n3, Token token) {
        int n4;
        int n5 = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(n);
        if (this.bracketHighlightBoth && this.textArea.getBracketPosition() > -1) {
            n4 = Settings.getInstance().getBracketHighlightLeft();
            int n6 = n4 != 0 ? -1 : 0;
            this.paintBracketHighlight(graphics2D, segment, n, n2, n3, n5 + n6, token);
        }
        n4 = this.textArea.offsetToX(graphics2D, n, n5, token);
        if (this.textArea.isCaretVisible()) {
            graphics2D.setColor(this.caretColor);
            if (this.textArea.isOverwriteEnabled()) {
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                graphics2D.fillRect(n4, n2 + n3 - 2, fontMetrics.getMaxAdvance(), 2);
            } else {
                graphics2D.fillRect(n4, n2, this.cursorWidth, n3 - 1);
            }
        }
    }
}

