/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class TextUtilities {
    public static int findMatchingBracket(Document document, int n) throws BadLocationException {
        boolean bl;
        char c;
        if (document.getLength() == 0) {
            return -1;
        }
        char c2 = document.getText(n, 1).charAt(0);
        switch (c2) {
            case '(': {
                c = ')';
                bl = false;
                break;
            }
            case ')': {
                c = '(';
                bl = true;
                break;
            }
            case '[': {
                c = ']';
                bl = false;
                break;
            }
            case ']': {
                c = '[';
                bl = true;
                break;
            }
            case '{': {
                c = '}';
                bl = false;
                break;
            }
            case '}': {
                c = '{';
                bl = true;
                break;
            }
            default: {
                return -1;
            }
        }
        if (bl) {
            int n2 = 1;
            String string = document.getText(0, n);
            for (int i = n - 1; i >= 0; --i) {
                char c3 = string.charAt(i);
                if (c3 == c2) {
                    ++n2;
                    continue;
                }
                if (c3 != c || --n2 != 0) continue;
                return i;
            }
        } else {
            int n3 = 1;
            int n4 = document.getLength() - ++n;
            String string = document.getText(n, n4);
            for (int i = 0; i < n4; ++i) {
                char c4 = string.charAt(i);
                if (c4 == c2) {
                    ++n3;
                    continue;
                }
                if (c4 != c || --n3 != 0) continue;
                return i + n;
            }
        }
        return -1;
    }

    public static int findWordStart(String string, int n) {
        return TextUtilities.findWordStart(string, n, Settings.getInstance().getEditorNoWordSep());
    }

    public static int findWordStart(String string, int n, String string2) {
        if (n >= string.length()) {
            n = string.length();
        }
        if (n < 1) {
            return 0;
        }
        char c = string.charAt(n - 1);
        if (Character.isWhitespace(c)) {
            return TextUtilities.findWhitespaceBackwards(string, n - 1);
        }
        boolean bl = !Character.isLetterOrDigit(c) && string2.indexOf(c) == -1;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            c = string.charAt(i);
            if (!(bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1))) continue;
            n2 = i + 1;
            break;
        }
        return n2;
    }

    private static int findWhitespaceBackwards(CharSequence charSequence, int n) {
        if (charSequence == null) {
            return -1;
        }
        int n2 = charSequence.length();
        if (n2 == 0) {
            return -1;
        }
        if (n < 1) {
            return -1;
        }
        int n3 = n;
        char c = charSequence.charAt(n3);
        while (n3 > 1) {
            if (c > ' ') {
                return n3 + 1;
            }
            c = charSequence.charAt(--n3);
        }
        return -1;
    }

    public static int findWordEnd(String string, int n) {
        return TextUtilities.findWordEnd(string, n, Settings.getInstance().getEditorNoWordSep());
    }

    public static int findWordEnd(String string, int n, String string2) {
        if (n >= string.length()) {
            return string.length();
        }
        char c = string.charAt(n);
        if (Character.isWhitespace(c)) {
            return StringUtil.findFirstNonWhitespace(string, n, false);
        }
        boolean bl = !Character.isLetterOrDigit(c) && string2.indexOf(c) == -1;
        int n2 = string.length();
        for (int i = n; i < string.length(); ++i) {
            c = string.charAt(i);
            if (!(bl ^ (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1))) continue;
            n2 = i;
            break;
        }
        return n2;
    }
}

